/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class AcupressureTests {
    @BattleTest
    public static CompletableFuture<TestResult> testCanTargetAllyInDoubles(BattleTestHelper helper) {
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.ACUPRESSURE).build();
        Pokemon smoochum = helper.createDefaultPokemon(PixelmonSpecies.SMOOCHUM).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant attacker = helper.createParticipant(2, wynaut, smoochum);
        Pokemon clampearl = helper.createDefaultPokemon(PixelmonSpecies.CLAMPERL).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon whismur = helper.createDefaultPokemon(PixelmonSpecies.WHISMUR).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant defender = helper.createParticipant(2, clampearl, whismur);
        return helper.setupDoubleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(wynaut, 1, smoochum);
                attacker.attackOpponent(smoochum, 1);
                defender.attackOpponent(clampearl, 1);
                defender.attackOpponent(whismur, 1);
            });
            if (!attacker.asWrapper(smoochum).getBattleStats().isStatModified()) {
                return TestResult.failure("Acupressure could not target an ally.");
            }
            return TestResult.success();
        });
    }
}

