/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.item;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class WhiteHerbTests {
    @BattleTest
    public static CompletableFuture<TestResult> testWhiteHerbAndPartingShot(BattleTestHelper helper) {
        Pokemon torracat = helper.createDefaultPokemon(PixelmonSpecies.TORRACAT).ability(AbilityRegistry.BLAZE).moves(AttackRegistry.PARTING_SHOT).build();
        Pokemon litten = helper.createDefaultPokemon(PixelmonSpecies.LITTEN).ability(AbilityRegistry.BLAZE).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant partingShotUser = helper.createParticipant(torracat, litten);
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).heldItem(PixelmonItems.white_herb).build());
        return helper.setupSingleBattleBuilder(partingShotUser, wynaut).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                partingShotUser.attackOpponent(1);
                partingShotUser.switchPokemon(torracat, litten);
                wynaut.attackOpponent(1);
            });
            if (wynaut.asWrapper().hasHeldItem()) {
                return TestResult.failure("White Herb was not consumed after Parting Shot's stats change.");
            }
            if (wynaut.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("White Herb did not reset Attack stage to 0 after Parting Shot.");
            }
            if (wynaut.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("White Herb did not reset Special Attack stage to 0 after Parting Shot.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWhiteHerbAndKOStatBoostAbilities(BattleTestHelper helper) {
        Pokemon litten = helper.createDefaultPokemon(PixelmonSpecies.LITTEN).moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.NO_GUARD).level(1).build();
        Pokemon torracat = helper.createDefaultPokemon(PixelmonSpecies.TORRACAT).moves(AttackRegistry.PARTING_SHOT).ability(AbilityRegistry.BLAZE).build();
        TestParticipant koUser = helper.createParticipant(litten, torracat);
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.DRACO_METEOR).ability(AbilityRegistry.GRIM_NEIGH).heldItem(PixelmonItems.white_herb).build());
        return helper.setupSingleBattleBuilder(koUser, wynaut).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                koUser.attackOpponent(1);
                koUser.switchPokemon(litten, torracat);
            });
            if (wynaut.asWrapper().hasHeldItem()) {
                return TestResult.failure("White Herb was not consumed after Draco Meteor + Grim Neigh's stats change.");
            }
            if (wynaut.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) == -1) {
                return TestResult.failure("White Herb activated inbetween Draco Meteor + Grim Neigh, when it should activate afterwards.");
            }
            if (wynaut.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("White Herb did not reset Special Attack stage to 0 after Draco Meteor + Grim Neigh.");
            }
            return TestResult.success();
        });
    }

    @BattleTest(experimental=true)
    public static CompletableFuture<TestResult> testWhiteHerbAndDoubleIntimidateInDoubles(BattleTestHelper helper) {
        Pokemon litten1 = helper.createDefaultPokemon(PixelmonSpecies.LITTEN).moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.INTIMIDATE).build();
        Pokemon torracat = helper.createDefaultPokemon(PixelmonSpecies.TORRACAT).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.FINAL_GAMBIT).ability(AbilityRegistry.INTIMIDATE).build();
        Pokemon litten2 = helper.createDefaultPokemon(PixelmonSpecies.LITTEN).moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.INTIMIDATE).build();
        Pokemon landorus = helper.createDefaultPokemon(PixelmonSpecies.LANDORUS).form("therian").moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.INTIMIDATE).build();
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.RECYCLE).heldItem(PixelmonItems.white_herb).build();
        Pokemon fraxure = helper.createDefaultPokemon(PixelmonSpecies.FRAXURE).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant participant1 = helper.createParticipant(2, litten1, torracat, litten2, landorus);
        TestParticipant participant2 = helper.createParticipant(2, wynaut, fraxure);
        return helper.setupDoubleBattleBuilder(participant1, participant2).forceChance().start().thenApply(controller -> {
            PixelmonWrapper controlledWynaut = (PixelmonWrapper)participant2.controlledPokemon.get(0);
            controller.takeFullTurn();
            if (controlledWynaut.hasHeldItem()) {
                return TestResult.failure("White Herb was not consumed after multiple battle start Intimidates' stats changes.");
            }
            if (controlledWynaut.getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("White Herb did not reset Attack stage to 0 after multiple battle start Intimidates.");
            }
            controller.takeFullTurn(() -> {
                participant1.attackAutoTarget(litten1, 1);
                participant1.attackTarget(torracat, 2, litten1);
                participant2.attackAutoTarget(wynaut, 2);
                participant2.attackAutoTarget(fraxure, 1);
                participant1.switchPokemon(litten1, litten2);
                participant1.switchPokemon(torracat, landorus);
            });
            if (controlledWynaut.hasHeldItem()) {
                return TestResult.failure("White Herb was not consumed after multiple during battle Intimidates' stats change.");
            }
            if (controlledWynaut.getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("White Herb did not reset Attack stage to 0 after multiple during battle Intimidates.");
            }
            return TestResult.success();
        });
    }
}

