/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.item;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class WeaknessPolicyTests {
    private static final String SUPER_EFFECTIVE = "super effective";
    private static final String NON_SUPER_EFFECTIVE = "non-super effective";
    private static final String FIXED_DAMAGE = "fixed damage";

    @BattleTest
    public static CompletableFuture<TestResult> testWeaknessPolicyOnSuperEffectiveHit(BattleTestHelper helper) {
        TestParticipant holder = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.NATURAL_CURE).heldItem(PixelmonItems.weakness_policy).moves(AttackRegistry.SOFT_BOILED).build());
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUCARIO).ability(AbilityRegistry.JUSTIFIED).moves(AttackRegistry.AURA_SPHERE).build());
        return helper.setupSingleBattleBuilder(attacker, holder).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                holder.attackAutoTarget(1);
                attacker.attackAutoTarget(1);
            });
            String failure = WeaknessPolicyTests.testWeaknessPolicy(holder.asWrapper(), true, SUPER_EFFECTIVE);
            return failure.isEmpty() ? TestResult.success() : TestResult.failure(failure);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWeaknessPolicyIndividualEffectivenessInDoubles(BattleTestHelper helper) {
        Pokemon stunfiskPokemon = helper.createDefaultPokemon(PixelmonSpecies.STUNFISK).ability(AbilityRegistry.LIMBER).moves(AttackRegistry.EARTHQUAKE, AttackRegistry.SURF, AttackRegistry.DISCHARGE).build();
        Pokemon volcaronaPokemon = helper.createDefaultPokemon(PixelmonSpecies.VOLCARONA).ability(AbilityRegistry.SWARM).heldItem(PixelmonItems.weakness_policy).moves(AttackRegistry.ROOST).build();
        Pokemon zekromPokemon = helper.createDefaultPokemon(PixelmonSpecies.ZEKROM).ability(AbilityRegistry.TERAVOLT).heldItem(PixelmonItems.weakness_policy).moves(AttackRegistry.ROOST).build();
        Pokemon pyukumukuPokemon = helper.createDefaultPokemon(PixelmonSpecies.PYUKUMUKU).ability(AbilityRegistry.UNAWARE).heldItem(PixelmonItems.weakness_policy).moves(AttackRegistry.RECOVER).build();
        TestParticipant player1 = helper.createParticipant(2, stunfiskPokemon, volcaronaPokemon);
        TestParticipant player2 = helper.createParticipant(2, zekromPokemon, pyukumukuPokemon);
        return helper.setupDoubleBattleBuilder(player1, player2).forceChance().start().thenApply(controller -> {
            PixelmonWrapper zekrom = player2.asWrapper(zekromPokemon);
            PixelmonWrapper pyuk = player2.asWrapper(pyukumukuPokemon);
            PixelmonWrapper volc = player1.asWrapper(volcaronaPokemon);
            controller.takeFullTurn(() -> {
                player1.attackAutoTarget(stunfiskPokemon, 1);
                player1.attackAutoTarget(volcaronaPokemon, 1);
                player2.attackAutoTargetAll();
            });
            String failure = "";
            failure = WeaknessPolicyTests.testWeaknessPolicy(zekrom, true, SUPER_EFFECTIVE);
            if (!failure.isEmpty()) {
                return TestResult.failure(failure);
            }
            failure = WeaknessPolicyTests.testWeaknessPolicy(pyuk, false, NON_SUPER_EFFECTIVE);
            if (!failure.isEmpty()) {
                return TestResult.failure(failure);
            }
            failure = WeaknessPolicyTests.testWeaknessPolicy(volc, false, NON_SUPER_EFFECTIVE);
            if (!failure.isEmpty()) {
                return TestResult.failure(failure);
            }
            zekrom.setHeldItem(PixelmonItems.weakness_policy);
            zekrom.getBattleStats().clearBattleStats();
            controller.takeFullTurn(() -> {
                player1.attackAutoTarget(stunfiskPokemon, 3);
                player1.attackAutoTarget(volcaronaPokemon, 1);
                player2.attackAutoTargetAll();
            });
            failure = WeaknessPolicyTests.testWeaknessPolicy(zekrom, false, NON_SUPER_EFFECTIVE);
            if (!failure.isEmpty()) {
                return TestResult.failure(failure);
            }
            failure = WeaknessPolicyTests.testWeaknessPolicy(pyuk, true, SUPER_EFFECTIVE);
            if (!failure.isEmpty()) {
                return TestResult.failure(failure);
            }
            failure = WeaknessPolicyTests.testWeaknessPolicy(volc, false, NON_SUPER_EFFECTIVE);
            if (!failure.isEmpty()) {
                return TestResult.failure(failure);
            }
            pyuk.setHeldItem(PixelmonItems.weakness_policy);
            pyuk.getBattleStats().clearBattleStats();
            controller.takeFullTurn(() -> {
                player1.attackAutoTarget(stunfiskPokemon, 2);
                player1.attackAutoTarget(volcaronaPokemon, 1);
                player2.attackAutoTargetAll();
            });
            failure = WeaknessPolicyTests.testWeaknessPolicy(zekrom, false, NON_SUPER_EFFECTIVE);
            if (!failure.isEmpty()) {
                return TestResult.failure(failure);
            }
            failure = WeaknessPolicyTests.testWeaknessPolicy(pyuk, false, NON_SUPER_EFFECTIVE);
            if (!failure.isEmpty()) {
                return TestResult.failure(failure);
            }
            failure = WeaknessPolicyTests.testWeaknessPolicy(volc, true, SUPER_EFFECTIVE);
            if (!failure.isEmpty()) {
                return TestResult.failure(failure);
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWeaknessPolicyOnFixedDamageHit(BattleTestHelper helper) {
        TestParticipant holder = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.NATURAL_CURE).heldItem(PixelmonItems.weakness_policy).moves(AttackRegistry.SOFT_BOILED).build());
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUCARIO).ability(AbilityRegistry.JUSTIFIED).moves(AttackRegistry.SEISMIC_TOSS).build());
        return helper.setupSingleBattleBuilder(attacker, holder).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                holder.attackAutoTarget(1);
                attacker.attackAutoTarget(1);
            });
            String failure = WeaknessPolicyTests.testWeaknessPolicy(holder.asWrapper(), false, FIXED_DAMAGE);
            return failure.isEmpty() ? TestResult.success() : TestResult.failure(failure);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWeaknessPolicyOnForcedSwitchHit(BattleTestHelper helper) {
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.COMPOUND_EYES).moves(AttackRegistry.DRAGON_TAIL).build();
        Pokemon zygarde = helper.createDefaultPokemon(PixelmonSpecies.ZYGARDE).heldItem(PixelmonItems.weakness_policy).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon aron = helper.createDefaultPokemon(PixelmonSpecies.ARON).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant player1 = helper.createParticipant(wynaut);
        TestParticipant player2 = helper.createParticipant(zygarde, aron);
        return helper.setupSingleBattleBuilder(player1, player2).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                player1.attackAutoTarget(1);
                player2.attackAutoTarget(1);
            });
            if (player2.asWrapper(zygarde).hasHeldItem()) {
                return TestResult.failure("Weakness Policy was not consumed before a forced switch, when it should have been.");
            }
            return TestResult.success();
        });
    }

    private static String testWeaknessPolicy(PixelmonWrapper pw, boolean testForActivation, String moveType) {
        if (testForActivation) {
            if (pw.hasHeldItem()) {
                return "Weakness Policy was not consumed after being hit by a " + moveType + " move.";
            }
            if (pw.getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return "Weakness Policy did not cause Attack stat to be raised by two stages.";
            }
            if (pw.getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 2) {
                return "Weakness Policy did not cause Special Attack stat to be raised by two stages.";
            }
        } else {
            if (!pw.hasHeldItem()) {
                return "Weakness Policy was consumed after being hit by a " + moveType + " move.";
            }
            if (pw.getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return "Weakness Policy did cause Attack stat to be raised by two stages when it shouldn't have.";
            }
            if (pw.getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return "Weakness Policy did cause Special Attack stat to be raised by two stages when it shouldn't have.";
            }
        }
        return "";
    }
}

