/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.item;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SitrusBerryTests {
    @BattleTest
    public static CompletableFuture<TestResult> testSitrusBerryHealAmount(BattleTestHelper helper) {
        TestParticipant holder = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AGGRON).ability(AbilityRegistry.STURDY).heldItem(PixelmonItems.sitrus_berry).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUCARIO).ability(AbilityRegistry.ADAPTABILITY).moves(AttackRegistry.AURA_SPHERE).build());
        return helper.setupSingleBattleBuilder(holder, attacker).forceChance().start().thenApply(controller -> {
            helper.autoTurn((BattleController)controller);
            if (holder.asWrapper().hasHeldItem()) {
                return TestResult.failure("Sitrus Berry was not consumed after going below 50% HP.");
            }
            return TestResult.equal(holder.asWrapper().getHealth(), Math.floor((double)holder.asWrapper().getMaxHealth() / 4.0) + 1.0, "Sitrus Berry did not heal 25% of maximum HP.");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSitrusBerryAndRecycle(BattleTestHelper helper) {
        TestParticipant holder = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MAGNEMITE).ability(AbilityRegistry.STURDY).heldItem(PixelmonItems.sitrus_berry).moves(AttackRegistry.RECYCLE).build());
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GARCHOMP).ability(AbilityRegistry.ROUGH_SKIN).moves(AttackRegistry.EARTHQUAKE).build());
        return helper.setupSingleBattleBuilder(holder, attacker).forceChance().start().thenApply(controller -> {
            double heal = Math.floor((double)holder.asWrapper().getMaxHealth() / 4.0);
            helper.autoTurn((BattleController)controller);
            if (holder.asWrapper().hasHeldItem()) {
                return TestResult.failure("Sitrus Berry was not consumed twice after being Recycled below 50% HP.");
            }
            return TestResult.equal(holder.asWrapper().getHealth(), heal + heal + 1.0, "Two Sitrus Berries did not heal 50% of maximum HP.");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSitrusBerryAndKnockOff(BattleTestHelper helper) {
        TestParticipant holder = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DEOXYS).form("attack").ability(AbilityRegistry.STURDY).heldItem(PixelmonItems.sitrus_berry).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KROOKODILE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.KNOCK_OFF).build());
        return helper.setupSingleBattleBuilder(holder, attacker).forceChance().start().thenApply(controller -> {
            helper.autoTurn((BattleController)controller);
            return TestResult.equal(holder.asWrapper().getHealth(), 1.0, "Sitrus Berry activated after being Knocked Off.");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSitrusBerryAndConfusion(BattleTestHelper helper) {
        TestParticipant holder = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DEOXYS).form("attack").ability(AbilityRegistry.STURDY).heldItem(PixelmonItems.sitrus_berry).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SABLEYE).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.CONFUSE_RAY).build());
        return helper.setupSingleBattleBuilder(holder, attacker).forceChance().start().thenApply(controller -> {
            helper.autoTurn((BattleController)controller);
            if (!holder.asWrapper().hasHeldItem()) {
                return TestResult.failure("Sitrus Berry was consumed due to confusion self-hit.");
            }
            if (holder.asWrapper().hasFullHealth()) {
                return TestResult.failure("Sitrus Berry healed damage caused by a confusion self-hit.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSitrusBerryAndEndOfTurnEffects(BattleTestHelper helper) {
        TestParticipant holder = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DARMANITAN).ability(AbilityRegistry.ZEN_MODE).heldItem(PixelmonItems.sitrus_berry).moves(AttackRegistry.SLEEP_TALK).ev(BattleStatsType.HP, 4).build());
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MIMIKYU).moves(AttackRegistry.CURSE).build());
        return helper.setupSingleBattleBuilder(holder, attacker).forceChance().start().thenApply(controller -> {
            helper.autoTurn((BattleController)controller);
            helper.autoTurn((BattleController)controller);
            if (holder.asWrapper().getForm().isForm("zen")) {
                return TestResult.failure("Sitrus Berry should heal Darmanitan outside of Zen Mode range.");
            }
            return TestResult.success();
        });
    }
}

