/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.item;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ShellBellTests {
    @BattleTest
    public static CompletableFuture<TestResult> testShellBellAndMultiTarget(BattleTestHelper helper) {
        Pokemon tornadus = helper.createDefaultPokemon(PixelmonSpecies.TORNADUS).ability(AbilityRegistry.COMPOUND_EYES).moves(AttackRegistry.SUPER_FANG).build();
        Pokemon landorus = helper.createDefaultPokemon(PixelmonSpecies.LANDORUS).heldItem(PixelmonItems.shell_bell).moves(AttackRegistry.EARTHQUAKE).build();
        Pokemon roggenrola = helper.createDefaultPokemon(PixelmonSpecies.ROGGENROLA).ability(AbilityRegistry.STURDY).level(1).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon aron = helper.createDefaultPokemon(PixelmonSpecies.ARON).ability(AbilityRegistry.STURDY).level(1).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant player1 = helper.createParticipant(2, tornadus, landorus);
        TestParticipant player2 = helper.createParticipant(2, roggenrola, aron);
        return helper.setupDoubleBattleBuilder(player1, player2).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                player1.attackTarget(tornadus, 1, landorus);
                player1.attackAutoTarget(landorus, 1);
                player2.attackAutoTargetAll();
            });
            return TestResult.equal(landorus.getHealth(), (double)landorus.getMaxHealth() - Math.floor((double)landorus.getMaxHealth() / 2.0) + Math.floor(2.75), "Shell Bell did not heal properly from an attack with multiple targets.");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShellBellAndMultiHit(BattleTestHelper helper) {
        Pokemon shelmet = helper.createDefaultPokemon(PixelmonSpecies.SHELMET).moves(AttackRegistry.FINAL_GAMBIT).build();
        Pokemon landorus = helper.createDefaultPokemon(PixelmonSpecies.LANDORUS).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon cloyster = helper.createDefaultPokemon(PixelmonSpecies.CLOYSTER).ability(AbilityRegistry.SKILL_LINK).heldItem(PixelmonItems.shell_bell).ev(BattleStatsType.HP, 4).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.ICICLE_SPEAR).build();
        TestParticipant player1 = helper.createParticipant(shelmet, landorus, wynaut);
        TestParticipant player2 = helper.createParticipant(cloyster);
        return helper.setupSingleBattleBuilder(player1, player2).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                player1.attackAuto();
                player1.switchPokemon(shelmet, landorus);
            });
            controller.takeFullTurn(() -> {
                player1.attackAutoTarget(1);
                player2.attackAutoTarget(2);
                player1.switchPokemon(landorus, wynaut);
            });
            return TestResult.equal(cloyster.getHealth(), 1.0 + Math.floor((double)landorus.getMaxHealth() / 8.0), "Shell Bell did not heal properly from an attack with multiple hits.");
        });
    }
}

