/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.item;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ShedShellTests {
    @BattleTest
    public static CompletableFuture<TestResult> testShedShellAndTrappingAbilities(BattleTestHelper helper) {
        Pokemon gothitelle = helper.createDefaultPokemon(PixelmonSpecies.GOTHITELLE).ability(AbilityRegistry.SHADOW_TAG).moves(AttackRegistry.CALM_MIND).build();
        Pokemon starmie = helper.createDefaultPokemon(PixelmonSpecies.STARMIE).ability(AbilityRegistry.NATURAL_CURE).heldItem(PixelmonItems.shed_shell).moves(AttackRegistry.RECOVER).build();
        Pokemon heatran = helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.REST).build();
        TestParticipant player1 = helper.createParticipant(gothitelle);
        TestParticipant player2 = helper.createParticipant(starmie, heatran);
        return helper.setupSingleBattleBuilder(player1, player2).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                player1.attackAuto();
                player2.switchPokemon(starmie, heatran);
            });
            if (!player2.asWrapper().getSpecies().is(PixelmonSpecies.HEATRAN)) {
                return TestResult.failure("Shed Shell did not allow a switch while under the effect of a trapping ability.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShedShellAndTrappingMoves(BattleTestHelper helper) {
        Pokemon gengar = helper.createDefaultPokemon(PixelmonSpecies.GENGAR).ability(AbilityRegistry.LEVITATE).moves(AttackRegistry.MEAN_LOOK).build();
        Pokemon venusaur = helper.createDefaultPokemon(PixelmonSpecies.VENUSAUR).ability(AbilityRegistry.OVERGROW).heldItem(PixelmonItems.shed_shell).moves(AttackRegistry.INGRAIN).build();
        Pokemon heatran = helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.REST).build();
        TestParticipant player1 = helper.createParticipant(gengar);
        TestParticipant player2 = helper.createParticipant(venusaur, heatran);
        return helper.setupSingleBattleBuilder(player1, player2).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                player1.attackAutoTarget(1);
                player2.attackAutoTarget(1);
            });
            controller.takeFullTurn(() -> {
                player1.attackAutoTarget(1);
                player2.switchPokemon(venusaur, heatran);
            });
            if (!player2.asWrapper().getSpecies().is(PixelmonSpecies.HEATRAN)) {
                return TestResult.failure("Shed Shell did not allow a switch while under the effects of trapping moves.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShedShellAndSkyDrop(BattleTestHelper helper) {
        Pokemon dragonite = helper.createDefaultPokemon(PixelmonSpecies.DRAGONITE).ability(AbilityRegistry.MULTISCALE).moves(AttackRegistry.SKY_DROP).build();
        Pokemon magnezone = helper.createDefaultPokemon(PixelmonSpecies.MAGNEZONE).ability(AbilityRegistry.STURDY).heldItem(PixelmonItems.shed_shell).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon heatran = helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.REST).build();
        TestParticipant player1 = helper.createParticipant(dragonite);
        TestParticipant player2 = helper.createParticipant(magnezone, heatran);
        return helper.setupSingleBattleBuilder(player1, player2).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                player1.attackAutoTarget(1);
                player2.attackAutoTarget(1);
            });
            controller.takeFullTurn(() -> {
                player1.attackAutoTarget(1);
                player2.switchPokemon(magnezone, heatran);
            });
            if (player2.asWrapper().getSpecies().is(PixelmonSpecies.HEATRAN)) {
                return TestResult.failure("Shed Shell did allow a switch while under the effects of Sky Drop.");
            }
            return TestResult.success();
        });
    }
}

