/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.ZenMode;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ZenModeTests {
    @BattleTest
    public static CompletableFuture<TestResult> testZenModeCannotBeOverridden(BattleTestHelper helper) {
        TestParticipant darm = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DARMANITAN).ability(AbilityRegistry.ZEN_MODE).moves(AttackRegistry.ENTRAINMENT).build());
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SKILL_SWAP, AttackRegistry.ENTRAINMENT).build());
        return helper.setupSingleBattleBuilder(darm, wynaut).forceChance().start().thenApply(controller -> {
            darm.attackOpponent(1);
            wynaut.attackOpponent(1);
            controller.takeFullTurn();
            if (!(darm.asWrapper().getBattleAbility() instanceof ZenMode)) {
                return TestResult.failure("ZenMode should not be overridden");
            }
            if (wynaut.asWrapper().getBattleAbility() instanceof ZenMode) {
                return TestResult.failure("ZenMode should not overwrite abilities");
            }
            return TestResult.success();
        });
    }
}

