/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.WonderGuard;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class WonderGuardTests {
    @BattleTest
    public static CompletableFuture<TestResult> testWonderGuardBlocksNonSuperEffectiveAttacks(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).ability(AbilityRegistry.WONDER_GUARD).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant smeargle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.OWN_TEMPO).moves(AttackRegistry.KNOCK_OFF, AttackRegistry.FLAMETHROWER, AttackRegistry.THOUSAND_ARROWS, AttackRegistry.MOONBLAST).build());
        return helper.setupSingleBattleBuilder(aerodactyl, smeargle).forceChance().start().thenApply(controller -> {
            for (int move = 1; move <= 4; ++move) {
                aerodactyl.attackOpponent(1);
                smeargle.attackOpponent(move);
                controller.takeFullTurn();
                if (aerodactyl.asWrapper().hasFullHealth()) continue;
                return TestResult.failure("WonderGuard should block non-supereffective attacks");
            }
            if (aerodactyl.asWrapper().hasStatus(StatusType.SmackedDown)) {
                return TestResult.failure("SmackDown status should not apply if blocked by WonderGuard");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWonderGuardShouldNotBlockStatusEffects(BattleTestHelper helper) {
        TestParticipant wonderguard = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KADABRA).ability(AbilityRegistry.WONDER_GUARD).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant smeargle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.POISON_GAS, AttackRegistry.SCREECH, AttackRegistry.HEAL_PULSE, AttackRegistry.GASTRO_ACID).build());
        return helper.setupSingleBattleBuilder(wonderguard, smeargle).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                wonderguard.attackOpponent(1);
                smeargle.attackOpponent(1);
            });
            if (!wonderguard.asWrapper().hasStatus(StatusType.Poison)) {
                return TestResult.failure("WonderGuard should not block PoisonGas");
            }
            controller.takeFullTurn(() -> {
                wonderguard.attackOpponent(1);
                smeargle.attackOpponent(2);
            });
            if (wonderguard.asWrapper().getBattleStats().getStage(BattleStatsType.DEFENSE) != -2) {
                return TestResult.failure("WonderGuard should not block Screech");
            }
            wonderguard.asWrapper().removePrimaryStatus();
            controller.takeFullTurn(() -> {
                wonderguard.attackOpponent(1);
                smeargle.attackOpponent(3);
            });
            if (!wonderguard.asWrapper().hasFullHealth()) {
                return TestResult.failure("WonderGuard should not block HealPulse");
            }
            controller.takeFullTurn(() -> {
                wonderguard.attackOpponent(1);
                smeargle.attackOpponent(4);
            });
            if (!wonderguard.asWrapper().hasStatus(StatusType.GastroAcid)) {
                return TestResult.failure("WonderGuard should not block GastroAcid");
            }
            if (wonderguard.asWrapper().getBattleAbility() instanceof WonderGuard) {
                return TestResult.failure("WonderGuard should be disabled by GastroAcid");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWonderGuardIsBypassedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant zekrom = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ZEKROM).ability(AbilityRegistry.WONDER_GUARD).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant reshiram = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RESHIRAM).ability(AbilityRegistry.TURBOBLAZE).moves(AttackRegistry.FUSION_FLARE).build());
        return helper.setupSingleBattleBuilder(zekrom, reshiram).forceChance().start().thenApply(controller -> {
            zekrom.attackOpponent(1);
            reshiram.attackOpponent(1);
            controller.takeFullTurn();
            if (zekrom.asWrapper().hasFullHealth()) {
                return TestResult.failure("WonderGuard should not block MoldBreaker");
            }
            return TestResult.success();
        });
    }
}

