/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class WindRiderTests {
    @BattleTest
    public static CompletableFuture<TestResult> testWindRiderShouldNullifyWindAndBoostAttack(BattleTestHelper helper) {
        TestParticipant windrider = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRAMBLEGHAST).ability(AbilityRegistry.WIND_RIDER).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant azumarill = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.ICY_WIND).build());
        return helper.setupSingleBattleBuilder(windrider, azumarill).forceChance().start().thenApply(controller -> {
            windrider.attackOpponent(1);
            azumarill.attackOpponent(1);
            controller.takeFullTurn();
            if (!windrider.asWrapper().hasFullHealth()) {
                return TestResult.failure("WindRider should prevent damage from wind-type attacks");
            }
            if (windrider.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != 0) {
                return TestResult.failure("WindRider should negate effects of wind-type attacks");
            }
            if (windrider.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("WindRider should increase ATK stage by 1");
            }
            windrider.attackOpponent(1);
            azumarill.attackOpponent(1);
            controller.takeFullTurn();
            if (windrider.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("WindRider should increase ATK stage each time it is hit");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWindRiderShouldNotBlockMoldBreaker(BattleTestHelper helper) {
        TestParticipant windrider = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRAMBLEGHAST).ability(AbilityRegistry.WIND_RIDER).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant moldbreaker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.VELUZA).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.ICY_WIND).build());
        return helper.setupSingleBattleBuilder(windrider, moldbreaker).forceChance().start().thenApply(controller -> {
            windrider.attackOpponent(1);
            moldbreaker.attackOpponent(1);
            controller.takeFullTurn();
            if (windrider.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0 || windrider.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != -1 || windrider.asWrapper().hasFullHealth()) {
                return TestResult.failure("WindRider should be bypassed by MoldBreaker");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWindRiderShouldNotBlockSandstorm(BattleTestHelper helper) {
        TestParticipant windrider = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRAMBLEGHAST).ability(AbilityRegistry.WIND_RIDER).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant sandstorm = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ARON).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SANDSTORM).build());
        return helper.setupSingleBattleBuilder(windrider, sandstorm).forceChance().start().thenApply(controller -> {
            windrider.attackOpponent(1);
            sandstorm.attackSelf(1);
            controller.takeFullTurn();
            if (windrider.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("WindRider should not block the wind move Sandstorm");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWindRiderActivatesIfTailwindIsActivatedOnTheirSide(BattleTestHelper helper) {
        Pokemon windrider = helper.createDefaultPokemon(PixelmonSpecies.BRAMBLEGHAST).ability(AbilityRegistry.WIND_RIDER).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon tailwind = helper.createDefaultPokemon(PixelmonSpecies.PELIPPER).ability(AbilityRegistry.KEEN_EYE).moves(AttackRegistry.TAILWIND).build();
        TestParticipant teamOne = helper.createParticipant(2, windrider, tailwind);
        Pokemon magikarp1 = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.SPLASH).build();
        Pokemon magikarp2 = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.SPLASH).build();
        TestParticipant teamTwo = helper.createParticipant(2, magikarp1, magikarp2);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackAuto(tailwind);
                teamOne.attackAuto(windrider);
                teamTwo.attackAuto(magikarp1);
                teamTwo.attackAuto(magikarp2);
            });
            if (teamOne.asWrapper(windrider).getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("WindRider should be activated if TailWind activates");
            }
            if (!teamOne.asWrapper(windrider).hasStatus(StatusType.Tailwind) || !teamOne.asWrapper(tailwind).hasStatus(StatusType.Tailwind)) {
                return TestResult.failure("WindRider should not prevent Tailwind despite boosting attack");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWindRiderActivatesIfTailwindIsActivatedOnTheirSideEvenWithMoldBreaker(BattleTestHelper helper) {
        Pokemon windrider = helper.createDefaultPokemon(PixelmonSpecies.BRAMBLEGHAST).ability(AbilityRegistry.WIND_RIDER).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon tailwind = helper.createDefaultPokemon(PixelmonSpecies.PELIPPER).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.TAILWIND).build();
        TestParticipant teamOne = helper.createParticipant(2, windrider, tailwind);
        Pokemon magikarp1 = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.SPLASH).build();
        Pokemon magikarp2 = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.SPLASH).build();
        TestParticipant teamTwo = helper.createParticipant(2, magikarp1, magikarp2);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackSelf(tailwind, 1);
                teamOne.attackAuto(windrider);
                teamTwo.attackAuto(magikarp1);
                teamTwo.attackAuto(magikarp2);
            });
            if (teamOne.asWrapper(windrider).getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("WindRider should be activated if TailWind activates");
            }
            if (!teamOne.asWrapper(windrider).hasStatus(StatusType.Tailwind) || !teamOne.asWrapper(tailwind).hasStatus(StatusType.Tailwind)) {
                return TestResult.failure("WindRider should not prevent Tailwind despite boosting attack");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWindRiderNotActivatedIfTailwindIsActivatedOnOtherSide(BattleTestHelper helper) {
        TestParticipant windrider = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRAMBLEGHAST).ability(AbilityRegistry.WIND_RIDER).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant tailwind = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PELIPPER).ability(AbilityRegistry.KEEN_EYE).moves(AttackRegistry.TAILWIND).build());
        return helper.setupSingleBattleBuilder(windrider, tailwind).forceChance().start().thenApply(controller -> {
            windrider.attackOpponent(1);
            tailwind.attackSelf(1);
            controller.takeFullTurn();
            if (windrider.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) == 1) {
                return TestResult.failure("WindRider should not be activated if TailWind activates on other side");
            }
            if (!tailwind.asWrapper().hasStatus(StatusType.Tailwind)) {
                return TestResult.failure("Tailwind should not be prevented by opposing WindRider");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWindRiderActivatesIfSwitchIntoTailwind(BattleTestHelper helper) {
        Pokemon windrider = helper.createDefaultPokemon(PixelmonSpecies.BRAMBLEGHAST).ability(AbilityRegistry.WIND_RIDER).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon tailwind = helper.createDefaultPokemon(PixelmonSpecies.PELIPPER).ability(AbilityRegistry.KEEN_EYE).moves(AttackRegistry.TAILWIND).build();
        TestParticipant pair = helper.createParticipant(1, tailwind, windrider);
        TestParticipant magikarp = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(pair, magikarp).forceChance().start().thenApply(controller -> {
            pair.attackSelf(1);
            magikarp.attackOpponent(1);
            controller.takeFullTurn();
            if (!pair.asWrapper().hasStatus(StatusType.Tailwind)) {
                return TestResult.failure("WindRiderTests.testWindRiderActivatesIfSwitchIntoTailwind failed setup");
            }
            controller.takeFullTurn(() -> {
                pair.switchPokemon(tailwind, windrider);
                magikarp.attackOpponent(1);
            });
            if (pair.asWrapper(windrider).getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("WindRider should be activated by switching into a TailWind");
            }
            if (!pair.asWrapper(windrider).hasStatus(StatusType.Tailwind)) {
                return TestResult.failure("Tailwind should not be prevented by switching into WindRider");
            }
            return TestResult.success();
        });
    }
}

