/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.LongReach;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Overgrow;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.WanderingSpirit;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.WonderGuard;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class WanderingSpiritTests {
    @BattleTest
    public static CompletableFuture<TestResult> testWanderingSpiritSwapsOnOpponentContactAttack(BattleTestHelper helper) {
        TestParticipant overgrow = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DECIDUEYE).ability(AbilityRegistry.OVERGROW).moves(AttackRegistry.SHADOW_SNEAK).build());
        TestParticipant spirit = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RUNERIGUS).ability(AbilityRegistry.WANDERING_SPIRIT).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(overgrow, spirit).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                overgrow.attackOpponent(1);
                spirit.attackOpponent(1);
            });
            if (!(overgrow.asWrapper().getBattleAbility() instanceof WanderingSpirit)) {
                return TestResult.failure("WanderingSpirit should switch on contact attacks");
            }
            if (!(spirit.asWrapper().getBattleAbility() instanceof Overgrow)) {
                return TestResult.failure("WanderingSpirit should switch on contact attacks and be Overgrow now");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWanderingSpiritDoesNotSwapOnDynamax(BattleTestHelper helper) {
        TestParticipant dynaspirit = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RUNERIGUS).ability(AbilityRegistry.WANDERING_SPIRIT).moves(AttackRegistry.CLOSE_COMBAT).build());
        TestParticipant overgrow = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DECIDUEYE).ability(AbilityRegistry.OVERGROW).moves(AttackRegistry.SHADOW_SNEAK).build());
        return helper.setupSingleBattleBuilder(overgrow, dynaspirit).forceChance().start().thenApply(controller -> {
            dynaspirit.asWrapper().willEvolve = true;
            controller.takeFullTurn(() -> {
                overgrow.attackOpponent(1);
                dynaspirit.attackOpponent(1);
                dynaspirit.evolve();
            });
            if (!(overgrow.asWrapper().getBattleAbility() instanceof Overgrow) || !(dynaspirit.asWrapper().getBattleAbility() instanceof WanderingSpirit)) {
                return TestResult.failure("WanderingSpirit should not switch when Dynamaxed");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWanderingSpiritDoesNotSwapWithWonderGuard(BattleTestHelper helper) {
        TestParticipant shedinja = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.WONDER_GUARD).moves(AttackRegistry.SHADOW_SNEAK).build());
        TestParticipant spirit = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RUNERIGUS).ability(AbilityRegistry.WANDERING_SPIRIT).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(shedinja, spirit).forceChance().start().thenApply(controller -> {
            shedinja.attackOpponent(1);
            spirit.attackOpponent(1);
            controller.takeFullTurn();
            if (!(shedinja.asWrapper().getBattleAbility() instanceof WonderGuard) || !(spirit.asWrapper().getBattleAbility() instanceof WanderingSpirit)) {
                return TestResult.failure("WanderingSpirit should not switch with WonderGuard");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWanderingSpiritDoesNotSwapWithNonContact(BattleTestHelper helper) {
        TestParticipant longreach = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DECIDUEYE).ability(AbilityRegistry.LONG_REACH).moves(AttackRegistry.SHADOW_SNEAK).build());
        TestParticipant spirit = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RUNERIGUS).ability(AbilityRegistry.WANDERING_SPIRIT).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(longreach, spirit).forceChance().start().thenApply(controller -> {
            longreach.attackOpponent(1);
            spirit.attackOpponent(1);
            controller.takeFullTurn();
            if (!(longreach.asWrapper().getBattleAbility() instanceof LongReach) || !(spirit.asWrapper().getBattleAbility() instanceof WanderingSpirit)) {
                return TestResult.failure("WanderingSpirit should not switch with WonderGuard");
            }
            return TestResult.success();
        });
    }
}

