/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.Minimize;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class VictoryStarTests {
    @BattleTest
    public static CompletableFuture<TestResult> testMultipleVictoryStarBoostsStack(BattleTestHelper helper) {
        Pokemon victini = helper.createDefaultPokemon(PixelmonSpecies.VICTINI).ability(AbilityRegistry.VICTORY_STAR).moves(AttackRegistry.SEARING_SHOT).build();
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.VICTORY_STAR).moves(AttackRegistry.POLTERGEIST).build();
        TestParticipant teamOne = helper.createParticipant(2, victini, wynaut);
        Pokemon avalugg = helper.createDefaultPokemon(PixelmonSpecies.AVALUGG).ability(AbilityRegistry.STURDY).moves(AttackRegistry.POLTERGEIST).build();
        Pokemon dratini = helper.createDefaultPokemon(PixelmonSpecies.DRATINI).ability(AbilityRegistry.SHED_SKIN).moves(AttackRegistry.POLTERGEIST).build();
        TestParticipant teamTwo = helper.createParticipant(2, avalugg, dratini);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).start().thenApply(controller -> {
            int moveAccuracy = AttackRegistry.SEARING_SHOT.getValueUnsafe().ofMutable().modifyMoveStats(teamOne.asWrapper(), teamTwo.asWrapper(), teamOne.asWrapper().getBattleAbility(), teamTwo.asWrapper().getBattleAbility(), AttackRegistry.SEARING_SHOT.getValueUnsafe().getBasePower())[1];
            if (moveAccuracy != 121) {
                return TestResult.failure("Multiple VictoryStar should stack accuracy boosts");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testVictoryStarDoesNotBoostOpponent(BattleTestHelper helper) {
        TestParticipant victini = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.VICTINI).ability(AbilityRegistry.VICTORY_STAR).moves(AttackRegistry.SEARING_SHOT).build());
        TestParticipant smeargle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.OWN_TEMPO).moves(AttackRegistry.HYPNOSIS).build());
        return helper.setupSingleBattleBuilder(smeargle, victini).forceChance().start().thenApply(controller -> {
            int[] modified = AttackRegistry.HYPNOSIS.getValueUnsafe().ofMutable().modifyMoveStats(smeargle.asWrapper(), victini.asWrapper(), smeargle.asWrapper().getBattleAbility(), victini.asWrapper().getBattleAbility(), AttackRegistry.HYPNOSIS.getValueUnsafe().getBasePower());
            int moveAccuracy = modified[1];
            if (moveAccuracy != 60) {
                return TestResult.failure("VictoryStar should not boost opponent's accuracy");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testVictoryStarBoostsAgainstAllies(BattleTestHelper helper) {
        Pokemon victini = helper.createDefaultPokemon(PixelmonSpecies.VICTINI).ability(AbilityRegistry.VICTORY_STAR).moves(AttackRegistry.SEARING_SHOT).build();
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.SHADOW_TAG).moves(AttackRegistry.POLTERGEIST).build();
        TestParticipant teamOne = helper.createParticipant(2, victini, wynaut);
        Pokemon avalugg = helper.createDefaultPokemon(PixelmonSpecies.AVALUGG).ability(AbilityRegistry.STURDY).moves(AttackRegistry.POLTERGEIST).build();
        Pokemon dratini = helper.createDefaultPokemon(PixelmonSpecies.DRATINI).ability(AbilityRegistry.SHED_SKIN).moves(AttackRegistry.POLTERGEIST).build();
        TestParticipant teamTwo = helper.createParticipant(2, avalugg, dratini);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).start().thenApply(controller -> {
            int[] modified = AttackRegistry.SEARING_SHOT.getValueUnsafe().ofMutable().modifyMoveStats(teamOne.asWrapper(victini), teamOne.asWrapper(wynaut), teamOne.asWrapper(victini).getBattleAbility(), teamOne.asWrapper(wynaut).getBattleAbility(), AttackRegistry.SEARING_SHOT.getValueUnsafe().getBasePower());
            int moveAccuracy = modified[1];
            if (moveAccuracy != 110) {
                return TestResult.failure("VictoryStar should boost accuracy when attacking allies as well");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testVictoryStarDoesNotBreakAntiInvulnerableHits(BattleTestHelper helper) {
        TestParticipant victini = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.VICTINI).ability(AbilityRegistry.VICTORY_STAR).moves(AttackRegistry.HYPNOSIS).build());
        TestParticipant machamp = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MACHAMP).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.ENDURE).build());
        return helper.setupSingleBattleBuilder(victini, machamp).forceChance().start().thenApply(controller -> {
            int[] modified = AttackRegistry.HYPNOSIS.getValueUnsafe().ofMutable().modifyMoveStats(victini.asWrapper(), machamp.asWrapper(), victini.asWrapper().getBattleAbility(), machamp.asWrapper().getBattleAbility(), AttackRegistry.HYPNOSIS.getValueUnsafe().getBasePower());
            int moveAccuracy = modified[1];
            if (moveAccuracy != -2) {
                return TestResult.failure("VictoryStar should not break Anti-SemiInvulnerable Hits");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testVictoryStarDoesNotBreakGuaranteedHits(BattleTestHelper helper) {
        TestParticipant victini = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.VICTINI).ability(AbilityRegistry.VICTORY_STAR).moves(AttackRegistry.DRAGON_RUSH).build());
        TestParticipant muk = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MUK).ability(AbilityRegistry.STENCH).moves(AttackRegistry.MINIMIZE).build());
        return helper.setupSingleBattleBuilder(victini, muk).forceChance().start().thenApply(controller -> {
            Minimize minimize = new Minimize();
            minimize.applyEffect(muk.asWrapper(), muk.asWrapper());
            int[] modified = AttackRegistry.DRAGON_RUSH.getValueUnsafe().ofMutable().modifyMoveStats(victini.asWrapper(), muk.asWrapper(), victini.asWrapper().getBattleAbility(), muk.asWrapper().getBattleAbility(), AttackRegistry.DRAGON_RUSH.getValueUnsafe().getBasePower());
            int moveAccuracy = modified[1];
            if (moveAccuracy != -1) {
                return TestResult.failure("VictoryStar should not break Guaranteed Hits");
            }
            return TestResult.success();
        });
    }
}

