/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class UnnerveTests {
    public static CompletableFuture<TestResult> testBerriesActivatesBetweenUnnerveSwitches(BattleTestHelper helper) {
        Pokemon toxapex = helper.createDefaultPokemon(PixelmonSpecies.TOXAPEX).ability(AbilityRegistry.UNNERVE).moves(AttackRegistry.TOXIC).build();
        Pokemon corvi = helper.createDefaultPokemon(PixelmonSpecies.CORVIKNIGHT).ability(AbilityRegistry.UNNERVE).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant pair = helper.createParticipant(toxapex, corvi);
        TestParticipant magikarp = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).heldItem(PixelmonItems.lum_berry).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(pair, magikarp).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                pair.attackOpponent(1);
                magikarp.attackOpponent(1);
            });
            if (!magikarp.asWrapper().hasStatus(StatusType.PoisonBadly)) {
                return TestResult.failure("Lum Berry should not cure poison while Unnerve is active.");
            }
            controller.takeFullTurn(() -> {
                pair.switchPokemon(toxapex, corvi);
                magikarp.attackOpponent(1);
            });
            if (magikarp.asWrapper().hasStatus(StatusType.PoisonBadly)) {
                return TestResult.failure("Lum Berry should activate between Unnerve switching out and back in");
            }
            return TestResult.success();
        });
    }
}

