/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class UnburdenTests {
    @BattleTest
    public static CompletableFuture<TestResult> testUnburdenActivatesOnItemConsumed(BattleTestHelper helper) {
        TestParticipant unburden = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HITMONLEE).ability(AbilityRegistry.UNBURDEN).heldItem(PixelmonItems.white_herb).moves(AttackRegistry.CLOSE_COMBAT).build());
        TestParticipant aron = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ARON).ability(AbilityRegistry.STURDY).level(1).moves(AttackRegistry.TACKLE).build());
        return helper.setupSingleBattleBuilder(unburden, aron).forceChance().start().thenApply(controller -> {
            int baseSpeed = unburden.asWrapper().getBattleStats().speedStat;
            controller.takeFullTurn(() -> {
                unburden.attackOpponent(1);
                aron.attackOpponent(1);
            });
            if (unburden.asWrapper().getBattleStats().speedStat != baseSpeed * 2) {
                return TestResult.failure("Speed is not doubled after consuming WhiteHerb");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnburdenActivatesOnItemDestroyed(BattleTestHelper helper) {
        TestParticipant unburden = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HITMONLEE).ability(AbilityRegistry.UNBURDEN).heldItem(PixelmonItems.air_balloon).moves(AttackRegistry.TACKLE).build());
        TestParticipant machamp = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MACHAMP).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.MACH_PUNCH).build());
        return helper.setupSingleBattleBuilder(unburden, machamp).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            int baseSpeed = unburden.asWrapper().getBattleStats().speedStat;
            controller.takeFullTurn(() -> {
                unburden.attackOpponent(1);
                machamp.attackOpponent(1);
            });
            if (unburden.asWrapper().getBattleStats().speedStat != baseSpeed * 2) {
                return TestResult.failure("Speed is not doubled after AirBalloon is popped");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnburdenActivatesOnNaturalGiftEatingBerry(BattleTestHelper helper) {
        TestParticipant unburden = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SCEPTILE).ability(AbilityRegistry.UNBURDEN).heldItem(PixelmonItems.oran_berry).moves(AttackRegistry.NATURAL_GIFT).build());
        TestParticipant aron = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ARON).ability(AbilityRegistry.STURDY).level(1).moves(AttackRegistry.TACKLE).build());
        return helper.setupSingleBattleBuilder(unburden, aron).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            int baseSpeed = unburden.asWrapper().getBattleStats().speedStat;
            controller.takeFullTurn(() -> {
                unburden.attackOpponent(1);
                aron.attackOpponent(1);
            });
            if (unburden.asWrapper().getBattleStats().speedStat != baseSpeed * 2) {
                return TestResult.failure("Speed is not doubled after NaturalGift consumes OranBerry");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnburdenActivatesOnItemBeingFlung(BattleTestHelper helper) {
        TestParticipant unburden = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SCEPTILE).ability(AbilityRegistry.UNBURDEN).heldItem(PixelmonItems.oran_berry).moves(AttackRegistry.FLING).build());
        TestParticipant aron = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ARON).ability(AbilityRegistry.STURDY).moves(AttackRegistry.TACKLE).build());
        return helper.setupSingleBattleBuilder(unburden, aron).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            int baseSpeed = unburden.asWrapper().getBattleStats().speedStat;
            unburden.attackOpponent(1);
            aron.attackOpponent(1);
            controller.takeFullTurn();
            if (unburden.asWrapper().getBattleStats().speedStat != baseSpeed * 2) {
                return TestResult.failure("Speed is not doubled after Fling removing the item");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnburdenActivatesOnItemForcefullyRemoved(BattleTestHelper helper) {
        TestParticipant unburden = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SCEPTILE).ability(AbilityRegistry.UNBURDEN).heldItem(PixelmonItems.white_herb).moves(AttackRegistry.LEECH_SEED).build());
        TestParticipant scizor = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SCIZOR).ability(AbilityRegistry.SWARM).moves(AttackRegistry.KNOCK_OFF).build());
        return helper.setupSingleBattleBuilder(unburden, scizor).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            int baseSpeed = unburden.asWrapper().getBattleStats().speedStat;
            controller.takeFullTurn(() -> {
                unburden.attackOpponent(1);
                scizor.attackOpponent(1);
            });
            if (unburden.asWrapper().getBattleStats().speedStat != baseSpeed * 2) {
                return TestResult.failure("Speed is not doubled after KnockOff removes WhiteHerb");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnburdenShouldNotBeSuppressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant unburden = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SCEPTILE).ability(AbilityRegistry.UNBURDEN).heldItem(PixelmonItems.white_herb).moves(AttackRegistry.LEECH_SEED).build());
        TestParticipant moldbreaker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PINSIR).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.KNOCK_OFF).build());
        return helper.setupSingleBattleBuilder(unburden, moldbreaker).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            int baseSpeed = unburden.asWrapper().getBattleStats().speedStat;
            controller.takeFullTurn(() -> {
                unburden.attackOpponent(1);
                moldbreaker.attackOpponent(1);
            });
            if (unburden.asWrapper().getBattleStats().speedStat != baseSpeed * 2) {
                return TestResult.failure("Speed is not doubled after KnockOff removes WhiteHerb");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnburdenActivatesAfterItemlessTrick(BattleTestHelper helper) {
        TestParticipant unburden = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SCEPTILE).ability(AbilityRegistry.UNBURDEN).heldItem(PixelmonItems.white_herb).moves(AttackRegistry.LEECH_SEED).build());
        TestParticipant trick = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEOWSTIC).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.TRICK).build());
        return helper.setupSingleBattleBuilder(unburden, trick).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            int baseSpeed = unburden.asWrapper().getBattleStats().speedStat;
            controller.takeFullTurn(() -> {
                unburden.attackOpponent(1);
                trick.attackOpponent(1);
            });
            if (unburden.asWrapper().getBattleStats().speedStat != baseSpeed * 2) {
                return TestResult.failure("Speed is not doubled after Trick switches WhiteHerb off");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnburdenShouldNotActivateAfterItemSwap(BattleTestHelper helper) {
        TestParticipant unburden = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SCEPTILE).ability(AbilityRegistry.UNBURDEN).heldItem(PixelmonItems.white_herb).moves(AttackRegistry.LEECH_SEED).build());
        TestParticipant trick = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEOWSTIC).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.TRICK).heldItem(PixelmonItems.choice_specs).build());
        return helper.setupSingleBattleBuilder(unburden, trick).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            int baseSpeed = unburden.asWrapper().getBattleStats().speedStat;
            controller.takeFullTurn(() -> {
                unburden.attackOpponent(1);
                trick.attackOpponent(1);
            });
            if (unburden.asWrapper().getBattleStats().speedStat != baseSpeed) {
                return TestResult.failure("Speed is being doubled after Trick switches items");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnburdenLosesBoostOnGainingNewItem(BattleTestHelper helper) {
        TestParticipant unburden = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HITMONLEE).ability(AbilityRegistry.UNBURDEN).heldItem(PixelmonItems.fighting_gem).moves(AttackRegistry.MACH_PUNCH, AttackRegistry.COUNTER).build());
        TestParticipant togekiss = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TOGEKISS).ability(AbilityRegistry.SERENE_GRACE).heldItem(PixelmonItems.lum_berry).moves(AttackRegistry.TACKLE, AttackRegistry.BESTOW).build());
        return helper.setupSingleBattleBuilder(unburden, togekiss).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            int baseSpeed = unburden.asWrapper().getBattleStats().speedStat;
            controller.takeFullTurn(() -> {
                unburden.attackOpponent(1);
                togekiss.attackOpponent(1);
            });
            if (unburden.asWrapper().getBattleStats().speedStat != baseSpeed * 2) {
                return TestResult.failure("Speed is not doubled after FightingGem is consumed");
            }
            controller.takeFullTurn(() -> {
                unburden.attackOpponent(2);
                togekiss.attackOpponent(2);
            });
            if (unburden.asWrapper().getBattleStats().speedStat != baseSpeed) {
                return TestResult.failure("Speed is reset after new item is gained");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnburdenResetsOnSwitch(BattleTestHelper helper) {
        Pokemon unburden = helper.createDefaultPokemon(PixelmonSpecies.HITMONLEE).ability(AbilityRegistry.UNBURDEN).heldItem(PixelmonItems.white_herb).moves(AttackRegistry.CLOSE_COMBAT).build();
        Pokemon other = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.SPLASH).build();
        TestParticipant pair = helper.createParticipant(unburden, other);
        TestParticipant aron = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ARON).ability(AbilityRegistry.STURDY).level(1).moves(AttackRegistry.TACKLE).build());
        return helper.setupSingleBattleBuilder(pair, aron).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            int baseSpeed = pair.asWrapper().getBattleStats().speedStat;
            controller.takeFullTurn(() -> {
                pair.attackOpponent(1);
                aron.attackOpponent(1);
            });
            if (pair.asWrapper().getBattleStats().speedStat != 2 * baseSpeed) {
                return TestResult.failure("Unburden should activate on item being consumed");
            }
            controller.takeFullTurn(() -> {
                pair.switchPokemon(unburden, other);
                aron.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                pair.switchPokemon(other, unburden);
                aron.attackOpponent(1);
            });
            if (pair.asWrapper().getBattleStats().speedStat != baseSpeed) {
                return TestResult.failure("Unburden should reset on switching out and back in");
            }
            return TestResult.success();
        });
    }
}

