/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class UnawareTests {
    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldIgnorePositiveAttackStageWhenAttackedPhysical(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.SPLASH).build());
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.STORM_THROW).build());
        return helper.setupSingleBattleBuilder(unaware, wynaut).forceChance().start().thenApply(controller -> {
            wynaut.asWrapper().getBattleStats().modifyStat(6, BattleStatsType.ATTACK);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                wynaut.attackOpponent(1);
            });
            int damage = unaware.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 15, 18);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldIgnorePositiveAttackStageWhenAttackedSpecial(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.SPLASH).build());
        TestParticipant toxapex = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TOXAPEX).moves(AttackRegistry.FROST_BREATH).build());
        return helper.setupSingleBattleBuilder(unaware, toxapex).forceChance().start().thenApply(controller -> {
            toxapex.asWrapper().getBattleStats().modifyStat(6, BattleStatsType.SPECIAL_ATTACK);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                toxapex.attackOpponent(1);
            });
            int damage = unaware.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 44, 52);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldIgnoreNegativeAttackStageWhenAttackedPhysical(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SPLASH, AttackRegistry.FORCE_PALM).build());
        return helper.setupSingleBattleBuilder(unaware, wynaut).forceChance().start().thenApply(controller -> {
            wynaut.asWrapper().getBattleStats().modifyStat(-6, BattleStatsType.ATTACK);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                wynaut.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                wynaut.attackOpponent(2);
            });
            int damage = unaware.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 10, 12);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldIgnoreNegativeAttackStageWhenAttackedSpecial(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant blastoise = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLASTOISE).moves(AttackRegistry.SPLASH, AttackRegistry.AURA_SPHERE).build());
        return helper.setupSingleBattleBuilder(unaware, blastoise).forceChance().start().thenApply(controller -> {
            blastoise.asWrapper().getBattleStats().modifyStat(-6, BattleStatsType.SPECIAL_ATTACK);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                blastoise.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                blastoise.attackOpponent(2);
            });
            int damage = unaware.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 28, 33);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldNotIgnorePositiveAttackStageWhenItAttacksPhysical(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.PLAY_ROUGH).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            unaware.asWrapper().getBattleStats().modifyStat(2, BattleStatsType.ATTACK);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                regi.attackOpponent(1);
            });
            int damage = regi.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 51, 60);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldNotIgnorePositiveAttackStageWhenItAttacksSpecial(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.MOONBLAST).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            unaware.asWrapper().getBattleStats().modifyStat(2, BattleStatsType.SPECIAL_ATTACK);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                regi.attackOpponent(1);
            });
            int damage = regi.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 69, 81);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldNotIgnoreNegativeAttackStageWhenItAttacksPhysical(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.WATERFALL).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            unaware.asWrapper().getBattleStats().modifyStat(-2, BattleStatsType.ATTACK);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                regi.attackOpponent(1);
            });
            int damage = regi.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 17, 20);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldNotIgnoreNegativeAttackStageWhenItAttacksSpecial(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.MOONBLAST).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            unaware.asWrapper().getBattleStats().modifyStat(-2, BattleStatsType.SPECIAL_ATTACK);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                regi.attackOpponent(1);
            });
            int damage = regi.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 18, 21);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldNotIgnorePositiveDefenseStageWhenAttackedPhysical(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SPLASH, AttackRegistry.CRUNCH).build());
        return helper.setupSingleBattleBuilder(unaware, wynaut).forceChance().start().thenApply(controller -> {
            unaware.asWrapper().getBattleStats().modifyStat(2, BattleStatsType.DEFENSE);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                wynaut.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                wynaut.attackOpponent(2);
            });
            int damage = unaware.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 7, 8);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldNotIgnorePositiveDefenseStageWhenAttackedSpecial(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SPLASH, AttackRegistry.DARK_PULSE).build());
        return helper.setupSingleBattleBuilder(unaware, wynaut).forceChance().start().thenApply(controller -> {
            unaware.asWrapper().getBattleStats().modifyStat(2, BattleStatsType.SPECIAL_DEFENSE);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                wynaut.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                wynaut.attackOpponent(2);
            });
            int damage = unaware.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 6, 7);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldNotIgnoreNegativeDefenseStageWhenAttackedPhysical(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SPLASH, AttackRegistry.CRUNCH).build());
        return helper.setupSingleBattleBuilder(unaware, wynaut).forceChance().start().thenApply(controller -> {
            unaware.asWrapper().getBattleStats().modifyStat(-2, BattleStatsType.DEFENSE);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                wynaut.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                wynaut.attackOpponent(2);
            });
            int damage = unaware.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 26, 31);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldNotIgnoreNegativeDefenseStageWhenAttackedSpecial(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SPLASH, AttackRegistry.DARK_PULSE).build());
        return helper.setupSingleBattleBuilder(unaware, wynaut).forceChance().start().thenApply(controller -> {
            unaware.asWrapper().getBattleStats().modifyStat(-2, BattleStatsType.SPECIAL_DEFENSE);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                wynaut.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                wynaut.attackOpponent(2);
            });
            int damage = unaware.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 22, 26);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldIgnorePositiveDefenseStageWhenItAttacksPhysical(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.PLAY_ROUGH).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            regi.asWrapper().getBattleStats().modifyStat(2, BattleStatsType.DEFENSE);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                regi.attackOpponent(1);
            });
            int damage = regi.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 26, 31);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldIgnorePositiveDefenseStageWhenItAttacksSpecial(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.MOONBLAST).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            regi.asWrapper().getBattleStats().modifyStat(2, BattleStatsType.SPECIAL_DEFENSE);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                regi.attackOpponent(1);
            });
            int damage = regi.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 35, 42);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldIgnoreNegativeDefenseStageWhenItAttacksPhysical(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.PLAY_ROUGH).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            regi.asWrapper().getBattleStats().modifyStat(-2, BattleStatsType.DEFENSE);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                regi.attackOpponent(1);
            });
            int damage = regi.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 26, 31);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldIgnoreNegativeDefenseStageWhenItAttacksSpecial(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.MOONBLAST).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            regi.asWrapper().getBattleStats().modifyStat(-2, BattleStatsType.SPECIAL_DEFENSE);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                regi.attackOpponent(1);
            });
            int damage = regi.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 35, 42);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldNotIgnorePositiveAccuracyStageWhenItAttacks(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.ZEN_HEADBUTT).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            unaware.asWrapper().getBattleStats().modifyStat(1, BattleStatsType.ACCURACY);
            unaware.attackOpponent(1);
            regi.attackAuto();
            controller.advanceToMoves();
            int normal = unaware.asWrapper().attack.getMove().getAccuracy();
            double accuracy = UnawareTests.calculateAccuracy(unaware.asWrapper(), regi.asWrapper());
            return TestResult.equal(accuracy, (double)normal * 1.33);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldNotIgnoreNegativeAccuracyStageWhenItAttacks(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.ZEN_HEADBUTT).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            unaware.asWrapper().getBattleStats().modifyStat(-1, BattleStatsType.ACCURACY);
            unaware.attackOpponent(1);
            regi.attackAuto();
            controller.advanceToMoves();
            int normal = unaware.asWrapper().attack.getMove().getAccuracy();
            double accuracy = UnawareTests.calculateAccuracy(unaware.asWrapper(), regi.asWrapper());
            return TestResult.equal(accuracy, (double)normal * 0.75);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldIgnorePositiveEvasionStageWhenItAttacks(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.ZEN_HEADBUTT).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            regi.asWrapper().getBattleStats().modifyStat(1, BattleStatsType.EVASION);
            unaware.attackOpponent(1);
            regi.attackAuto();
            controller.advanceToMoves();
            int normal = unaware.asWrapper().attack.getMove().getAccuracy();
            double accuracy = UnawareTests.calculateAccuracy(unaware.asWrapper(), regi.asWrapper());
            return TestResult.equal(accuracy, normal);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldIgnoreNegativeEvasionStageWhenItAttacks(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.ZEN_HEADBUTT).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            unaware.asWrapper().getBattleStats().modifyStat(-1, BattleStatsType.EVASION);
            unaware.attackOpponent(1);
            regi.attackAuto();
            controller.advanceToMoves();
            int normal = unaware.asWrapper().attack.getMove().getAccuracy();
            double accuracy = UnawareTests.calculateAccuracy(unaware.asWrapper(), regi.asWrapper());
            return TestResult.equal(accuracy, normal);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldIgnorePositiveAccuracyStageWhenAttacked(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.IRON_HEAD).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            regi.asWrapper().getBattleStats().modifyStat(1, BattleStatsType.ACCURACY);
            unaware.attackOpponent(1);
            regi.attackAuto();
            controller.advanceToMoves();
            int normal = regi.asWrapper().attack.getMove().getAccuracy();
            double accuracy = UnawareTests.calculateAccuracy(regi.asWrapper(), unaware.asWrapper());
            return TestResult.equal(accuracy, normal);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldIgnoreNegativeAccuracyStageWhenAttacked(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.IRON_HEAD).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            regi.asWrapper().getBattleStats().modifyStat(-1, BattleStatsType.ACCURACY);
            unaware.attackOpponent(1);
            regi.attackAuto();
            controller.advanceToMoves();
            int normal = regi.asWrapper().attack.getMove().getAccuracy();
            double accuracy = UnawareTests.calculateAccuracy(regi.asWrapper(), unaware.asWrapper());
            return TestResult.equal(accuracy, normal);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldNotIgnorePositiveEvasionStageWhenAttacked(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.IRON_HEAD).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            unaware.asWrapper().getBattleStats().modifyStat(1, BattleStatsType.EVASION);
            unaware.attackOpponent(1);
            regi.attackAuto();
            controller.advanceToMoves();
            int normal = regi.asWrapper().attack.getMove().getAccuracy();
            double accuracy = UnawareTests.calculateAccuracy(regi.asWrapper(), unaware.asWrapper());
            return TestResult.equal(accuracy, (double)normal * 0.75);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldNotIgnoreNegativeEvasionStageWhenAttacked(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.IRON_HEAD).build());
        return helper.setupSingleBattleBuilder(unaware, regi).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            unaware.asWrapper().getBattleStats().modifyStat(-1, BattleStatsType.EVASION);
            unaware.attackOpponent(1);
            regi.attackAuto();
            controller.advanceToMoves();
            int normal = regi.asWrapper().attack.getMove().getAccuracy();
            double accuracy = UnawareTests.calculateAccuracy(regi.asWrapper(), unaware.asWrapper());
            return TestResult.equal(accuracy, (double)normal * 1.33);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldBeSuppressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.SPLASH).build());
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.STORM_THROW).build());
        return helper.setupSingleBattleBuilder(unaware, wynaut).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            wynaut.asWrapper().getBattleStats().modifyStat(6, BattleStatsType.ATTACK);
            controller.takeFullTurn(() -> {
                unaware.attackOpponent(1);
                wynaut.attackOpponent(1);
            });
            int damage = unaware.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 59, 69);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldOnlyAffectAttacksWithUnawarePokemon(BattleTestHelper helper) {
        Pokemon unaware = helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.LUCKY_CHANT).build();
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SURF).build();
        TestParticipant unawareTeam = helper.createParticipant(2, unaware, wynaut);
        Pokemon magikarp1 = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.LUCKY_CHANT).build();
        Pokemon magikarp2 = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.LUCKY_CHANT).build();
        TestParticipant luckyTeam = helper.createParticipant(2, magikarp1, magikarp2);
        return helper.setupDoubleBattleBuilder(unawareTeam, luckyTeam).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            unawareTeam.asWrapper(wynaut).getBattleStats().modifyStat(6, BattleStatsType.SPECIAL_ATTACK);
            unawareTeam.attackSelf(unaware, 1);
            unawareTeam.attackAutoTarget(wynaut, 1);
            luckyTeam.attackSelf(magikarp1, 1);
            luckyTeam.attackSelf(magikarp2, 1);
            controller.takeFullTurn();
            int unawareDamage = unawareTeam.asWrapper(unaware).getHealthDeficit();
            TestResult unawareResult = TestResult.damageResult(unawareDamage, 19, 23);
            if (!unawareResult.isSuccess()) {
                return unawareResult;
            }
            int magikarpDamage = luckyTeam.asWrapper(magikarp1).getHealthDeficit();
            TestResult magikarpResult = TestResult.damageResult(magikarpDamage, 104, 123);
            if (!magikarpResult.isSuccess()) {
                return magikarpResult;
            }
            int magikarpDamage2 = luckyTeam.asWrapper(magikarp2).getHealthDeficit();
            TestResult magikarpResult2 = TestResult.damageResult(magikarpDamage2, 104, 123);
            if (!magikarpResult2.isSuccess()) {
                return magikarpResult2;
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnawareShouldIgnoreStatChangesForFoulPlay(BattleTestHelper helper) {
        TestParticipant unaware = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.FOUL_PLAY).build());
        return helper.setupSingleBattleBuilder(unaware, wynaut).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            unaware.asWrapper().getBattleStats().modifyStat(6, BattleStatsType.ATTACK);
            unaware.attackSelf(1);
            wynaut.attackOpponent(1);
            controller.takeFullTurn();
            int unawareDamage = unaware.asWrapper().getHealthDeficit();
            return TestResult.damageResult(unawareDamage, 33, 39);
        });
    }

    private static double calculateAccuracy(PixelmonWrapper user, PixelmonWrapper target) {
        Attack attack = user.attack;
        attack.moveAccuracy = attack.getMove().getAccuracy();
        Ability userAbility = user.getBattleAbility();
        Ability targetAbility = target.getBattleAbility();
        return attack.calculateMoveAccuracy(user, target, userAbility);
    }
}

