/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Truant;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.Sleep;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class TruantTests {
    @BattleTest
    public static CompletableFuture<TestResult> testTruantShouldPreventActingTheTurnAfterAMove(BattleTestHelper helper) {
        TestParticipant truant = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SLAKING).ability(AbilityRegistry.TRUANT).moves(AttackRegistry.SCRATCH).build());
        TestParticipant steelix = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.STEELIX).ability(AbilityRegistry.STURDY).moves(AttackRegistry.ENDURE).build());
        return helper.setupSingleBattleBuilder(truant, steelix).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                truant.attackOpponent(1);
                steelix.attackOpponent(1);
            });
            int damage1 = steelix.asWrapper().getHealthDeficit();
            controller.takeFullTurn(() -> {
                truant.attackOpponent(1);
                steelix.attackOpponent(1);
            });
            int damage2 = steelix.asWrapper().getHealthDeficit();
            if (damage1 != damage2) {
                return TestResult.failure("Slaking attacked twice despite Truant.");
            }
            controller.takeFullTurn(() -> {
                truant.attackOpponent(1);
                steelix.attackOpponent(1);
            });
            int damage3 = steelix.asWrapper().getHealthDeficit();
            if (damage2 == damage3) {
                return TestResult.failure("Slaking couldn't attack despite being Truant last turn.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTruantShouldOccurAtSameTimeAsRecharge(BattleTestHelper helper) {
        TestParticipant truant = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SLAKING).ability(AbilityRegistry.TRUANT).moves(AttackRegistry.HYPER_BEAM).build());
        TestParticipant registeel = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.ENDURE).build());
        return helper.setupSingleBattleBuilder(truant, registeel).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                truant.attackOpponent(1);
                registeel.attackOpponent(1);
            });
            int damage1 = registeel.asWrapper().getHealthDeficit();
            controller.takeFullTurn(() -> {
                truant.attackOpponent(1);
                registeel.attackOpponent(1);
            });
            int damage2 = registeel.asWrapper().getHealthDeficit();
            if (damage1 != damage2) {
                return TestResult.failure("Slaking attacked twice despite Truant.");
            }
            controller.takeFullTurn(() -> {
                truant.attackOpponent(1);
                registeel.attackOpponent(1);
            });
            int damage3 = registeel.asWrapper().getHealthDeficit();
            if (damage2 == damage3) {
                return TestResult.failure("Slaking couldn't attack despite recharging during the Truant turn.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTruantShouldBlockAttackingOnWakeIfMovedTurnWentToSleep(BattleTestHelper helper) {
        TestParticipant truant = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SLAKING).ability(AbilityRegistry.TRUANT).moves(AttackRegistry.REST, AttackRegistry.SCRATCH).build());
        TestParticipant registeel = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.QUICK_ATTACK).build());
        return helper.setupSingleBattleBuilder(truant, registeel).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                truant.attackAutoTarget(1);
                registeel.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                truant.attackOpponent(2);
                registeel.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                truant.attackOpponent(2);
                registeel.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                truant.attackOpponent(2);
                registeel.attackOpponent(1);
            });
            if (!registeel.asWrapper().hasFullHealth()) {
                return TestResult.failure("Slaking attacked on waking despite moving the turn it slept.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTruantShouldNotBlockAttackingOnWakeIfLoafedTurnWentToSleep(BattleTestHelper helper) {
        TestParticipant truant = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SLAKING).ability(AbilityRegistry.TRUANT).moves(AttackRegistry.QUICK_ATTACK).build());
        TestParticipant registeel = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.SPLASH, AttackRegistry.SPORE).build());
        return helper.setupSingleBattleBuilder(truant, registeel).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                truant.attackAutoTarget(1);
                registeel.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                truant.attackOpponent(1);
                registeel.attackOpponent(2);
            });
            ((Sleep)truant.asWrapper().getStatus((StatusType)StatusType.Sleep)).effectTurns = 1;
            controller.takeFullTurn(() -> {
                truant.attackOpponent(1);
                registeel.attackOpponent(1);
            });
            int damage1 = registeel.asWrapper().getHealthDeficit();
            controller.takeFullTurn(() -> {
                truant.attackOpponent(1);
                registeel.attackOpponent(1);
            });
            if (truant.asWrapper().hasStatus(StatusType.Sleep)) {
                return TestResult.failure("Slaking kept sleeping.");
            }
            int damage2 = registeel.asWrapper().getHealthDeficit();
            if (damage1 == damage2) {
                return TestResult.failure("Slaking loafed on waking despite loafing the turn it slept.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTruantShouldContinueWorkingWhileSleepTalking(BattleTestHelper helper) {
        TestParticipant truant = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SLAKING).ability(AbilityRegistry.TRUANT).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.SCRATCH).build());
        TestParticipant registeel = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.SPORE).build());
        return helper.setupSingleBattleBuilder(truant, registeel).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                truant.attackAutoTarget(1);
                registeel.attackOpponent(1);
            });
            ((Sleep)truant.asWrapper().getStatus((StatusType)StatusType.Sleep)).effectTurns = 3;
            if (registeel.asWrapper().hasFullHealth()) {
                return TestResult.failure("Slaking didn't attack despite not moving previously.");
            }
            int damage1 = registeel.asWrapper().getHealthDeficit();
            controller.takeFullTurn(() -> {
                truant.attackAutoTarget(1);
                registeel.attackOpponent(1);
            });
            int damage2 = registeel.asWrapper().getHealthDeficit();
            if (damage1 != damage2 && truant.asWrapper().hasStatus(StatusType.Sleep)) {
                return TestResult.failure("Attacked twice in a row while sleeping");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTruantShouldCauseTwoTurnMovesToFail(BattleTestHelper helper) {
        TestParticipant truant = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SLAKING).ability(AbilityRegistry.TRUANT).moves(AttackRegistry.RAZOR_WIND).build());
        TestParticipant registeel = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.ENDURE).build());
        return helper.setupSingleBattleBuilder(truant, registeel).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                truant.attackAutoTarget(1);
                registeel.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                truant.attackAutoTarget(1);
                registeel.attackOpponent(1);
            });
            if (!registeel.asWrapper().hasFullHealth()) {
                return TestResult.failure("Two Turn move worked");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTruantShouldNotCauseTwoTurnMovesWithPowerHerbToFail(BattleTestHelper helper) {
        TestParticipant truant = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SLAKING).ability(AbilityRegistry.TRUANT).heldItem(PixelmonItems.power_herb).moves(AttackRegistry.RAZOR_WIND).build());
        TestParticipant registeel = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.ENDURE).build());
        return helper.setupSingleBattleBuilder(truant, registeel).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                truant.attackAutoTarget(1);
                registeel.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                truant.attackAutoTarget(1);
                registeel.attackOpponent(1);
            });
            if (registeel.asWrapper().hasFullHealth()) {
                return TestResult.failure("Two Turn move didn't work with Power Herb");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTruantCausesInstantLoafIfMegaEvolvedTurnAbilityGained(BattleTestHelper helper) {
        TestParticipant truant = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DURANT).ability(AbilityRegistry.TRUANT).moves(AttackRegistry.ENTRAINMENT, AttackRegistry.TACKLE).build());
        TestParticipant steelix = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.STEELIX).heldItem(PixelmonItems.steelixite).moves(AttackRegistry.BODY_SLAM).build());
        return helper.setupSingleBattleBuilder(truant, steelix).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                truant.attackOpponent(1);
                steelix.attackOpponent(1);
                steelix.evolve();
            });
            if (!(steelix.asWrapper().getBattleAbility() instanceof Truant)) {
                return TestResult.failure("Entrainment on mega evolving target failed");
            }
            if (!truant.asWrapper().hasFullHealth()) {
                return TestResult.failure("Mega Evolve Truant attacked when it should loaf");
            }
            controller.takeFullTurn(() -> {
                truant.attackOpponent(2);
                steelix.attackOpponent(1);
            });
            if (truant.asWrapper().hasFullHealth()) {
                return TestResult.failure("Mega Evolve Truant loafed when it should attack");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTruantDoesNotCauseInstantLoafIfAbilityGained(BattleTestHelper helper) {
        TestParticipant truant = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DURANT).ability(AbilityRegistry.TRUANT).moves(AttackRegistry.ENTRAINMENT, AttackRegistry.TACKLE).build());
        TestParticipant steelix = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.STEELIX).moves(AttackRegistry.BODY_SLAM).build());
        return helper.setupSingleBattleBuilder(truant, steelix).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                truant.attackAutoTarget(1);
                steelix.attackAutoTarget(1);
            });
            if (!(steelix.asWrapper().getBattleAbility() instanceof Truant)) {
                return TestResult.failure("Entrainment on target failed");
            }
            if (truant.asWrapper().hasFullHealth()) {
                return TestResult.failure("Entrained Truant loafed when it should attack");
            }
            int damage = truant.asWrapper().getHealthDeficit();
            controller.takeFullTurn(() -> {
                truant.attackAutoTarget(2);
                steelix.attackAutoTarget(1);
            });
            int damage2 = truant.asWrapper().getHealthDeficit();
            if (damage != damage2) {
                return TestResult.failure("Entrained Truant attacked when it should loaf");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTruantCausesDoesNotInstantLoafAbilityGainedTrace(BattleTestHelper helper) {
        TestParticipant truant = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DURANT).ability(AbilityRegistry.TRUANT).moves(AttackRegistry.TACKLE).build());
        TestParticipant gardevoir = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GARDEVOIR).ability(AbilityRegistry.TRACE).moves(AttackRegistry.PSYCHIC).build());
        return helper.setupSingleBattleBuilder(truant, gardevoir).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                truant.attackAutoTarget(1);
                gardevoir.attackAutoTarget(1);
            });
            if (!(gardevoir.asWrapper().getBattleAbility() instanceof Truant)) {
                return TestResult.failure("Trace on Truant failed");
            }
            if (truant.asWrapper().hasFullHealth()) {
                return TestResult.failure("Traced Truant loafed when it should attack");
            }
            int damage = truant.asWrapper().getHealthDeficit();
            controller.takeFullTurn(() -> {
                truant.attackAutoTarget(1);
                gardevoir.attackAutoTarget(1);
            });
            int damage2 = truant.asWrapper().getHealthDeficit();
            if (damage != damage2) {
                return TestResult.failure("Traced Truant attacked when it should loaf");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTruantIsSuppressedByNeutralizingGas(BattleTestHelper helper) {
        TestParticipant truant = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SLAKING).ability(AbilityRegistry.TRUANT).moves(AttackRegistry.DRAGON_RAGE).build());
        TestParticipant weezing = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.TACKLE).build());
        return helper.setupSingleBattleBuilder(truant, weezing).forceChance().start().thenApply(controller -> {
            truant.attackOpponent(1);
            weezing.attackOpponent(1);
            controller.takeFullTurn();
            if (weezing.asWrapper().getHealthDeficit() != 40) {
                return TestResult.equal(weezing.asWrapper().getHealthDeficit(), 40.0);
            }
            truant.attackOpponent(1);
            weezing.attackSelf(1);
            controller.takeFullTurn();
            return TestResult.equal(weezing.asWrapper().getHealthDeficit(), 80.0);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTruantCausesInstantLoafIfReplacingEoTFaint(BattleTestHelper helper) {
        Pokemon truant = helper.createDefaultPokemon(PixelmonSpecies.DURANT).ability(AbilityRegistry.TRUANT).moves(AttackRegistry.TACKLE).build();
        Pokemon shedinja = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.WONDER_GUARD).moves(AttackRegistry.TOXIC).heldItem(PixelmonItems.sticky_barb).build();
        TestParticipant pair = helper.createParticipant(1, shedinja, truant);
        TestParticipant steelix = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.STEELIX).moves(AttackRegistry.BODY_SLAM).build());
        return helper.setupSingleBattleBuilder(pair, steelix).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                pair.attackOpponent(1);
                pair.switchPokemon(shedinja, truant);
                steelix.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                pair.attackOpponent(1);
                steelix.attackOpponent(1);
            });
            if (!steelix.asWrapper().hasFullHealth()) {
                return TestResult.failure("Truant didn't loaf after replacing a pokemon who fainted to EoT effects");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTruantDoesNotCauseInstantLoafIfReplacingNonEoTFaint(BattleTestHelper helper) {
        Pokemon truant = helper.createDefaultPokemon(PixelmonSpecies.DURANT).ability(AbilityRegistry.TRUANT).moves(AttackRegistry.TACKLE).build();
        Pokemon shedinja = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.WONDER_GUARD).moves(AttackRegistry.TOXIC).heldItem(PixelmonItems.sticky_barb).build();
        TestParticipant pair = helper.createParticipant(shedinja, truant);
        TestParticipant steelix = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.STEELIX).moves(AttackRegistry.BITE).build());
        return helper.setupSingleBattleBuilder(pair, steelix).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                pair.attackOpponent(1);
                steelix.attackOpponent(1);
                pair.switchPokemon(shedinja, truant);
            });
            controller.takeFullTurn(() -> {
                pair.attackOpponent(1);
                steelix.attackOpponent(1);
            });
            if (steelix.asWrapper().hasFullHealth()) {
                return TestResult.failure("Truant loafed after replacing a pokemon who fainted to a non-EoT cause");
            }
            return TestResult.success();
        });
    }
}

