/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.ComingSoon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Intimidate;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.StanceChange;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Trace;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class TraceTests {
    public static CompletableFuture<TestResult> testTraceHandlesUntraceableSwitchingIntoNullAbilities(BattleTestHelper helper) {
        Pokemon aegislash1 = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.STANCE_CHANGE).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon comingsoon = helper.createDefaultPokemon(PixelmonSpecies.AEGISLASH).ability(AbilityRegistry.COMING_SOON).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon intimidate = helper.createDefaultPokemon(PixelmonSpecies.ARCANINE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant pair = helper.createParticipant(aegislash1, comingsoon, intimidate);
        TestParticipant gardevoir = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GARDEVOIR).ability(AbilityRegistry.TRACE).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(gardevoir, pair).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                pair.switchPokemon(aegislash1, comingsoon);
                gardevoir.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                pair.switchPokemon(comingsoon, intimidate);
                gardevoir.attackOpponent(1);
            });
            if (gardevoir.asWrapper().getBattleAbility() instanceof StanceChange) {
                return TestResult.failure("Gardevoir copied an untraceable ability.");
            }
            if (gardevoir.asWrapper().getBattleAbility() instanceof ComingSoon) {
                return TestResult.failure("Gardevoir copied a null ability ComingSoon.");
            }
            if (!(gardevoir.asWrapper().getBattleAbility() instanceof Intimidate)) {
                return TestResult.failure("Gardevoir failed to copy Intimidate on its switch-in");
            }
            return TestResult.success();
        });
    }

    public static CompletableFuture<TestResult> testTraceHandlesUntraceableSwitchingIntoNullAbilitiesDoubles(BattleTestHelper helper) {
        Pokemon aegislash1 = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.STANCE_CHANGE).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon aegislash2 = helper.createDefaultPokemon(PixelmonSpecies.AEGISLASH).ability(AbilityRegistry.STANCE_CHANGE).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon comingsoon = helper.createDefaultPokemon(PixelmonSpecies.AEGISLASH).ability(AbilityRegistry.COMING_SOON).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon intimidate = helper.createDefaultPokemon(PixelmonSpecies.ARCANINE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant pair = helper.createParticipant(2, aegislash1, aegislash2, comingsoon, intimidate);
        Pokemon magikarp = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.SPLASH).build();
        Pokemon gardevoir = helper.createDefaultPokemon(PixelmonSpecies.GARDEVOIR).ability(AbilityRegistry.TRACE).moves(AttackRegistry.SPLASH).build();
        TestParticipant tracer = helper.createParticipant(2, gardevoir, magikarp);
        return helper.setupDoubleBattleBuilder(tracer, pair).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            controller.takeFullTurn(() -> {
                pair.switchPokemon(aegislash1, comingsoon);
                pair.switchPokemon(aegislash2, intimidate);
                tracer.attackAuto(magikarp);
                tracer.attackAuto(gardevoir);
            });
            if (tracer.asWrapper().getBattleAbility() instanceof StanceChange) {
                return TestResult.failure("Gardevoir copied an untraceable ability.");
            }
            if (tracer.asWrapper().getBattleAbility() instanceof ComingSoon) {
                return TestResult.failure("Gardevoir copied a null ability ComingSoon.");
            }
            if (!(tracer.asWrapper().getBattleAbility() instanceof Intimidate)) {
                return TestResult.failure("Gardevoir failed to copy Intimidate on it switch-in");
            }
            return TestResult.success();
        });
    }

    public static CompletableFuture<TestResult> testTraceDoesNotTraceNullSwitchingIntoTraceableAbilities(BattleTestHelper helper) {
        Pokemon comingsoon = helper.createDefaultPokemon(PixelmonSpecies.AEGISLASH).ability(AbilityRegistry.COMING_SOON).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon intimidate = helper.createDefaultPokemon(PixelmonSpecies.ARCANINE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant pair = helper.createParticipant(comingsoon, intimidate);
        TestParticipant gardevoir = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GARDEVOIR).ability(AbilityRegistry.TRACE).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(gardevoir, pair).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            controller.takeFullTurn(() -> {
                pair.switchPokemon(comingsoon, intimidate);
                gardevoir.attackOpponent(1);
            });
            if (gardevoir.asWrapper().getBattleAbility() instanceof ComingSoon) {
                return TestResult.failure("Gardevoir copied a null ability ComingSoon.");
            }
            if (gardevoir.asWrapper().getBattleAbility() instanceof Intimidate) {
                return TestResult.failure("Gardevoir copied Intimidate with it should have broken.");
            }
            if (!(gardevoir.asWrapper().getBattleAbility() instanceof Trace)) {
                return TestResult.failure("Gardevoir lost its ability");
            }
            return TestResult.success();
        });
    }

    public static CompletableFuture<TestResult> testTraceDoesNotTraceNullSwitchingIntoTraceableAbilitiesDoubles(BattleTestHelper helper) {
        Pokemon aegislash1 = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.STANCE_CHANGE).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon aegislash2 = helper.createDefaultPokemon(PixelmonSpecies.AEGISLASH).ability(AbilityRegistry.STANCE_CHANGE).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon comingsoon = helper.createDefaultPokemon(PixelmonSpecies.AEGISLASH).ability(AbilityRegistry.COMING_SOON).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon intimidate = helper.createDefaultPokemon(PixelmonSpecies.ARCANINE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant pair = helper.createParticipant(2, comingsoon, aegislash2, intimidate, aegislash1);
        Pokemon magikarp = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.SPLASH).build();
        Pokemon gardevoir = helper.createDefaultPokemon(PixelmonSpecies.GARDEVOIR).ability(AbilityRegistry.TRACE).moves(AttackRegistry.SPLASH).build();
        TestParticipant tracer = helper.createParticipant(2, gardevoir, magikarp);
        return helper.setupDoubleBattleBuilder(tracer, pair).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            controller.takeFullTurn(() -> {
                pair.switchPokemon(comingsoon, aegislash1);
                pair.switchPokemon(aegislash2, intimidate);
                tracer.attackOpponent(gardevoir, 1);
                tracer.attackOpponent(magikarp, 1);
            });
            if (tracer.asWrapper().getBattleAbility() instanceof ComingSoon) {
                return TestResult.failure("Gardevoir copied a null ability ComingSoon.");
            }
            if (tracer.asWrapper().getBattleAbility() instanceof StanceChange) {
                return TestResult.failure("Gardevoir copied an untraceable ability.");
            }
            if (tracer.asWrapper().getBattleAbility() instanceof Intimidate) {
                return TestResult.failure("Gardevoir copied Intimidate with it should have broken.");
            }
            if (!(tracer.asWrapper().getBattleAbility() instanceof Trace)) {
                return TestResult.failure("Gardevoir lost its ability somehow.");
            }
            return TestResult.success();
        });
    }

    public static CompletableFuture<TestResult> testTraceDoesNotRemoveAbilities(BattleTestHelper helper) {
        TestParticipant intimidate = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ARCANINE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant gardevoir = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GARDEVOIR).ability(AbilityRegistry.TRACE).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(gardevoir, intimidate).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            controller.takeFullTurn(() -> {
                intimidate.attackOpponent(1);
                gardevoir.attackOpponent(1);
            });
            if (!(gardevoir.asWrapper().getBattleAbility() instanceof Intimidate)) {
                return TestResult.failure("Gardevoir failed to trace Intimidate.");
            }
            if (!(intimidate.asWrapper().getBattleAbility() instanceof Intimidate)) {
                return TestResult.failure("Arcanine lost Intimidate when it was traced.");
            }
            return TestResult.success();
        });
    }
}

