/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ThickFatTests {
    @BattleTest
    public static CompletableFuture<TestResult> testThickFatShouldHalveDamageOfFireTypeSpecialAttacks(BattleTestHelper helper) {
        TestParticipant miltank = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MILTANK).ability(AbilityRegistry.THICK_FAT).heldItem(PixelmonItems.lum_berry).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.FLAMETHROWER).build());
        return helper.setupSingleBattleBuilder(miltank, wynaut).forceChance().start().thenApply(controller -> {
            miltank.attackOpponent(1);
            wynaut.attackOpponent(1);
            controller.takeFullTurn();
            return TestResult.damageResult(miltank.asWrapper().getHealthDeficit(), 17, 20);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testThickFatShouldHalveDamageOfIceTypeSpecialAttacks(BattleTestHelper helper) {
        TestParticipant miltank = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MILTANK).ability(AbilityRegistry.THICK_FAT).heldItem(PixelmonItems.lum_berry).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.ICE_BEAM).build());
        return helper.setupSingleBattleBuilder(miltank, wynaut).forceChance().start().thenApply(controller -> {
            miltank.attackOpponent(1);
            wynaut.attackOpponent(1);
            controller.takeFullTurn();
            return TestResult.damageResult(miltank.asWrapper().getHealthDeficit(), 17, 20);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testThickFatShouldHalveDamageOfFireTypePhysicalAttacks(BattleTestHelper helper) {
        TestParticipant miltank = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MILTANK).ability(AbilityRegistry.THICK_FAT).heldItem(PixelmonItems.lum_berry).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.FLAME_CHARGE).build());
        return helper.setupSingleBattleBuilder(miltank, wynaut).forceChance().start().thenApply(controller -> {
            miltank.attackOpponent(1);
            wynaut.attackOpponent(1);
            controller.takeFullTurn();
            return TestResult.damageResult(miltank.asWrapper().getHealthDeficit(), 7, 9);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testThickFatShouldHalveDamageOfIceTypePhysicalAttacks(BattleTestHelper helper) {
        TestParticipant miltank = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MILTANK).ability(AbilityRegistry.THICK_FAT).heldItem(PixelmonItems.lum_berry).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.ICE_FANG).build());
        return helper.setupSingleBattleBuilder(miltank, wynaut).forceChance().start().thenApply(controller -> {
            miltank.attackOpponent(1);
            wynaut.attackOpponent(1);
            controller.takeFullTurn();
            return TestResult.damageResult(miltank.asWrapper().getHealthDeficit(), 9, 11);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testThickFatShouldBeSuppressedByMoldbreaker(BattleTestHelper helper) {
        TestParticipant miltank = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MILTANK).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant pinsir = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PINSIR).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.ICE_FANG).build());
        return helper.setupSingleBattleBuilder(miltank, pinsir).forceChance().start().thenApply(controller -> {
            miltank.attackOpponent(1);
            pinsir.attackOpponent(1);
            controller.takeFullTurn();
            return TestResult.damageResult(miltank.asWrapper().getHealthDeficit(), 55, 65);
        });
    }
}

