/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class TechnicianTests {
    @BattleTest
    public static CompletableFuture<TestResult> testTechnicianShouldBoostMovesEqualTo60Power(BattleTestHelper helper) {
        TestParticipant breloom = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRELOOM).moves(AttackRegistry.SHADOW_PUNCH).ability(AbilityRegistry.TECHNICIAN).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.SHELL_ARMOUR).build());
        return helper.setupSingleBattleBuilder(breloom, regi).forceChance().start().thenApply(controller -> {
            breloom.attackOpponent(1);
            regi.attackOpponent(1);
            controller.takeFullTurn();
            return TestResult.damageResult(regi.asWrapper().getHealthDeficit(), 57, 69);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTechnicianShouldBoostMovesBelow60Power(BattleTestHelper helper) {
        TestParticipant breloom = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRELOOM).moves(AttackRegistry.MACH_PUNCH).ability(AbilityRegistry.TECHNICIAN).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.SHELL_ARMOUR).build());
        return helper.setupSingleBattleBuilder(breloom, regi).forceChance().start().thenApply(controller -> {
            breloom.attackOpponent(1);
            regi.attackOpponent(1);
            controller.takeFullTurn();
            return TestResult.damageResult(regi.asWrapper().getHealthDeficit(), 116, 138);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTechnicianShouldBoostMultihitMovesBelow60Power(BattleTestHelper helper) {
        TestParticipant breloom = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRELOOM).moves(AttackRegistry.SURGING_STRIKES).ability(AbilityRegistry.TECHNICIAN).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.SHELL_ARMOUR).build());
        return helper.setupSingleBattleBuilder(breloom, regi).forceChance().start().thenApply(controller -> {
            breloom.attackOpponent(1);
            regi.attackOpponent(1);
            controller.takeFullTurn();
            return TestResult.damageResult(regi.asWrapper().getHealthDeficit(), 72, 87);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTechnicianShouldBoostVariableMovesBelow60Power(BattleTestHelper helper) {
        TestParticipant breloom = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRELOOM).moves(AttackRegistry.RAGE_FIST).ability(AbilityRegistry.TECHNICIAN).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.SHELL_ARMOUR).build());
        return helper.setupSingleBattleBuilder(breloom, regi).forceChance().start().thenApply(controller -> {
            breloom.attackOpponent(1);
            regi.attackOpponent(1);
            controller.takeFullTurn();
            return TestResult.damageResult(regi.asWrapper().getHealthDeficit(), 48, 58);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTechnicianShouldNotBoostMovesBelow60PowerWithOverridePowerOver60Power(BattleTestHelper helper) {
        TestParticipant breloom = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRELOOM).moves(AttackRegistry.RAGE_FIST).ability(AbilityRegistry.TECHNICIAN).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).moves(AttackRegistry.QUICK_ATTACK).ability(AbilityRegistry.SHELL_ARMOUR).build());
        return helper.setupSingleBattleBuilder(breloom, regi).forceChance().start().thenApply(controller -> {
            breloom.attackOpponent(1);
            regi.attackOpponent(1);
            controller.takeFullTurn();
            return TestResult.damageResult(regi.asWrapper().getHealthDeficit(), 64, 76);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTechnicianShouldBoostMovesBeforeHeldItemBoosts(BattleTestHelper helper) {
        TestParticipant breloom = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRELOOM).moves(AttackRegistry.SHADOW_PUNCH).ability(AbilityRegistry.TECHNICIAN).heldItem(PixelmonItems.punching_glove).build());
        TestParticipant regi = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.SHELL_ARMOUR).build());
        return helper.setupSingleBattleBuilder(breloom, regi).forceChance().start().thenApply(controller -> {
            breloom.attackOpponent(1);
            regi.attackOpponent(1);
            controller.takeFullTurn();
            return TestResult.damageResult(regi.asWrapper().getHealthDeficit(), 63, 75);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTechnicianShouldBoostMovesBeforeAllyAbilities(BattleTestHelper helper) {
        Pokemon breloom = helper.createDefaultPokemon(PixelmonSpecies.BRELOOM).moves(AttackRegistry.DRAGON_BREATH).ability(AbilityRegistry.TECHNICIAN).build();
        Pokemon charjabug = helper.createDefaultPokemon(PixelmonSpecies.CHARJABUG).moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.BATTERY).build();
        TestParticipant technician = helper.createParticipant(2, breloom, charjabug);
        Pokemon regi1 = helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.SHELL_ARMOUR).build();
        Pokemon regi2 = helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.SHELL_ARMOUR).build();
        TestParticipant regi = helper.createParticipant(2, regi1, regi2);
        return helper.setupDoubleBattleBuilder(technician, regi).forceChance().start().thenApply(controller -> {
            technician.attackOpponent(breloom, 1);
            technician.attackOpponent(charjabug, 1);
            regi.attackOpponent(regi1, 1);
            regi.attackOpponent(regi2, 1);
            controller.takeFullTurn();
            return TestResult.damageResult(regi.asWrapper().getHealthDeficit(), 19, 23);
        });
    }
}

