/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SynchronizeTests {
    @BattleTest
    public static CompletableFuture<TestResult> testSynchronizeOccursBeforeBerries(BattleTestHelper helper) {
        TestParticipant ralts = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ARCANINE).ability(AbilityRegistry.SYNCHRONIZE).moves(AttackRegistry.GLARE).heldItem(PixelmonItems.lum_berry).build());
        TestParticipant gardevoir = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GARDEVOIR).ability(AbilityRegistry.SYNCHRONIZE).moves(AttackRegistry.SPLASH).heldItem(PixelmonItems.lum_berry).build());
        return helper.setupSingleBattleBuilder(gardevoir, ralts).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                ralts.attackOpponent(1);
                gardevoir.attackOpponent(1);
            });
            if (gardevoir.asWrapper().hasStatus(StatusType.Paralysis)) {
                return TestResult.failure("Gardevoir is paralyzed despite holding a lum berry.");
            }
            if (ralts.asWrapper().hasStatus(StatusType.Paralysis)) {
                return TestResult.failure("Ralts is paralyzed despite holding a lum berry.");
            }
            if (gardevoir.asWrapper().hasHeldItem()) {
                return TestResult.failure("Gardevoir still has a lum berry after it should have been paralyzed.");
            }
            if (ralts.asWrapper().hasHeldItem()) {
                return TestResult.failure("Ralts still has a lum berry after it should have been paralyzed.");
            }
            return TestResult.success();
        });
    }
}

