/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.items.heldItems.ChoiceItem;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SymbiosisTests {
    @BattleTest
    public static CompletableFuture<TestResult> testSymbiosisSharesItsItemWithItsAlly(BattleTestHelper helper) {
        Pokemon symbiosis = helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.SYMBIOSIS).heldItem(PixelmonItems.choice_band).moves(AttackRegistry.SPLASH).build();
        Pokemon latias = helper.createDefaultPokemon(PixelmonSpecies.LATIAS).ability(AbilityRegistry.LEVITATE).heldItem(PixelmonItems.weakness_policy).moves(AttackRegistry.SPLASH).build();
        TestParticipant symbiote = helper.createParticipant(2, symbiosis, latias);
        Pokemon magikarp1 = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.BITE).build();
        Pokemon magikarp2 = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.BITE).build();
        TestParticipant karps = helper.createParticipant(2, magikarp1, magikarp2);
        return helper.setupDoubleBattleBuilder(symbiote, karps).forceChance().start().thenApply(controller -> {
            symbiote.attackOpponent(symbiosis, 1);
            symbiote.attackOpponent(latias, 1);
            karps.attackTarget(magikarp1, 1, latias);
            karps.attackTarget(magikarp2, 1, symbiosis);
            controller.takeFullTurn();
            if (symbiote.asWrapper(latias).hasFullHealth()) {
                return TestResult.failure("Latias should have been attacked.");
            }
            if (symbiote.asWrapper(latias).getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("Latias should have activated its WeaknessPolicy.");
            }
            if (symbiote.asWrapper(symbiosis).hasHeldItem()) {
                return TestResult.failure("Smeargle should have given its item to Latias.");
            }
            if (!(symbiote.asWrapper(latias).getHeldItem() instanceof ChoiceItem)) {
                return TestResult.failure("Latias should have gotten its item from Smeargle.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSymbiosisDoesNotShareSpecialItems(BattleTestHelper helper) {
        Pokemon symbiosis = helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.SYMBIOSIS).heldItem(PixelmonItems.latiasite).moves(AttackRegistry.SPLASH).build();
        Pokemon latias = helper.createDefaultPokemon(PixelmonSpecies.LATIAS).ability(AbilityRegistry.LEVITATE).heldItem(PixelmonItems.weakness_policy).moves(AttackRegistry.SPLASH).build();
        TestParticipant symbiote = helper.createParticipant(2, symbiosis, latias);
        Pokemon magikarp1 = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.BITE).build();
        Pokemon magikarp2 = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.BITE).build();
        TestParticipant karps = helper.createParticipant(2, magikarp1, magikarp2);
        return helper.setupDoubleBattleBuilder(symbiote, karps).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            symbiote.attackOpponent(symbiosis, 1);
            symbiote.attackOpponent(latias, 1);
            karps.attackTarget(magikarp1, 1, latias);
            karps.attackTarget(magikarp2, 1, symbiosis);
            controller.takeFullTurn();
            if (symbiote.asWrapper(latias).hasFullHealth()) {
                return TestResult.failure("Latias should have been attacked.");
            }
            if (symbiote.asWrapper(latias).getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("Latias should have activated its WeaknessPolicy.");
            }
            if (!symbiote.asWrapper(symbiosis).hasHeldItem()) {
                return TestResult.failure("Smeargle should have kept its item from Latias.");
            }
            if (!(symbiote.asWrapper(latias).getHeldItem() instanceof NoItem)) {
                return TestResult.failure("Latias should not have gotten an item.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSymbiosisDoesNotShareOnEjectPackUse(BattleTestHelper helper) {
        Pokemon symbiosis = helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.SYMBIOSIS).heldItem(PixelmonItems.leftovers).moves(AttackRegistry.SPLASH).build();
        Pokemon latias = helper.createDefaultPokemon(PixelmonSpecies.LATIAS).ability(AbilityRegistry.LEVITATE).heldItem(PixelmonItems.eject_button).moves(AttackRegistry.SPLASH).build();
        Pokemon corphish = helper.createDefaultPokemon(PixelmonSpecies.CORPHISH).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SPLASH).build();
        TestParticipant symbiote = helper.createParticipant(2, symbiosis, latias, corphish);
        Pokemon magikarp1 = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.BITE).build();
        Pokemon magikarp2 = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.BITE).build();
        TestParticipant karps = helper.createParticipant(2, magikarp1, magikarp2);
        return helper.setupDoubleBattleBuilder(symbiote, karps).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            symbiote.attackOpponent(symbiosis, 1);
            symbiote.attackOpponent(latias, 1);
            symbiote.switchPokemon(latias, corphish);
            karps.attackTarget(magikarp1, 1, latias);
            karps.attackTarget(magikarp2, 1, symbiosis);
            controller.takeFullTurn();
            PixelmonWrapper pwLatias = symbiote.asWrapper(latias);
            PixelmonWrapper pwCorphish = symbiote.asWrapper(corphish);
            PixelmonWrapper pwSmeargle = symbiote.asWrapper(symbiosis);
            if (!pwCorphish.onBattlefield || pwLatias.onBattlefield) {
                return TestResult.failure("Latias should have switched to Corphish.");
            }
            if (pwCorphish.hasHeldItem()) {
                return TestResult.failure("Corphish should not have any item.");
            }
            if (!pwSmeargle.hasHeldItem()) {
                return TestResult.failure("Smeargle should not have given its item away.");
            }
            if (pwLatias.hasHeldItem()) {
                return TestResult.failure("Latias should have used up its Eject Button.");
            }
            return TestResult.success();
        });
    }
}

