/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SwordOfRuinTests {
    @BattleTest
    public static CompletableFuture<TestResult> testSwordOfRuinLowersOtherPokemonsDefense(BattleTestHelper helper) {
        TestParticipant regieleki = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant chienpao = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CHIEN_PAO).ability(AbilityRegistry.SWORD_OF_RUIN).moves(AttackRegistry.AERIAL_ACE).build());
        return helper.setupSingleBattleBuilder(regieleki, chienpao).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                regieleki.attackOpponent(1);
                chienpao.attackOpponent(1);
            });
            return TestResult.damageResult(regieleki.asWrapper().getHealthDeficit(), 58, 69);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSwordOfRuinDoesNotLowerOtherSoRPokemonsDefense(BattleTestHelper helper) {
        TestParticipant regieleki = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.SWORD_OF_RUIN).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant chienpao = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CHIEN_PAO).ability(AbilityRegistry.SWORD_OF_RUIN).moves(AttackRegistry.AERIAL_ACE).build());
        return helper.setupSingleBattleBuilder(regieleki, chienpao).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                regieleki.attackSelf(1);
                chienpao.attackOpponent(1);
            });
            return TestResult.damageResult(regieleki.asWrapper().getHealthDeficit(), 44, 52);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSwordOfRuinDoesLowerOtherOfRuinPokemonsDefense(BattleTestHelper helper) {
        TestParticipant regieleki = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.VESSEL_OF_RUIN).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant chienpao = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CHIEN_PAO).ability(AbilityRegistry.SWORD_OF_RUIN).moves(AttackRegistry.AERIAL_ACE).build());
        return helper.setupSingleBattleBuilder(regieleki, chienpao).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                regieleki.attackSelf(1);
                chienpao.attackOpponent(1);
            });
            return TestResult.damageResult(regieleki.asWrapper().getHealthDeficit(), 58, 69);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSwordOfRuinLowersAllyPokemonsDefense(BattleTestHelper helper) {
        Pokemon regieleki = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.TRANSISTOR).moves(AttackRegistry.LUCKY_CHANT).build();
        Pokemon chienpao = helper.createDefaultPokemon(PixelmonSpecies.CHIEN_PAO).ability(AbilityRegistry.SWORD_OF_RUIN).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant team = helper.createParticipant(2, regieleki, chienpao);
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GYARADOS).ability(AbilityRegistry.MOXIE).moves(AttackRegistry.WATERFALL).build());
        return helper.setupDoubleBattleBuilder(team, opponent).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.attackSelf(regieleki, 1);
                team.attackOpponent(chienpao, 1);
                opponent.attackTarget(1, regieleki);
            });
            return TestResult.damageResult(team.asWrapper(regieleki).getHealthDeficit(), 241, 285);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSwordOfRuinDoesNotLowerOwnDefense(BattleTestHelper helper) {
        Pokemon regieleki = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.TRANSISTOR).moves(AttackRegistry.LUCKY_CHANT).build();
        Pokemon chienpao = helper.createDefaultPokemon(PixelmonSpecies.CHIEN_PAO).ability(AbilityRegistry.SWORD_OF_RUIN).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant team = helper.createParticipant(2, regieleki, chienpao);
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GYARADOS).ability(AbilityRegistry.MOXIE).moves(AttackRegistry.WATERFALL).build());
        return helper.setupDoubleBattleBuilder(team, opponent).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.attackSelf(regieleki, 1);
                team.attackOpponent(chienpao, 1);
                opponent.attackTarget(1, chienpao);
            });
            return TestResult.damageResult(team.asWrapper(chienpao).getHealthDeficit(), 127, 150);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSwordOfRuinDoesNotStack(BattleTestHelper helper) {
        Pokemon ofRuin1 = helper.createDefaultPokemon(PixelmonSpecies.CHIEN_PAO).ability(AbilityRegistry.SWORD_OF_RUIN).moves(AttackRegistry.WATERFALL).build();
        Pokemon ofRuin2 = helper.createDefaultPokemon(PixelmonSpecies.CHIEN_PAO).ability(AbilityRegistry.SWORD_OF_RUIN).moves(AttackRegistry.SPLASH).build();
        TestParticipant team = helper.createParticipant(2, ofRuin1, ofRuin2);
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupDoubleBattleBuilder(team, opponent).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.attackOpponent(ofRuin1, 1);
                team.attackOpponent(ofRuin2, 1);
                opponent.attackOpponent(1);
            });
            return TestResult.damageResult(opponent.asWrapper().getHealthDeficit(), 63, 76);
        });
    }
}

