/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SuctionCupsTests {
    @BattleTest
    public static CompletableFuture<TestResult> testSuctionCupsPreventBeingForcedOut(BattleTestHelper helper) {
        Pokemon suctioncups = helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.SUCTION_CUPS).moves(AttackRegistry.RAPID_SPIN).build();
        Pokemon reserve = helper.createDefaultPokemon(PixelmonSpecies.FORRETRESS).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).build();
        TestParticipant team = helper.createParticipant(suctioncups, reserve);
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).moves(AttackRegistry.HEAL_PULSE, AttackRegistry.DRAGON_TAIL, AttackRegistry.CIRCLE_THROW, AttackRegistry.ROAR).ability(AbilityRegistry.SHELL_ARMOUR).heldItem(PixelmonItems.red_card).build());
        return helper.setupSingleBattleBuilder(team, opponent).forceChance().start().thenApply(controller -> {
            for (int i = 1; i <= 4; ++i) {
                team.attackOpponent(1);
                team.switchPokemon(suctioncups, reserve);
                opponent.attackOpponent(i);
                controller.takeFullTurn();
                if (!team.asWrapper().getSpecies().is(PixelmonSpecies.FORRETRESS)) continue;
                return TestResult.failure("Forretress was somehow forced out on turn " + i);
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSuctionCupsIsSuppressedByMoldBreaker(BattleTestHelper helper) {
        Pokemon suctioncups = helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.SUCTION_CUPS).moves(AttackRegistry.SPLASH).build();
        Pokemon reserve = helper.createDefaultPokemon(PixelmonSpecies.FORRETRESS).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).build();
        TestParticipant team = helper.createParticipant(suctioncups, reserve);
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).moves(AttackRegistry.ROAR).ability(AbilityRegistry.MOLD_BREAKER).build());
        return helper.setupSingleBattleBuilder(team, opponent).forceChance().start().thenApply(controller -> {
            team.attackOpponent(1);
            team.switchPokemon(suctioncups, reserve);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (!team.asWrapper().getSpecies().is(PixelmonSpecies.FORRETRESS)) {
                return TestResult.failure("Shuckle managed to stay in battle");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSuctionCupsDoesNotPreventSwitchMoves(BattleTestHelper helper) {
        Pokemon suctioncups = helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.SUCTION_CUPS).moves(AttackRegistry.VOLT_SWITCH).build();
        Pokemon reserve = helper.createDefaultPokemon(PixelmonSpecies.FORRETRESS).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).build();
        TestParticipant team = helper.createParticipant(suctioncups, reserve);
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(team, opponent).forceChance().start().thenApply(controller -> {
            team.attackOpponent(1);
            team.switchPokemon(suctioncups, reserve);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (!team.asWrapper().getSpecies().is(PixelmonSpecies.FORRETRESS)) {
                return TestResult.failure("Shuckle stayed in battle after using a switch move");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSuctionCupsDoesNotPreventVoluntarySwitches(BattleTestHelper helper) {
        Pokemon suctioncups = helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.SUCTION_CUPS).moves(AttackRegistry.SPLASH).build();
        Pokemon reserve = helper.createDefaultPokemon(PixelmonSpecies.FORRETRESS).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).build();
        TestParticipant team = helper.createParticipant(suctioncups, reserve);
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(team, opponent).forceChance().start().thenApply(controller -> {
            team.switchPokemon(suctioncups, reserve);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (!team.asWrapper().getSpecies().is(PixelmonSpecies.FORRETRESS)) {
                return TestResult.failure("Shuckle stayed in battle after trying to switch");
            }
            return TestResult.success();
        });
    }
}

