/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SturdyTests {
    @BattleTest
    public static CompletableFuture<TestResult> testSturdyBlocksOHKOMoves(BattleTestHelper helper) {
        TestParticipant sturdy = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.FORRETRESS).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).moves(AttackRegistry.TACKLE, AttackRegistry.FISSURE).ability(AbilityRegistry.NO_GUARD).build());
        return helper.setupSingleBattleBuilder(sturdy, opponent).forceChance().start().thenApply(controller -> {
            sturdy.attackOpponent(1);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            sturdy.attackOpponent(1);
            opponent.attackOpponent(2);
            if (sturdy.allPokemon[0].isFainted()) {
                return TestResult.failure("Sturdy Forretress was KO'd by Fissure");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSturdyAllowsSurvivalOfAnAttackFromFullHP(BattleTestHelper helper) {
        TestParticipant sturdy = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PARAS).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CHARIZARD).moves(AttackRegistry.FUSION_FLARE).ability(AbilityRegistry.DROUGHT).build());
        return helper.setupSingleBattleBuilder(sturdy, opponent).forceChance().start().thenApply(controller -> {
            sturdy.attackOpponent(1);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (sturdy.allPokemon[0].isFainted()) {
                return TestResult.failure("Sturdy Paras was KO'd an attack at full HP");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSturdyCanBlockConfusionDamageFromFullHP(BattleTestHelper helper) {
        TestParticipant sturdy = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KLEFKI).moves(AttackRegistry.CONFUSE_RAY).ability(AbilityRegistry.PRANKSTER).build());
        return helper.setupSingleBattleBuilder(sturdy, opponent).forceChance().start().thenApply(controller -> {
            sturdy.attackOpponent(1);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (sturdy.allPokemon[0].isFainted()) {
                return TestResult.failure("Sturdy Shedinja did not survive confusion damage.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSturdyCanBlockMultiHitIfAllHitsFromFullHP(BattleTestHelper helper) {
        TestParticipant sturdy = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GRENINJA).moves(AttackRegistry.WATER_SHURIKEN).build());
        return helper.setupSingleBattleBuilder(sturdy, opponent).forceChance().start().thenApply(controller -> {
            sturdy.attackOpponent(1);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (sturdy.allPokemon[0].isFainted()) {
                return TestResult.failure("Sturdy Shedinja did not survive a multi-hit attack damage.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSturdyCannotBlockMultiHitIfNotAllHitsFromFullHP(BattleTestHelper helper) {
        TestParticipant sturdy = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GEODUDE).level(5).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GRENINJA).moves(AttackRegistry.WATER_SHURIKEN).build());
        return helper.setupSingleBattleBuilder(sturdy, opponent).forceChance().start().thenApply(controller -> {
            sturdy.attackOpponent(1);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (!sturdy.allPokemon[0].isFainted()) {
                return TestResult.failure("Sturdy lvl5 Geodude survived a multi-hit attack.");
            }
            if (!sturdy.hasMessageContaining("pixelmon.abilities.sturdy")) {
                return TestResult.failure("Sturdy did not prevent any hits");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSturdyCannotBlockDestinyBond(BattleTestHelper helper) {
        TestParticipant sturdy = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GEODUDE).ability(AbilityRegistry.STURDY).moves(AttackRegistry.ROCK_THROW).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.COTTONEE).level(5).moves(AttackRegistry.DESTINY_BOND).ability(AbilityRegistry.PRANKSTER).build());
        return helper.setupSingleBattleBuilder(sturdy, opponent).forceChance().start().thenApply(controller -> {
            sturdy.attackOpponent(1);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (!opponent.allPokemon[0].isFainted()) {
                return TestResult.failure("Opponent didn't faint.");
            }
            if (!sturdy.allPokemon[0].isFainted()) {
                return TestResult.failure("Sturdy Geodude survived destiny bond.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSturdyCannotBlockPerishSong(BattleTestHelper helper) {
        TestParticipant sturdy = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GEODUDE).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.COTTONEE).moves(AttackRegistry.PERISH_SONG).ability(AbilityRegistry.SOUNDPROOF).build());
        return helper.setupSingleBattleBuilder(sturdy, opponent).forceChance().start().thenApply(controller -> {
            for (int i = 0; i < 4; ++i) {
                sturdy.attackOpponent(1);
                opponent.attackAutoTarget(1);
                controller.takeFullTurn();
            }
            if (!sturdy.allPokemon[0].isFainted()) {
                return TestResult.failure("Sturdy Geodude survived perish song.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSturdyDoesNotProtectAgainstRecoil(BattleTestHelper helper) {
        TestParticipant sturdy = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.STURDY).moves(AttackRegistry.DOUBLE_EDGE).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KLEFKI).moves(AttackRegistry.SPLASH).ability(AbilityRegistry.PRANKSTER).build());
        return helper.setupSingleBattleBuilder(sturdy, opponent).forceChance().start().thenApply(controller -> {
            sturdy.attackOpponent(1);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (!sturdy.allPokemon[0].isFainted()) {
                return TestResult.failure("Sturdy Shedinja survived recoil damage.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSturdyDoesNotBlockResidualDamage(BattleTestHelper helper) {
        TestParticipant sturdy = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GENGAR).moves(AttackRegistry.TOXIC).build());
        return helper.setupSingleBattleBuilder(sturdy, opponent).forceChance().start().thenApply(controller -> {
            sturdy.attackOpponent(1);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (!sturdy.allPokemon[0].isFainted()) {
                return TestResult.failure("Sturdy Shedinja survived toxic damage.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSturdyCanSuppressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant sturdy = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KLEFKI).moves(AttackRegistry.ICE_BEAM).ability(AbilityRegistry.MOLD_BREAKER).build());
        return helper.setupSingleBattleBuilder(sturdy, opponent).forceChance().start().thenApply(controller -> {
            sturdy.attackOpponent(1);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (!sturdy.allPokemon[0].isFainted()) {
                return TestResult.failure("Sturdy Shedinja survived despite Sturdy being suppressed.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSturdyTriggersBeforeFocusSash(BattleTestHelper helper) {
        TestParticipant sturdy = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).heldItem(PixelmonItems.focus_sash).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CRYOGONAL).moves(AttackRegistry.ICE_BEAM).build());
        return helper.setupSingleBattleBuilder(sturdy, opponent).forceChance().start().thenApply(controller -> {
            sturdy.attackOpponent(1);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (sturdy.allPokemon[0].isFainted()) {
                return TestResult.failure("Sturdy Shedinja did not survive damage.");
            }
            if (!sturdy.asWrapper().hasHeldItem()) {
                return TestResult.failure("Sturdy Shedinja used Focus Sash first.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSturdyShouldNotTriggerWhenUsingEndure(BattleTestHelper helper) {
        TestParticipant sturdy = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.STURDY).moves(AttackRegistry.ENDURE).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KLEFKI).moves(AttackRegistry.ICE_BEAM).build());
        return helper.setupSingleBattleBuilder(sturdy, opponent).forceChance().start().thenApply(controller -> {
            sturdy.attackSelf(1);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (sturdy.hasMessageContaining("sturdy")) {
                return TestResult.failure("Shedinja used Sturdy to survive when using Endure.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSturdyShouldNotTriggerWhenUsingFalseSwipe(BattleTestHelper helper) {
        TestParticipant sturdy = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPLASH).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KLEFKI).moves(AttackRegistry.FALSE_SWIPE).ability(AbilityRegistry.SCRAPPY).build());
        return helper.setupSingleBattleBuilder(sturdy, opponent).forceChance().start().thenApply(controller -> {
            sturdy.attackSelf(1);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (sturdy.hasMessageContaining("sturdy")) {
                return TestResult.failure("Shedinja used Sturdy to survive when hit by false swipe.");
            }
            return TestResult.success();
        });
    }
}

