/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class StormDrainTests {
    @BattleTest
    public static CompletableFuture<TestResult> testShouldGrantImmunityToWaterAndBoostSpAtk(BattleTestHelper helper) {
        TestParticipant stormdrain = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.AQUA_JET).build());
        return helper.setupSingleBattleBuilder(stormdrain, attacker).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                stormdrain.attackOpponent(1);
                attacker.attackOpponent(1);
            });
            if (!stormdrain.asWrapper().hasFullHealth()) {
                return TestResult.failure("Storm Drain should provide immunity to Water moves");
            }
            if (stormdrain.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 1) {
                return TestResult.failure("Being hit by a Water move should increase Sp.Atk. by 1 stage.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldRedirectAlliedMaxGeyser(BattleTestHelper helper) {
        Pokemon stormdrain = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon attacker = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.AQUA_JET).build();
        TestParticipant defender = helper.createParticipant(2, stormdrain, attacker);
        TestParticipant target = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GOLEM).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupDoubleBattleBuilder(defender, target).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                defender.attackOpponent(stormdrain, 1);
                defender.attackOpponent(attacker, 1);
                defender.evolve(attacker);
                target.attackOpponent(1);
            });
            if (defender.asWrapper((Pokemon)attacker).isDynamax != 1 || !defender.asWrapper((Pokemon)attacker).lastAttack.isMax) {
                return TestResult.failure("Azumarill did not dynamax");
            }
            if (!target.asWrapper().hasFullHealth()) {
                return TestResult.failure("Storm Drain should redirect Max Geyser");
            }
            if (!defender.asWrapper(stormdrain).hasFullHealth()) {
                return TestResult.failure("Storm Drain should provide immunity to Water moves");
            }
            if (defender.asWrapper(stormdrain).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 1) {
                return TestResult.failure("Being hit by a Water move should increase Sp.Atk. by 1 stage.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldRedirectSingleTargetWaterAttacksIfValidTarget(BattleTestHelper helper) {
        Pokemon stormdrain = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.AQUA_JET).build();
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.AQUA_JET).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.AQUA_JET).build();
        TestParticipant attacker = helper.createParticipant(3, stormdrain, attacker1, attacker2);
        Pokemon defender1 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.AQUA_JET).build();
        Pokemon defender2 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.AQUA_JET).build();
        Pokemon defender3 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.AQUA_JET).build();
        TestParticipant defender = helper.createParticipant(3, defender1, defender2, defender3);
        return helper.setupTripleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(stormdrain, 1, defender1);
                attacker.attackTarget(attacker1, 1, defender2);
                attacker.attackTarget(attacker2, 1, defender3);
                defender.attackTarget(defender1, 1, stormdrain);
                defender.attackTarget(defender2, 1, attacker1);
                defender.attackTarget(defender3, 1, attacker2);
            });
            if (!(attacker.asWrapper(attacker1).hasFullHealth() && attacker.asWrapper(stormdrain).hasFullHealth() && defender.asWrapper(defender2).hasFullHealth())) {
                return TestResult.failure("Storm Drain should redirect moves that can hit it");
            }
            if (defender.asWrapper(defender1).hasFullHealth()) {
                return TestResult.failure("Storm Drain should not redirect its own moves");
            }
            if (defender.asWrapper(defender3).hasFullHealth() || attacker.asWrapper(attacker2).hasFullHealth()) {
                return TestResult.failure("Storm Drain should not redirect moves that cannot reach it");
            }
            if (attacker.asWrapper(stormdrain).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 3) {
                return TestResult.failure("Being hit by a Water move should increase Sp.Atk. by 1 stage each.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldRedirectSingleTargetWaterAttacksIfValidTargetExtended(BattleTestHelper helper) {
        Pokemon stormdrain = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.WATER_PULSE).build();
        TestParticipant attacker = helper.createParticipant(3, stormdrain, attacker1, attacker2);
        Pokemon defender1 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon defender2 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon defender3 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.WATER_PULSE).build();
        TestParticipant defender = helper.createParticipant(3, defender1, defender2, defender3);
        return helper.setupTripleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(stormdrain, 1, defender1);
                attacker.attackTarget(attacker1, 1, defender2);
                attacker.attackTarget(attacker2, 1, defender3);
                defender.attackTarget(defender1, 1, stormdrain);
                defender.attackTarget(defender2, 1, attacker1);
                defender.attackTarget(defender3, 1, attacker2);
            });
            if (!(attacker.asWrapper(stormdrain).hasFullHealth() && attacker.asWrapper(attacker1).hasFullHealth() && attacker.asWrapper(attacker2).hasFullHealth() && defender.asWrapper(defender1).hasFullHealth() && defender.asWrapper(defender2).hasFullHealth() && defender.asWrapper(defender3).hasFullHealth())) {
                return TestResult.failure("Storm Drain should redirect moves that can hit it");
            }
            if (attacker.asWrapper(stormdrain).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 2) {
                return TestResult.failure("Being hit by a Water move should increase Sp.Atk. by 1 stage each.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldRedirectToTheFastestStormDrainUser(BattleTestHelper helper) {
        Pokemon fast = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon slow = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant stormdrain = helper.createParticipant(2, fast, slow);
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.AQUA_JET).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.AQUA_JET).build();
        TestParticipant attacker = helper.createParticipant(2, attacker1, attacker2);
        return helper.setupDoubleBattleBuilder(attacker, stormdrain).forceChance().start().thenApply(controller -> {
            stormdrain.asWrapper(fast).getBattleStats().modifyStat(6, BattleStatsType.SPEED);
            controller.takeFullTurn(() -> {
                attacker.attackTarget(attacker1, 1, fast);
                attacker.attackTarget(attacker2, 1, slow);
                stormdrain.attackTarget(fast, 1, attacker1);
                stormdrain.attackTarget(slow, 1, attacker2);
            });
            if (stormdrain.asWrapper(fast).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 2) {
                return TestResult.failure("Water attacks should redirect to the faster user.");
            }
            if (stormdrain.asWrapper(slow).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("Water attacks should redirect to the faster user.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCanRedirectOwnAttacksToSlowerStormDrain(BattleTestHelper helper) {
        Pokemon fast = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SCALD).build();
        Pokemon slow = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant stormdrain = helper.createParticipant(2, fast, slow);
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant attacker = helper.createParticipant(2, attacker1, attacker2);
        return helper.setupDoubleBattleBuilder(attacker, stormdrain).forceChance().start().thenApply(controller -> {
            stormdrain.asWrapper(fast).getBattleStats().modifyStat(6, BattleStatsType.SPEED);
            controller.takeFullTurn(() -> {
                attacker.attackTarget(attacker1, 1, fast);
                attacker.attackTarget(attacker2, 1, slow);
                stormdrain.attackTarget(fast, 1, attacker1);
                stormdrain.attackTarget(slow, 1, attacker2);
            });
            if (stormdrain.asWrapper(slow).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 1) {
                return TestResult.failure("Faster StormDrain's Water attacks should redirect to the slower user.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldRedirectSingleTargetWaterAttacksToLongestTimeIfSpeedTied(BattleTestHelper helper) {
        Pokemon stormdrain = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon stormdrain2 = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon stormdrain3 = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wall1 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wall2 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.WATER_PULSE).build();
        TestParticipant attacker = helper.createParticipant(3, wall1, wall2, stormdrain, stormdrain2, stormdrain3);
        Pokemon defender1 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.WATER_PULSE).build();
        Pokemon defender2 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.WATER_PULSE).build();
        Pokemon defender3 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.WATER_PULSE).build();
        TestParticipant defender = helper.createParticipant(3, defender1, defender2, defender3);
        return helper.setupTripleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(stormdrain, 1, defender3);
                attacker.switchPokemon(wall1, stormdrain2);
                attacker.switchPokemon(wall2, stormdrain3);
                defender.attackTarget(defender1, 1, wall1);
                defender.attackTarget(defender2, 1, wall2);
                defender.attackTarget(defender3, 1, stormdrain);
            });
            if (!(attacker.asWrapper(stormdrain).hasFullHealth() && attacker.asWrapper(wall1).hasFullHealth() && attacker.asWrapper(wall2).hasFullHealth() && attacker.asWrapper(stormdrain2).hasFullHealth() && attacker.asWrapper(stormdrain3).hasFullHealth())) {
                return TestResult.failure("Storm Drain should redirect moves that can hit it");
            }
            if (attacker.asWrapper(stormdrain).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 3 || attacker.asWrapper(stormdrain2).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0 || attacker.asWrapper(stormdrain3).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("Redirecting abilities should prioritize longest on the field if speed tied");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldNotRedirectIfFollowMeHasBeenUsed(BattleTestHelper helper) {
        Pokemon storm = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon follow = helper.createDefaultPokemon(PixelmonSpecies.SNORLAX).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.FOLLOW_ME).build();
        TestParticipant targets = helper.createParticipant(2, storm, follow);
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.AQUA_JET).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.AQUA_JET).build();
        TestParticipant attacker = helper.createParticipant(2, attacker1, attacker2);
        return helper.setupDoubleBattleBuilder(attacker, targets).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(attacker1, 1, storm);
                attacker.attackTarget(attacker2, 1, follow);
                targets.attackTarget(storm, 1, attacker1);
                targets.attackSelf(follow, 1);
            });
            if (targets.asWrapper(storm).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("StormDrain should not redirect attacks attracted by FollowMe");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldNotRedirectMultiTargetMoves(BattleTestHelper helper) {
        Pokemon storm = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wall = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant targets = helper.createParticipant(2, storm, wall);
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.SURF).build();
        TestParticipant attacker = helper.createParticipant(2, attacker1, attacker2);
        return helper.setupDoubleBattleBuilder(attacker, targets).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(attacker1, 1, storm);
                attacker.attackAutoTarget(attacker2, 1);
                targets.attackTarget(storm, 1, attacker1);
                targets.attackTarget(wall, 1, attacker2);
            });
            if (targets.asWrapper(storm).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 1) {
                return TestResult.failure("StormDrain should get boosted by multi-target water moves");
            }
            if (!targets.asWrapper(storm).hasFullHealth()) {
                return TestResult.failure("StormDrain should be immune to multi-target water moves");
            }
            if (attacker.asWrapper(attacker1).hasFullHealth() || targets.asWrapper(wall).hasFullHealth()) {
                return TestResult.failure("StormDrain should not redirect multi-target water moves");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldBeSuppressedByMoldBreaker(BattleTestHelper helper) {
        Pokemon storm = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wall = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant targets = helper.createParticipant(2, storm, wall);
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.SCALD).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.SCALD).build();
        TestParticipant attacker = helper.createParticipant(2, attacker1, attacker2);
        return helper.setupDoubleBattleBuilder(attacker, targets).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(attacker1, 1, storm);
                attacker.attackTarget(attacker2, 1, wall);
                targets.attackTarget(storm, 1, attacker1);
                targets.attackTarget(wall, 1, attacker2);
            });
            if (targets.asWrapper(wall).hasFullHealth()) {
                return TestResult.failure("StormDrain should not redirect MoldBreaker'd water moves");
            }
            if (targets.asWrapper(storm).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("StormDrain should not get boosted by MoldBreaker'd water moves");
            }
            if (targets.asWrapper(storm).hasFullHealth()) {
                return TestResult.failure("StormDrain should not be immune to MoldBreaker'd water moves");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldNotRedirectIfAttackerHasPropellerTail(BattleTestHelper helper) {
        Pokemon storm = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.STORM_DRAIN).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wall = helper.createDefaultPokemon(PixelmonSpecies.GASTRODON).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant targets = helper.createParticipant(2, storm, wall);
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.PROPELLER_TAIL).moves(AttackRegistry.SCALD).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.PROPELLER_TAIL).moves(AttackRegistry.SCALD).build();
        TestParticipant attacker = helper.createParticipant(2, attacker1, attacker2);
        return helper.setupDoubleBattleBuilder(attacker, targets).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(attacker1, 1, storm);
                attacker.attackTarget(attacker2, 1, wall);
                targets.attackTarget(storm, 1, attacker1);
                targets.attackTarget(wall, 1, attacker2);
            });
            if (targets.asWrapper(wall).hasFullHealth()) {
                return TestResult.failure("StormDrain should not redirect PropellerTail'd water moves");
            }
            if (targets.asWrapper(storm).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 1) {
                return TestResult.failure("StormDrain should get boosted by PropellerTail'd water moves that hit it");
            }
            if (!targets.asWrapper(storm).hasFullHealth()) {
                return TestResult.failure("StormDrain should be immune to PropellerTail'd water moves");
            }
            return TestResult.success();
        });
    }
}

