/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class StickyHoldTests {
    @BattleTest
    public static CompletableFuture<TestResult> testStickyHoldPreventsItemBeingStolen(BattleTestHelper helper) {
        Pokemon magician = helper.createDefaultPokemon(PixelmonSpecies.FENNEKIN).ability(AbilityRegistry.MAGICIAN).moves(AttackRegistry.GRASS_KNOT).build();
        Pokemon thief = helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).moves(AttackRegistry.THIEF, AttackRegistry.KNOCK_OFF, AttackRegistry.SWITCHEROO, AttackRegistry.BUG_BITE).ability(AbilityRegistry.SYNCHRONIZE).build();
        TestParticipant opponent = helper.createParticipant(thief, magician);
        TestParticipant stickyhold = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.STICKY_HOLD).moves(AttackRegistry.RECOVER, AttackRegistry.SLACK_OFF).heldItem(PixelmonItems.razz_berry).build());
        return helper.setupSingleBattleBuilder(stickyhold, opponent).forceChance().start().thenApply(controller -> {
            for (int i = 1; i <= 4; ++i) {
                stickyhold.attackSelf(1);
                opponent.attackOpponent(i);
                controller.takeFullTurn();
                if (!opponent.asWrapper().hasHeldItem() && stickyhold.asWrapper().hasHeldItem()) continue;
                return TestResult.failure("Shuckle lost its item on turn " + i);
            }
            stickyhold.attackSelf(1);
            opponent.switchPokemon(thief, magician);
            controller.takeFullTurn();
            stickyhold.attackSelf(2);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (opponent.asWrapper().hasHeldItem() || !stickyhold.asWrapper().hasHeldItem()) {
                return TestResult.failure("Shuckle lost its item to Magician");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testStickyHoldPreventsItemProvidingSwitcheroo(BattleTestHelper helper) {
        TestParticipant giver = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).heldItem(PixelmonItems.razz_berry).moves(AttackRegistry.SWITCHEROO).build());
        TestParticipant stickyhold = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.STICKY_HOLD).moves(AttackRegistry.RECOVER).build());
        return helper.setupSingleBattleBuilder(stickyhold, giver).forceChance().start().thenApply(controller -> {
            stickyhold.attackSelf(1);
            giver.attackOpponent(1);
            controller.takeFullTurn();
            if (!giver.asWrapper().hasHeldItem() || stickyhold.asWrapper().hasHeldItem()) {
                return TestResult.failure("Shuckle's missing item was switched away");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testStickyHoldIsSuppressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant thief = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).moves(AttackRegistry.KNOCK_OFF).ability(AbilityRegistry.MOLD_BREAKER).build());
        TestParticipant stickyhold = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.STICKY_HOLD).moves(AttackRegistry.RECOVER).heldItem(PixelmonItems.razz_berry).build());
        return helper.setupSingleBattleBuilder(stickyhold, thief).forceChance().start().thenApply(controller -> {
            stickyhold.attackSelf(1);
            thief.attackOpponent(1);
            controller.takeFullTurn();
            if (stickyhold.asWrapper().hasHeldItem()) {
                return TestResult.failure("Shuckle still has its item");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testStickyHoldIsSuppressedBySunSteel(BattleTestHelper helper) {
        TestParticipant thief = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).moves(AttackRegistry.SUNSTEEL_STRIKE).ability(AbilityRegistry.MAGICIAN).build());
        TestParticipant stickyhold = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.STICKY_HOLD).moves(AttackRegistry.ENDURE).heldItem(PixelmonItems.razz_berry).build());
        return helper.setupSingleBattleBuilder(stickyhold, thief).forceChance().start().thenApply(controller -> {
            stickyhold.attackSelf(1);
            thief.attackOpponent(1);
            controller.takeFullTurn();
            if (stickyhold.asWrapper().hasHeldItem()) {
                return TestResult.failure("Shuckle still has its item");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testStickyHoldDoesNotProtectAgainstAbilitiesWhenKnockedOut(BattleTestHelper helper) {
        TestParticipant thief = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).moves(AttackRegistry.BITE).ability(AbilityRegistry.MAGICIAN).build());
        Pokemon shedinja = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.STICKY_HOLD).moves(AttackRegistry.GROWL).heldItem(PixelmonItems.razz_berry).build();
        Pokemon buffer = helper.createMagikarp().build();
        TestParticipant stickyhold = helper.createParticipant(shedinja, buffer);
        return helper.setupSingleBattleBuilder(stickyhold, thief).forceChance().start().thenApply(controller -> {
            stickyhold.attackSelf(1);
            stickyhold.switchPokemon(shedinja, buffer);
            thief.attackOpponent(1);
            controller.takeFullTurn();
            if (stickyhold.asWrapper(shedinja).hasHeldItem()) {
                return TestResult.failure("Shedinja still has its item after fainting");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testStickyHoldDoesNotProtectAgainstMovesWhenKnockedOut(BattleTestHelper helper) {
        TestParticipant thief = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).moves(AttackRegistry.THIEF).ability(AbilityRegistry.TECHNICIAN).build());
        Pokemon shedinja = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.STICKY_HOLD).moves(AttackRegistry.GROWL).heldItem(PixelmonItems.razz_berry).build();
        Pokemon buffer = helper.createMagikarp().build();
        TestParticipant stickyhold = helper.createParticipant(shedinja, buffer);
        return helper.setupSingleBattleBuilder(stickyhold, thief).forceChance().start().thenApply(controller -> {
            stickyhold.attackSelf(1);
            stickyhold.switchPokemon(shedinja, buffer);
            thief.attackOpponent(1);
            controller.takeFullTurn();
            if (stickyhold.asWrapper(shedinja).hasHeldItem()) {
                return TestResult.failure("Shedinja still has its item after fainting");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testStickyHoldDoesNotBlockStickyBarb(BattleTestHelper helper) {
        TestParticipant thief = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).moves(AttackRegistry.TACKLE).ability(AbilityRegistry.SYNCHRONIZE).build());
        TestParticipant stickyhold = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.STICKY_HOLD).moves(AttackRegistry.ENDURE).heldItem(PixelmonItems.sticky_barb).build());
        return helper.setupSingleBattleBuilder(stickyhold, thief).forceChance().start().thenApply(controller -> {
            stickyhold.attackSelf(1);
            thief.attackOpponent(1);
            controller.takeFullTurn();
            if (stickyhold.asWrapper().hasHeldItem()) {
                return TestResult.failure("Shuckle still has its item");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testStickyHoldDoesNotBlockOwnMoves(BattleTestHelper helper) {
        TestParticipant thief = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).moves(AttackRegistry.TACKLE).ability(AbilityRegistry.SYNCHRONIZE).build());
        TestParticipant stickyhold = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.STICKY_HOLD).moves(AttackRegistry.SWITCHEROO).heldItem(PixelmonItems.razz_berry).build());
        return helper.setupSingleBattleBuilder(stickyhold, thief).forceChance().start().thenApply(controller -> {
            stickyhold.attackOpponent(1);
            thief.attackOpponent(1);
            controller.takeFullTurn();
            if (stickyhold.asWrapper().hasHeldItem() || !thief.asWrapper().hasHeldItem()) {
                return TestResult.failure("StickyHold blocked its own Switcheroo");
            }
            return TestResult.success();
        });
    }
}

