/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SteelySpiritTests {
    @BattleTest
    public static CompletableFuture<TestResult> testBoostsSteelAttacksForBothAllyAndSelf(BattleTestHelper helper) {
        Pokemon steely = helper.createDefaultPokemon(PixelmonSpecies.ARON).ability(AbilityRegistry.STEELY_SPIRIT).moves(AttackRegistry.IRON_HEAD).build();
        Pokemon sturdy = helper.createDefaultPokemon(PixelmonSpecies.ARON).ability(AbilityRegistry.STURDY).moves(AttackRegistry.IRON_HEAD).build();
        TestParticipant attacker = helper.createParticipant(2, steely, sturdy);
        Pokemon wynautOne = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynautTwo = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant defender = helper.createParticipant(2, wynautOne, wynautTwo);
        return helper.setupDoubleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(steely, 1, wynautOne);
                attacker.attackTarget(sturdy, 1, wynautTwo);
                defender.attackOpponent(wynautOne, 1);
                defender.attackOpponent(wynautTwo, 1);
            });
            int wynautOneDamage = defender.asWrapper(wynautOne).getHealthDeficit();
            if (172 > wynautOneDamage || wynautOneDamage > 204) {
                return TestResult.failure("SteelySpirit did not boost its own power, doing " + wynautOneDamage);
            }
            int wynautTwoDamage = defender.asWrapper(wynautTwo).getHealthDeficit();
            if (172 > wynautTwoDamage || wynautTwoDamage > 204) {
                return TestResult.failure("SteelySpirit did not boost its ally's power, doing " + wynautTwoDamage);
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSteelySpiritBoostsStack(BattleTestHelper helper) {
        Pokemon steely = helper.createDefaultPokemon(PixelmonSpecies.ARON).ability(AbilityRegistry.STEELY_SPIRIT).moves(AttackRegistry.IRON_HEAD).build();
        Pokemon sturdy = helper.createDefaultPokemon(PixelmonSpecies.ARON).ability(AbilityRegistry.STEELY_SPIRIT).moves(AttackRegistry.IRON_HEAD).build();
        TestParticipant attacker = helper.createParticipant(2, steely, sturdy);
        Pokemon wynautOne = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynautTwo = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant defender = helper.createParticipant(2, wynautOne, wynautTwo);
        return helper.setupDoubleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(steely, 1, wynautOne);
                attacker.attackTarget(sturdy, 1, wynautTwo);
                defender.attackOpponent(wynautOne, 1);
                defender.attackOpponent(wynautTwo, 1);
            });
            int wynautOneDamage = defender.asWrapper(wynautOne).getHealthDeficit();
            if (258 > wynautOneDamage || wynautOneDamage > 306) {
                return TestResult.failure("Paired SteelySpirits did not stack, doing " + wynautOneDamage);
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSteelySpiritOnlyBoostsAllies(BattleTestHelper helper) {
        Pokemon steely = helper.createDefaultPokemon(PixelmonSpecies.ARON).ability(AbilityRegistry.STEELY_SPIRIT).moves(AttackRegistry.IRON_HEAD).build();
        Pokemon sturdy = helper.createDefaultPokemon(PixelmonSpecies.ARON).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.IRON_HEAD).build();
        TestParticipant attacker = helper.createParticipant(2, steely, sturdy);
        Pokemon wynautOne = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynautTwo = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.STEELY_SPIRIT).moves(AttackRegistry.IRON_HEAD).build();
        TestParticipant defender = helper.createParticipant(2, wynautOne, wynautTwo);
        return helper.setupDoubleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(steely, 1, wynautOne);
                attacker.attackTarget(sturdy, 1, wynautTwo);
                defender.attackOpponent(wynautOne, 1);
                defender.attackTarget(wynautTwo, 1, sturdy);
            });
            int wynautOneDamage = defender.asWrapper(wynautOne).getHealthDeficit();
            if (172 > wynautOneDamage || wynautOneDamage > 204) {
                return TestResult.failure("SteelySpirit boosted the opponent, doing " + wynautOneDamage);
            }
            return TestResult.success();
        });
    }
}

