/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class StanceChangeTests {
    @BattleTest
    public static CompletableFuture<TestResult> testBladeFormeDoesNotChangeUsingSleepTalk(BattleTestHelper helper) {
        TestParticipant aegislash = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AEGISLASH).ability(AbilityRegistry.STANCE_CHANGE).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.SHADOW_CLAW).build());
        TestParticipant kyurem = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYUREM).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.SPORE).build());
        return helper.setupSingleBattleBuilder(aegislash, kyurem).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aegislash.attackOpponent(1);
                kyurem.attackOpponent(1);
            });
            if (aegislash.hasMessageContaining("stancechange.blade") || aegislash.asWrapper().getForm().isForm("blade")) {
                return TestResult.failure("Aegislash should not change to blade forme.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShieldFormeDoesNotChangeUsingSleepTalk(BattleTestHelper helper) {
        TestParticipant aegislash = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AEGISLASH).ability(AbilityRegistry.STANCE_CHANGE).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.KINGS_SHIELD).build());
        TestParticipant kyurem = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYUREM).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.SPORE).build());
        return helper.setupSingleBattleBuilder(aegislash, kyurem).forceChance().start().thenApply(controller -> {
            aegislash.asWrapper().setForm("blade");
            controller.takeFullTurn(() -> {
                aegislash.attackOpponent(1);
                kyurem.attackOpponent(1);
            });
            if (aegislash.hasMessageContaining("stancechange.shield") || aegislash.asWrapper().getForm().isForm("shield")) {
                return TestResult.failure("Aegislash should not change to shield forme.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testOnlyChangesRealAegislash(BattleTestHelper helper) {
        TestParticipant aegislash = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AEGISLASH).ability(AbilityRegistry.STANCE_CHANGE).moves(AttackRegistry.IRON_TAIL).build());
        TestParticipant ditto = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DITTO).ability(AbilityRegistry.IMPOSTER).moves(AttackRegistry.TRANSFORM).build());
        return helper.setupSingleBattleBuilder(aegislash, ditto).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aegislash.attackOpponent(1);
                ditto.attackOpponent(1);
            });
            if (ditto.asWrapper().getBattleStats().getStatWithMod(BattleStatsType.ATTACK) != 136) {
                return TestResult.failure("Ditto changed forme despite not being a real Aegislash.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testRevertsToShieldFormeOnSwitchingOut(BattleTestHelper helper) {
        Pokemon aegislash = helper.createDefaultPokemon(PixelmonSpecies.AEGISLASH).ability(AbilityRegistry.STANCE_CHANGE).moves(AttackRegistry.TACKLE).build();
        Pokemon buffer = helper.createMagikarp().build();
        TestParticipant team = helper.createParticipant(aegislash, buffer);
        TestParticipant kyurem = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYUREM).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(team, kyurem).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.attackOpponent(1);
                kyurem.attackOpponent(1);
            });
            if (!team.hasMessageContaining("stancechange.blade") || team.asWrapper().getForm().isForm("shield")) {
                return TestResult.failure("Aegislash failed to change to blade forme.");
            }
            controller.takeFullTurn(() -> {
                team.switchPokemon(aegislash, buffer);
                kyurem.attackOpponent(1);
            });
            if (!team.asWrapper(aegislash).getForm().isForm("shield")) {
                return TestResult.failure("Aegislash did not revert to shield forme.");
            }
            return TestResult.success();
        });
    }
}

