/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SoulHeartTests {
    @BattleTest
    public static CompletableFuture<TestResult> shouldActivateforEachFaint(BattleTestHelper helper) {
        Pokemon toxapex = helper.createDefaultPokemon(PixelmonSpecies.TOXAPEX).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon victini = helper.createDefaultPokemon(PixelmonSpecies.VICTINI).moves(AttackRegistry.FINAL_GAMBIT).build();
        TestParticipant teamOne = helper.createParticipant(2, toxapex, victini);
        Pokemon magearna = helper.createDefaultPokemon(PixelmonSpecies.MAGEARNA).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamTwo = helper.createParticipant(2, magearna, wynaut);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackSelf(toxapex, 1);
                teamOne.attackTarget(victini, 1, wynaut);
                teamTwo.attackSelf(magearna, 1);
                teamTwo.attackSelf(wynaut, 1);
            });
            if (teamTwo.asWrapper(magearna).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 2) {
                return TestResult.failure("Magearna did not gain 2 stages off 2 KOs");
            }
            if (teamTwo.numberOfMessageOccurrences("soulheart.activate") != 2) {
                return TestResult.failure("Soul-Heart did not activate twice.");
            }
            return TestResult.success();
        });
    }

    public static CompletableFuture<TestResult> shouldNotActivateIfAlliedSoulHeartDieToSameMove(BattleTestHelper helper) {
        Pokemon charizard = helper.createDefaultPokemon(PixelmonSpecies.CHARIZARD).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon victini = helper.createDefaultPokemon(PixelmonSpecies.VICTINI).moves(AttackRegistry.EARTHQUAKE).build();
        TestParticipant teamOne = helper.createParticipant(2, charizard, victini);
        Pokemon magearna = helper.createDefaultPokemon(PixelmonSpecies.MAGEARNA).level(1).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon magearna2 = helper.createDefaultPokemon(PixelmonSpecies.MAGEARNA).level(1).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon buffer = helper.createMagikarp().build();
        Pokemon buffer2 = helper.createMagikarp().build();
        TestParticipant teamTwo = helper.createParticipant(2, magearna, magearna2, buffer, buffer2);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackSelf(charizard, 1);
                teamOne.attackAutoTarget(victini, 1);
                teamTwo.attackSelf(magearna, 1);
                teamTwo.attackSelf(magearna2, 1);
                teamTwo.switchPokemon(magearna, buffer);
                teamTwo.switchPokemon(magearna2, buffer2);
            });
            if (teamTwo.numberOfMessageOccurrences("soulheart.activate") != 0) {
                return TestResult.failure("Soul-Heart should not activate if all pokemon die together.");
            }
            return TestResult.success();
        });
    }
}

