/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SlowStartTests {
    @BattleTest
    public static CompletableFuture<TestResult> switchingShouldNotDelayActivation(BattleTestHelper helper) {
        Pokemon diglett = helper.createDefaultPokemon(PixelmonSpecies.DIGLETT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon regigigas = helper.createDefaultPokemon(PixelmonSpecies.REGIGIGAS).ability(AbilityRegistry.SLOW_START).moves(AttackRegistry.SLAM).build();
        TestParticipant teamOne = helper.createParticipant(diglett, regigigas);
        Pokemon diglett2 = helper.createDefaultPokemon(PixelmonSpecies.DIGLETT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon blissey = helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SOFT_BOILED).build();
        TestParticipant teamTwo = helper.createParticipant(blissey, diglett2);
        return helper.setupSingleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.switchPokemon(diglett, regigigas);
                teamTwo.attackSelf(1);
            });
            for (int turnCount = 2; turnCount <= 5; ++turnCount) {
                controller.modifyStats(teamOne.asWrapper());
                if (teamOne.asWrapper().getBattleStats().getStatFromEnum(BattleStatsType.SPEED) != 118) {
                    return TestResult.failure("Regigigas's Speed is not halved on turn " + turnCount);
                }
                controller.takeFullTurn(() -> {
                    teamTwo.attackSelf(1);
                    teamOne.attackOpponent(1);
                });
                if (teamTwo.asWrapper().getHealthDeficit() != 324) {
                    return TestResult.failure("Regigigas's Attack is not halved on turn " + turnCount);
                }
                if (!teamOne.hasMessageContaining("slowstartend") || turnCount == 5) continue;
                return TestResult.failure("SlowStart announced ending on turn " + turnCount);
            }
            if (!teamOne.hasMessageContaining("slowstartend")) {
                return TestResult.failure("SlowStart has not announced ending");
            }
            controller.takeFullTurn(() -> {
                teamTwo.attackSelf(1);
                teamTwo.switchPokemon(blissey, diglett2);
                teamOne.attackOpponent(1);
            });
            if (!teamTwo.asWrapper(blissey).isFainted()) {
                return TestResult.failure("Regigigas's Attack is halved after ending");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> switchingShouldOnlyReduceSpecialAttackOnZmoves(BattleTestHelper helper) {
        TestParticipant regigigas = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGIGIGAS).ability(AbilityRegistry.SLOW_START).moves(AttackRegistry.TACKLE, AttackRegistry.ROUND).heldItem(PixelmonItems.normalium_z).build());
        TestParticipant blissey = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SOFT_BOILED).build());
        return helper.setupSingleBattleBuilder(regigigas, blissey).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                blissey.attackSelf(1);
                regigigas.attackOpponent(1);
            });
            if (blissey.asWrapper().getHealthDeficit() != 163) {
                return TestResult.failure("Regigigas's Attack is not halved on physical attacks.");
            }
            controller.takeFullTurn(() -> {
                blissey.attackSelf(1);
                regigigas.attackOpponent(2);
            });
            if (regigigas.asWrapper().attack.movePower != 60) {
                return TestResult.failure("Regigigas did not use a 60 power Round");
            }
            if (blissey.asWrapper().getHealthDeficit() != 51) {
                return TestResult.failure("Regigigas's Special Attack is halved on non-Z special attacks.");
            }
            controller.takeFullTurn(() -> {
                blissey.attackSelf(1);
                regigigas.attackOpponent(2);
                regigigas.useZMove();
            });
            if (regigigas.asWrapper().attack.movePower != 120) {
                return TestResult.failure("Regigigas did not use a 120 power Breakneck Blitz");
            }
            if (blissey.asWrapper().getHealthDeficit() != 51) {
                return TestResult.failure("Regigigas's Attack is not halved on special based Z-moves.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> switchingShouldNotActivateOnPhysicalPhotonGeyser(BattleTestHelper helper) {
        Pokemon necrozma = helper.createDefaultPokemon(PixelmonSpecies.NECROZMA).moves(AttackRegistry.PHOTON_GEYSER).build();
        Pokemon regigigas = helper.createDefaultPokemon(PixelmonSpecies.REGIGIGAS).ability(AbilityRegistry.SLOW_START).moves(AttackRegistry.ASSIST).build();
        TestParticipant teamOne = helper.createParticipant(regigigas, necrozma);
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(teamOne, wynaut).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackOpponent(1);
                wynaut.attackOpponent(1);
            });
            return TestResult.damageResult(wynaut.asWrapper().getHealthDeficit(), 96, 114);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> abilityBeingLostOrSuppressedResetsStats(BattleTestHelper helper) {
        TestParticipant regigigas = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGIGIGAS).ability(AbilityRegistry.SLOW_START).moves(AttackRegistry.TACKLE).build());
        Pokemon necrozma = helper.createDefaultPokemon(PixelmonSpecies.NECROZMA).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.WORRY_SEED).build();
        Pokemon weezing = helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.POISON_GAS).build();
        TestParticipant disable = helper.createParticipant(necrozma, weezing);
        return helper.setupSingleBattleBuilder(regigigas, disable).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                regigigas.attackOpponent(1);
                disable.switchPokemon(necrozma, weezing);
            });
            int damage = disable.asWrapper(weezing).getHealthDeficit();
            if (57 <= damage && damage <= 67) {
                return TestResult.damageResult(damage, 57, 67);
            }
            controller.takeFullTurn(() -> {
                regigigas.attackOpponent(1);
                disable.switchPokemon(weezing, necrozma);
            });
            damage = disable.asWrapper(necrozma).getHealthDeficit();
            return TestResult.damageResult(damage, 33, 40);
        });
    }
}

