/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SimpleTests {
    @BattleTest
    public static CompletableFuture<TestResult> simpleDoublesStatChangesForUser(BattleTestHelper helper) {
        Pokemon diglett = helper.createDefaultPokemon(PixelmonSpecies.DIGLETT).moves(AttackRegistry.CURSE).build();
        Pokemon simple = helper.createDefaultPokemon(PixelmonSpecies.BIBAREL).ability(AbilityRegistry.SIMPLE).moves(AttackRegistry.CURSE).build();
        TestParticipant teamOne = helper.createParticipant(2, diglett, simple);
        Pokemon diglett2 = helper.createDefaultPokemon(PixelmonSpecies.DIGLETT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon blissey = helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).moves(AttackRegistry.CURSE).build();
        TestParticipant teamTwo = helper.createParticipant(2, blissey, diglett2);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackSelf(diglett, 1);
                teamOne.attackSelf(simple, 1);
                teamTwo.attackSelf(blissey, 1);
                teamTwo.attackSelf(diglett2, 1);
            });
            int[] diglettStages = teamOne.asWrapper(diglett).getBattleStats().getStages();
            if (diglettStages[BattleStatsType.ATTACK.getStatIndex()] != 1 || diglettStages[BattleStatsType.DEFENSE.getStatIndex()] != 1 || diglettStages[BattleStatsType.SPEED.getStatIndex()] != -1) {
                return TestResult.failure("Simple Ally got incorrect boosts for Curse " + Arrays.toString(diglettStages));
            }
            int[] blisseyStages = teamTwo.asWrapper(blissey).getBattleStats().getStages();
            if (blisseyStages[BattleStatsType.ATTACK.getStatIndex()] != 1 || blisseyStages[BattleStatsType.DEFENSE.getStatIndex()] != 1 || blisseyStages[BattleStatsType.SPEED.getStatIndex()] != -1) {
                return TestResult.failure("Simple Opponent got incorrect boosts for Curse " + Arrays.toString(blisseyStages));
            }
            int[] simpleStages = teamOne.asWrapper(simple).getBattleStats().getStages();
            if (simpleStages[BattleStatsType.ATTACK.getStatIndex()] != 2 || simpleStages[BattleStatsType.DEFENSE.getStatIndex()] != 2 || simpleStages[BattleStatsType.SPEED.getStatIndex()] != -2) {
                return TestResult.failure("Simple got incorrect boosts for Curse " + Arrays.toString(simpleStages));
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> simpleDoublesChangesFromOpponents(BattleTestHelper helper) {
        TestParticipant simple = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BIBAREL).ability(AbilityRegistry.SIMPLE).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant blissey = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.GROWL).build());
        return helper.setupDoubleBattleBuilder(simple, blissey).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                simple.attackOpponent(1);
                blissey.attackOpponent(1);
            });
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Simple should be disabled by MoldBreaker");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> simpleShouldBeDisabledbyMoldbreaker(BattleTestHelper helper) {
        TestParticipant simple = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BIBAREL).ability(AbilityRegistry.SIMPLE).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant blissey = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.GROWL).build());
        return helper.setupDoubleBattleBuilder(simple, blissey).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                simple.attackOpponent(1);
                blissey.attackOpponent(1);
            });
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Simple should be disabled by MoldBreaker");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> simpleNotBoostZPowerEffects(BattleTestHelper helper) {
        TestParticipant simple = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BIBAREL).ability(AbilityRegistry.SIMPLE).moves(AttackRegistry.GROWTH).heldItem(PixelmonItems.normalium_z).build());
        TestParticipant sunny = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.NINETALES).ability(AbilityRegistry.DROUGHT).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupDoubleBattleBuilder(simple, sunny).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                simple.attackSelf(1);
                simple.useZMove();
                sunny.attackOpponent(1);
            });
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 4) {
                return TestResult.failure("Simple should boost effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 5) {
                return TestResult.failure("Simple should not boost Z-Power effects.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> simpleBoostsClangorousSoulBlaze(BattleTestHelper helper) {
        TestParticipant simple = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KOMMOO).ability(AbilityRegistry.SIMPLE).moves(AttackRegistry.CLANGING_SCALES).heldItem(PixelmonItems.kommonium_z).build());
        TestParticipant sunny = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.NINETALES).ability(AbilityRegistry.DROUGHT).moves(AttackRegistry.ENDURE).build());
        return helper.setupDoubleBattleBuilder(simple, sunny).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                simple.attackOpponent(1);
                simple.useZMove();
                sunny.attackSelf(1);
            });
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.DEFENSE) != 2) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 2) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_DEFENSE) != 2) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != 2) {
                return TestResult.failure("Simple should not boost secondary Z-effects.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> simpleBoostsExtremeEvoboost(BattleTestHelper helper) {
        TestParticipant simple = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.EEVEE).ability(AbilityRegistry.SIMPLE).moves(AttackRegistry.LAST_RESORT).heldItem(PixelmonItems.eevium_z).build());
        TestParticipant sunny = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.NINETALES).ability(AbilityRegistry.DROUGHT).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupDoubleBattleBuilder(simple, sunny).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                simple.attackSelf(1);
                simple.useZMove();
                sunny.attackSelf(1);
            });
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 4) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.DEFENSE) != 4) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 4) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_DEFENSE) != 4) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != 4) {
                return TestResult.failure("Simple should not boost secondary Z-effects.");
            }
            return TestResult.success();
        });
    }
}

