/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ShieldsDownTests {
    @BattleTest
    public static CompletableFuture<TestResult> shieldsDownShouldBlockPrimaryStatus(BattleTestHelper helper) {
        TestParticipant minior = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MINIOR).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant blissey = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.GLARE).build());
        return helper.setupSingleBattleBuilder(minior, blissey).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                minior.attackOpponent(1);
                blissey.attackOpponent(1);
            });
            if (minior.asWrapper().hasStatus(StatusType.Paralysis)) {
                return TestResult.failure("ShieldsDown should block Paralysis");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shieldsDownShouldNotBlockMinorStatus(BattleTestHelper helper) {
        TestParticipant minior = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MINIOR).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant blissey = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.LEECH_SEED).build());
        return helper.setupSingleBattleBuilder(minior, blissey).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                minior.attackOpponent(1);
                blissey.attackOpponent(1);
            });
            if (!minior.asWrapper().hasStatus(StatusType.Leech)) {
                return TestResult.failure("ShieldsDown should not block LeechSeed");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shieldsDownShouldNotBlockStatusIfShieldsDown(BattleTestHelper helper) {
        TestParticipant minior = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MINIOR).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.BELLY_DRUM).build());
        TestParticipant blissey = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.DRAGON_RAGE, AttackRegistry.SPORE).build());
        return helper.setupSingleBattleBuilder(minior, blissey).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                minior.attackOpponent(1);
                blissey.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                minior.attackOpponent(2);
                blissey.attackOpponent(2);
            });
            if (minior.asWrapper().hasStatus(StatusType.Sleep)) {
                return TestResult.failure("ShieldsDown should not change until the end of the turn.");
            }
            controller.takeFullTurn(() -> {
                minior.attackOpponent(2);
                blissey.attackOpponent(2);
            });
            if (!minior.asWrapper().getForm().is("core")) {
                return TestResult.failure("ShieldsDown should be in Core form when below half health.");
            }
            if (!minior.asWrapper().hasStatus(StatusType.Sleep)) {
                return TestResult.failure("ShieldsDown should not block Sleep when in Core form.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shieldsDownShouldNotProtectTransformedPokemon(BattleTestHelper helper) {
        TestParticipant minior = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MINIOR).moves(AttackRegistry.SPORE).build());
        TestParticipant ditto = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DITTO).ability(AbilityRegistry.IMPOSTER).heldItem(PixelmonItems.choice_scarf).moves(AttackRegistry.SPORE).build());
        return helper.setupSingleBattleBuilder(minior, ditto).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                minior.attackOpponent(1);
                ditto.attackOpponent(1);
            });
            if (minior.asWrapper().hasStatus(StatusType.Sleep)) {
                return TestResult.failure("ShieldsDown should not change until the end of the turn.");
            }
            if (!ditto.asWrapper().hasStatus(StatusType.Sleep)) {
                return TestResult.failure("ShieldsDown should not protect anything but actual Minior.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shieldsDownShouldStartInCoreFormIfBelow50Percent(BattleTestHelper helper) {
        TestParticipant minior = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MINIOR).moves(AttackRegistry.SLEEP_TALK).healthPercent(40.0f).heldItem(PixelmonItems.sitrus_berry).build());
        TestParticipant blissey = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.SPORE).build());
        return helper.setupSingleBattleBuilder(minior, blissey).forceChance().start().thenApply(controller -> {
            if (!minior.asWrapper().getForm().isForm("core")) {
                return TestResult.failure("ShieldsDown should start in Core form if below 50 percent at start");
            }
            controller.takeFullTurn(() -> {
                minior.attackOpponent(1);
                blissey.attackOpponent(1);
            });
            if (!minior.asWrapper().getForm().isForm("meteor")) {
                return TestResult.failure("ShieldsDown should return to Meteor form at end of turn if healed");
            }
            if (!minior.asWrapper().hasStatus(StatusType.Sleep)) {
                return TestResult.failure("ShieldsDown should not remove Sleep gained in Core form");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shieldsDownShouldBlockRest(BattleTestHelper helper) {
        TestParticipant minior = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MINIOR).moves(AttackRegistry.REST).healthPercent(70.0f).build());
        TestParticipant blissey = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(minior, blissey).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                minior.attackSelf(1);
                blissey.attackOpponent(1);
            });
            if (minior.asWrapper().hasStatus(StatusType.Sleep) || minior.asWrapper().hasFullHealth()) {
                return TestResult.failure("ShieldsDown should block Rest gained in Meteor form");
            }
            if (!minior.hasMessageContaining("effectfailed")) {
                return TestResult.failure("ShieldsDown should cause Rest to fail.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shieldsDownShouldNotBeIgnored(BattleTestHelper helper) {
        TestParticipant minior = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MINIOR).moves(AttackRegistry.ENDURE).build());
        TestParticipant blissey = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.POISON_TOUCH).moves(AttackRegistry.SUNSTEEL_STRIKE).build());
        return helper.setupSingleBattleBuilder(minior, blissey).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                minior.attackSelf(1);
                blissey.attackOpponent(1);
            });
            if (minior.asWrapper().hasStatus(StatusType.Poison) || minior.asWrapper().hasFullHealth()) {
                return TestResult.failure("ShieldsDown should block PoisonTouch");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shieldsDownShouldTakeEntryHazardsBeforeActivating(BattleTestHelper helper) {
        Pokemon magikarp = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).moves(AttackRegistry.GRAVITY).build();
        Pokemon minior = helper.createDefaultPokemon(PixelmonSpecies.MINIOR).moves(AttackRegistry.REST).form("core").build();
        TestParticipant team = helper.createParticipant(magikarp, minior);
        TestParticipant blissey = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.TOXIC_SPIKES).build());
        return helper.setupSingleBattleBuilder(team, blissey).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.attackAutoTarget(1);
                blissey.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                team.switchPokemon(magikarp, minior);
                blissey.attackOpponent(1);
            });
            if (!team.asWrapper(minior).hasStatus(StatusType.Poison)) {
                return TestResult.failure("Entry hazards should poison minior on switch-in");
            }
            if (!team.asWrapper(minior).getForm().isForm("meteor")) {
                return TestResult.failure("ShieldsDown should activate after entry hazards");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shieldsDownProtectsAgainstToxicSpikesOnSecondSwitch(BattleTestHelper helper) {
        Pokemon magikarp = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).moves(AttackRegistry.SPLASH).build();
        Pokemon minior = helper.createDefaultPokemon(PixelmonSpecies.MINIOR).moves(AttackRegistry.REST).form("core").heldItem(PixelmonItems.iron_ball).build();
        TestParticipant team = helper.createParticipant(minior, magikarp);
        TestParticipant blissey = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.TOXIC_SPIKES).build());
        return helper.setupSingleBattleBuilder(team, blissey).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.switchPokemon(minior, magikarp);
                blissey.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                team.switchPokemon(magikarp, minior);
                blissey.attackOpponent(1);
            });
            if (team.asWrapper(minior).hasStatus(StatusType.Poison)) {
                return TestResult.failure("Minior should already be in Meteor form due to previous turn");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shieldsDownShouldActivateOnSwitchingIn(BattleTestHelper helper) {
        Pokemon magikarp = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).moves(AttackRegistry.GRAVITY).build();
        Pokemon minior = helper.createDefaultPokemon(PixelmonSpecies.MINIOR).moves(AttackRegistry.REST).form("core").build();
        TestParticipant team = helper.createParticipant(magikarp, minior);
        TestParticipant blissey = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.SPORE).build());
        return helper.setupSingleBattleBuilder(team, blissey).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.switchPokemon(magikarp, minior);
                blissey.attackOpponent(1);
            });
            if (!team.asWrapper(minior).getForm().isForm("meteor")) {
                return TestResult.failure("ShieldsDown should activate on switching in.");
            }
            if (team.asWrapper(minior).hasStatus(StatusType.Sleep)) {
                return TestResult.failure("ShieldsDown should protect Minior before others can move.");
            }
            return TestResult.success();
        });
    }
}

