/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ShieldDustTests {
    @BattleTest
    public static CompletableFuture<TestResult> shouldBlockSecondaryEffectsAgainstTheAbilityUser(BattleTestHelper helper) {
        Pokemon latios = helper.createDefaultPokemon(PixelmonSpecies.LATIOS).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.SNARL).build();
        Pokemon latias = helper.createDefaultPokemon(PixelmonSpecies.LATIAS).ability(AbilityRegistry.LEVITATE).moves(AttackRegistry.ROOST).build();
        TestParticipant teamOne = helper.createParticipant(2, latias, latios);
        Pokemon xerneas = helper.createDefaultPokemon(PixelmonSpecies.XERNEAS).ability(AbilityRegistry.SHIELD_DUST).moves(AttackRegistry.ROOST).build();
        Pokemon yveltal = helper.createDefaultPokemon(PixelmonSpecies.YVELTAL).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ROOST).build();
        TestParticipant teamTwo = helper.createParticipant(2, xerneas, yveltal);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackSelf(latias, 1);
                teamOne.attackAutoTarget(latios, 1);
                teamTwo.attackSelf(xerneas, 1);
                teamTwo.attackSelf(yveltal, 1);
            });
            if (teamTwo.asWrapper(yveltal).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != -1) {
                return TestResult.failure("Snarl did not reduce Yveltal's Special Attack");
            }
            if (teamTwo.asWrapper(xerneas).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("ShieldDust did not prevent the Special Attack drop");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldNotBlockSecondaryEffectsOnTheMoveUser(BattleTestHelper helper) {
        TestParticipant ledian = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LEDIAN).ability(AbilityRegistry.IRON_FIST).moves(AttackRegistry.POWER_UP_PUNCH).build());
        TestParticipant dustox = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DUSTOX).ability(AbilityRegistry.SHIELD_DUST).moves(AttackRegistry.ROOST).build());
        return helper.setupDoubleBattleBuilder(ledian, dustox).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                ledian.attackOpponent(1);
                dustox.attackSelf(1);
            });
            if (ledian.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("ShieldDust should not prevent PowerUpPunch's attack boost");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldBlockSecondaryEffectsFromItems(BattleTestHelper helper) {
        TestParticipant talonflame = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TALONFLAME).ability(AbilityRegistry.FLAME_BODY).moves(AttackRegistry.FLAME_CHARGE).heldItem(PixelmonItems.kings_rock).build());
        TestParticipant clefable = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.SHIELD_DUST).moves(AttackRegistry.COTTON_GUARD).build());
        return helper.setupDoubleBattleBuilder(talonflame, clefable).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                talonflame.attackOpponent(1);
                clefable.attackSelf(1);
            });
            if (talonflame.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != 1) {
                return TestResult.failure("ShieldDust should not prevent FlameCharge's speed boost");
            }
            if (clefable.asWrapper().getBattleStats().getStage(BattleStatsType.DEFENSE) != 3) {
                return TestResult.failure("ShieldDust should prevent Clefable flinching");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldBlockSecondaryEffectsFromFling(BattleTestHelper helper) {
        TestParticipant ledian = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LEDIAN).ability(AbilityRegistry.IRON_FIST).moves(AttackRegistry.FLING).heldItem(PixelmonItems.petaya_berry).build());
        TestParticipant clefable = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.SHIELD_DUST).moves(AttackRegistry.ROOST).build());
        return helper.setupDoubleBattleBuilder(ledian, clefable).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                ledian.attackOpponent(1);
                clefable.attackSelf(1);
            });
            if (ledian.asWrapper().hasHeldItem()) {
                return TestResult.failure("ShieldDust should not prevent the item being flung.");
            }
            if (ledian.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("Ledian should not get the boost from the Flung berry.");
            }
            if (clefable.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("ShieldDust should prevent Fling activating the Petaya Berry.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldNotBlockSecondaryEffectsByTheAbilityUser(BattleTestHelper helper) {
        Pokemon latios = helper.createDefaultPokemon(PixelmonSpecies.LATIOS).ability(AbilityRegistry.SHIELD_DUST).moves(AttackRegistry.STRUGGLE_BUG, AttackRegistry.POWER_UP_PUNCH).build();
        TestParticipant teamOne = helper.createParticipant(latios);
        Pokemon clefable = helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.SOFT_BOILED).build();
        TestParticipant teamTwo = helper.createParticipant(clefable);
        return helper.setupSingleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackAutoTarget(latios, 1);
                teamTwo.attackSelf(clefable, 1);
            });
            controller.takeFullTurn(() -> {
                teamOne.attackAutoTarget(latios, 2);
                teamTwo.attackSelf(clefable, 1);
            });
            if (teamTwo.asWrapper(clefable).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != -1) {
                return TestResult.failure("ShieldDust should not prevent the user's secondary effects against other pokemon");
            }
            if (teamOne.asWrapper(latios).getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("ShieldDust should not prevent the user's secondary effects on itself");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldBeSuppressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant talonflame = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TALONFLAME).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.FLAME_CHARGE).heldItem(PixelmonItems.kings_rock).build());
        TestParticipant clefable = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.SHIELD_DUST).moves(AttackRegistry.COTTON_GUARD).build());
        return helper.setupDoubleBattleBuilder(talonflame, clefable).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                talonflame.attackOpponent(1);
                clefable.attackSelf(1);
            });
            if (talonflame.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != 1) {
                return TestResult.failure("ShieldDust should not prevent FlameCharge's speed boost");
            }
            if (clefable.asWrapper().getBattleStats().getStage(BattleStatsType.DEFENSE) != 0) {
                return TestResult.failure("ShieldDust should be blocked by Moldbreaker, letting Clefable flinch");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSparklingAriaSingleTargetDoesNotCureBurn(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.WILL_O_WISP, AttackRegistry.SPARKLING_ARIA).build());
        TestParticipant dustox = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DUSTOX).ability(AbilityRegistry.SHIELD_DUST).moves(AttackRegistry.ROOST).build());
        return helper.setupDoubleBattleBuilder(wynaut, dustox).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                dustox.attackSelf(1);
            });
            if (!dustox.asWrapper().hasStatus(StatusType.Burn)) {
                return TestResult.failure("ShieldDust should not block status moves");
            }
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(2);
                dustox.attackSelf(1);
            });
            if (!dustox.asWrapper().hasStatus(StatusType.Burn)) {
                return TestResult.failure("ShieldDust should block Sparkling Aria curing burn vs a single target");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSparklingAriaMultiTargetCuresBurn(BattleTestHelper helper) {
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.WILL_O_WISP, AttackRegistry.SPARKLING_ARIA).build();
        Pokemon diglett = helper.createDefaultPokemon(PixelmonSpecies.DIGLETT).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant burners = helper.createParticipant(2, wynaut, diglett);
        Pokemon dustox = helper.createDefaultPokemon(PixelmonSpecies.DUSTOX).ability(AbilityRegistry.SHIELD_DUST).moves(AttackRegistry.ROOST).build();
        Pokemon magikarp = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant targets = helper.createParticipant(2, dustox, magikarp);
        return helper.setupDoubleBattleBuilder(burners, targets).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                burners.attackTarget(wynaut, 1, dustox);
                burners.attackOpponent(diglett, 1);
                targets.attackSelf(dustox, 1);
                targets.attackOpponent(magikarp, 1);
            });
            if (!targets.asWrapper(dustox).hasStatus(StatusType.Burn)) {
                return TestResult.failure("ShieldDust should not block status moves");
            }
            controller.takeFullTurn(() -> {
                burners.attackAutoTarget(wynaut, 2);
                burners.attackOpponent(diglett, 1);
                targets.attackSelf(dustox, 1);
                targets.attackOpponent(magikarp, 1);
            });
            if (targets.asWrapper(dustox).hasStatus(StatusType.Burn)) {
                return TestResult.failure("ShieldDust should not block Sparkling Aria curing burn vs multiple targets");
            }
            return TestResult.success();
        });
    }
}

