/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ShellArmorTests {
    @BattleTest
    public static CompletableFuture<TestResult> shellArmorShouldPreventCriticalHits(BattleTestHelper helper) {
        TestParticipant slowbro = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SLOWBRO).moves(AttackRegistry.BABY_DOLL_EYES).ability(AbilityRegistry.SHELL_ARMOUR).build());
        TestParticipant cryogonal = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CRYOGONAL).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.FROST_BREATH).build());
        return helper.setupSingleBattleBuilder(slowbro, cryogonal).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                slowbro.attackOpponent(1);
                cryogonal.attackOpponent(1);
            });
            if (slowbro.asWrapper().getHealthDeficit() != 45) {
                return TestResult.failure("ShellArmor should prevent critical damage.");
            }
            if (slowbro.hasMessageContaining("criticalhit")) {
                return TestResult.failure("ShellArmor should prevent crits being announced.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shellArmorShouldBeSuppressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant slowbro = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SLOWBRO).moves(AttackRegistry.BABY_DOLL_EYES).ability(AbilityRegistry.SHELL_ARMOUR).build());
        TestParticipant cryogonal = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CRYOGONAL).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.FROST_BREATH).heldItem(PixelmonItems.zoom_lens).build());
        return helper.setupSingleBattleBuilder(slowbro, cryogonal).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                slowbro.attackOpponent(1);
                cryogonal.attackOpponent(1);
            });
            if (slowbro.asWrapper().getHealthDeficit() != 67) {
                return TestResult.failure("ShellArmor should prevent critical damage.");
            }
            if (!slowbro.hasMessageContaining("criticalhit")) {
                return TestResult.failure("ShellArmor should prevent crits being announced.");
            }
            return TestResult.success();
        });
    }
}

