/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.Freeze;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SheerForceTests {
    @BattleTest
    public static CompletableFuture<TestResult> shouldNotRemoveLifeOrbDamageIfNoSecondaryEffect(BattleTestHelper helper) {
        TestParticipant tauros = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TAUROS).moves(AttackRegistry.EARTHQUAKE).ability(AbilityRegistry.SHEER_FORCE).heldItem(PixelmonItems.life_orb).build());
        TestParticipant lapras = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LAPRAS).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.REST).heldItem(PixelmonItems.lagging_tail).build());
        return helper.setupSingleBattleBuilder(tauros, lapras).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                tauros.attackOpponent(1);
                lapras.attackSelf(1);
            });
            if (tauros.asWrapper().getHealthDeficit() != tauros.asWrapper().getMaxHealth() / 10) {
                return TestResult.failure("SheerForce should not block LifeOrb recoil on its own.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldEliminateSecondaryEffectsFromMoves(BattleTestHelper helper) {
        TestParticipant tauros = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TAUROS).moves(AttackRegistry.ZAP_CANNON).ability(AbilityRegistry.SHEER_FORCE).build());
        TestParticipant machamp = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MACHAMP).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.BULK_UP).build());
        return helper.setupSingleBattleBuilder(tauros, machamp).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                tauros.attackOpponent(1);
                machamp.attackSelf(1);
            });
            if (machamp.asWrapper().hasStatus(StatusType.Paralysis)) {
                return TestResult.failure("SheerForce should prevent the secondary paralyze effect.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldNotBlockLifeOrbIfAbilityRemovedMidAttack(BattleTestHelper helper) {
        TestParticipant tauros = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TAUROS).moves(AttackRegistry.LOCK_ON, AttackRegistry.DYNAMIC_PUNCH).ability(AbilityRegistry.SHEER_FORCE).heldItem(PixelmonItems.life_orb).build());
        TestParticipant scyther = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SCYTHER).ability(AbilityRegistry.MUMMY).moves(AttackRegistry.IRON_DEFENSE).build());
        return helper.setupSingleBattleBuilder(tauros, scyther).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                tauros.attackOpponent(1);
                scyther.attackSelf(1);
            });
            controller.takeFullTurn(() -> {
                tauros.attackOpponent(2);
                scyther.attackSelf(1);
            });
            if (scyther.asWrapper().hasStatus(StatusType.Confusion)) {
                return TestResult.failure("SheerForce should prevent Confusion before being lost.");
            }
            if (tauros.asWrapper().getHealthDeficit() != tauros.asWrapper().getMaxHealth() / 10) {
                return TestResult.failure("SheerForce should not block LifeOrb recoil if lost during attack.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldRemoveLifeOrbDamageIfMoveHasSecondaryEffect(BattleTestHelper helper) {
        TestParticipant tauros = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TAUROS).moves(AttackRegistry.BODY_SLAM).ability(AbilityRegistry.SHEER_FORCE).heldItem(PixelmonItems.life_orb).build());
        TestParticipant lapras = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LAPRAS).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.REST).heldItem(PixelmonItems.lagging_tail).build());
        return helper.setupSingleBattleBuilder(tauros, lapras).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                tauros.attackOpponent(1);
                lapras.attackSelf(1);
            });
            if (!tauros.asWrapper().hasFullHealth()) {
                return TestResult.failure("SheerForce should block LifeOrb recoil if attack has secondary effects.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldNotThawAFrozenTargetWithBoostedThawsTargetMove(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.SCALD).ability(AbilityRegistry.SHEER_FORCE).build());
        TestParticipant shuckle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.METEOR_ASSAULT).build());
        return helper.setupSingleBattleBuilder(wynaut, shuckle).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                shuckle.attackOpponent(1);
            });
            Freeze.freeze(shuckle.asWrapper(), shuckle.asWrapper());
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(2);
                shuckle.attackOpponent(1);
            });
            if (!shuckle.asWrapper().hasStatus(StatusType.Freeze)) {
                return TestResult.failure("SheerForce should block thawsTarget if attack has secondary effects.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldThawAFrozenTargetWithBoostedFireTypeMove(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.FLAMETHROWER).ability(AbilityRegistry.SHEER_FORCE).build());
        TestParticipant shuckle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.METEOR_ASSAULT).build());
        return helper.setupSingleBattleBuilder(wynaut, shuckle).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                shuckle.attackOpponent(1);
            });
            Freeze.freeze(shuckle.asWrapper(), shuckle.asWrapper());
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(2);
                shuckle.attackOpponent(1);
            });
            if (shuckle.asWrapper().hasStatus(StatusType.Freeze)) {
                return TestResult.failure("SheerForce should not block boosted Fire-type moves thawing the target.");
            }
            return TestResult.success();
        });
    }
}

