/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ShadowTagTests {
    @BattleTest
    public static CompletableFuture<TestResult> testPreventsMostPokemonSwitchingNormally(BattleTestHelper helper) {
        Pokemon tornadus = helper.createDefaultPokemon(PixelmonSpecies.TORNADUS).ability(AbilityRegistry.DEFIANT).moves(AttackRegistry.TAILWIND).build();
        Pokemon heatran = helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.ROAR).build();
        TestParticipant team = helper.createParticipant(tornadus, heatran);
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WOBBUFFET).moves(AttackRegistry.COUNTER).ability(AbilityRegistry.SHADOW_TAG).build());
        return helper.setupSingleBattleBuilder(team, opponent).forceChance().start().thenApply(controller -> {
            team.switchPokemon(tornadus, heatran);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (team.asWrapper().getSpecies().is(PixelmonSpecies.HEATRAN)) {
                return TestResult.failure("Tornadus managed to switch out despite ShadowTag");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testNotPreventsSwitchingUsingMoves(BattleTestHelper helper) {
        Pokemon tornadus = helper.createDefaultPokemon(PixelmonSpecies.TORNADUS).ability(AbilityRegistry.DEFIANT).moves(AttackRegistry.U_TURN).build();
        Pokemon heatran = helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.ROAR).heldItem(PixelmonItems.focus_sash).build();
        TestParticipant team = helper.createParticipant(tornadus, heatran);
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WOBBUFFET).moves(AttackRegistry.COUNTER).ability(AbilityRegistry.SHADOW_TAG).build());
        return helper.setupSingleBattleBuilder(team, opponent).forceChance().start().thenApply(controller -> {
            team.attackOpponent(1);
            team.switchPokemon(tornadus, heatran);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (!team.asWrapper().getSpecies().is(PixelmonSpecies.HEATRAN)) {
                return TestResult.failure("Tornadus was trapped despite using a pivot move");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotPreventShadowTagPokemonSwitchingNormally(BattleTestHelper helper) {
        Pokemon gothitelle = helper.createDefaultPokemon(PixelmonSpecies.GOTHITELLE).ability(AbilityRegistry.SHADOW_TAG).moves(AttackRegistry.PSYCHIC).build();
        Pokemon heatran = helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.ROAR).build();
        TestParticipant team = helper.createParticipant(gothitelle, heatran);
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WOBBUFFET).moves(AttackRegistry.COUNTER).ability(AbilityRegistry.SHADOW_TAG).build());
        return helper.setupSingleBattleBuilder(team, opponent).forceChance().start().thenApply(controller -> {
            team.switchPokemon(gothitelle, heatran);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (!team.asWrapper().getSpecies().is(PixelmonSpecies.HEATRAN)) {
                return TestResult.failure("Gothitelle was trapped despite having ShadowTag ability");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotPreventGhostPokemonSwitchingNormally(BattleTestHelper helper) {
        Pokemon gengar = helper.createDefaultPokemon(PixelmonSpecies.GENGAR).ability(AbilityRegistry.CURSED_BODY).moves(AttackRegistry.SHADOW_BALL).build();
        Pokemon heatran = helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.ROAR).build();
        TestParticipant team = helper.createParticipant(gengar, heatran);
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WOBBUFFET).moves(AttackRegistry.COUNTER).ability(AbilityRegistry.SHADOW_TAG).build());
        return helper.setupSingleBattleBuilder(team, opponent).forceChance().start().thenApply(controller -> {
            team.switchPokemon(gengar, heatran);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (!team.asWrapper().getSpecies().is(PixelmonSpecies.HEATRAN)) {
                return TestResult.failure("Gengar was trapped despite being immune to trapping");
            }
            return TestResult.success();
        });
    }
}

