/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.WaterPledge;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SereneGraceTests {
    @BattleTest
    public static CompletableFuture<TestResult> testSereneGraceDoesNotStackWithRainbowOnFlinches(BattleTestHelper helper) {
        TestParticipant zacian = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ZACIAN).ability(AbilityRegistry.SERENE_GRACE).moves(AttackRegistry.BITE).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(zacian, opponent).start().thenApply(controller -> {
            zacian.asWrapper().addTeamStatus(new WaterPledge(), zacian.asWrapper());
            zacian.attackOpponent(1);
            opponent.attackOpponent(1);
            controller.advanceToMoves();
            controller.doTurnLogic();
            if (!zacian.asWrapper().hasStatus(StatusType.WaterPledge)) {
                return TestResult.failure("Water Pledge's Rainbow did not appear");
            }
            if (zacian.asWrapper().attack.getEffects().get(0).getChance() != 30.0f) {
                return TestResult.failure("Base Bite flinch chance should be reset to 30 percent");
            }
            EffectBase biteFlinch = zacian.asWrapper().attack.getEffects().get(0);
            Attack.modifyMoveEffects(zacian.asWrapper(), opponent.asWrapper(), List.of(biteFlinch));
            if (biteFlinch.getChance() != 60.0f) {
                biteFlinch.checkChance((BattleController)controller);
                return TestResult.failure("Flinch chance should be doubled only once.");
            }
            biteFlinch.checkChance((BattleController)controller);
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSereneGraceDoesNotOverflowWithRainbowBoost(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.SERENE_GRACE).moves(AttackRegistry.NUZZLE).build());
        TestParticipant opponent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(wynaut, opponent).start().thenApply(controller -> {
            wynaut.asWrapper().addTeamStatus(new WaterPledge(), wynaut.asWrapper());
            wynaut.attackOpponent(1);
            opponent.attackOpponent(1);
            controller.takeFullTurn();
            if (!wynaut.asWrapper().hasStatus(StatusType.WaterPledge)) {
                return TestResult.failure("Water Pledge's Rainbow did not appear");
            }
            if (!opponent.asWrapper().hasStatus(StatusType.Paralysis)) {
                return TestResult.failure("Boosted Nuzzle failed to paralyze the opponent");
            }
            if (wynaut.asWrapper().attack.getEffects().get(0).getChance() != 100.0f) {
                return TestResult.failure("Base Nuzzle chance should reset after using the move.");
            }
            ArrayList<EffectBase> effects = new ArrayList<EffectBase>(wynaut.asWrapper().attack.getEffects());
            Attack.modifyMoveEffects(wynaut.asWrapper(), opponent.asWrapper(), effects);
            EffectBase nuzzleParalysis = (EffectBase)effects.get(0);
            if (nuzzleParalysis.getChance() != 400.0f) {
                nuzzleParalysis.checkChance((BattleController)controller);
                return TestResult.failure("Nuzzle paralysis chance should be doubled twice during the move.");
            }
            if (!nuzzleParalysis.checkChance((BattleController)controller)) {
                return TestResult.failure("Boosted percent caused 400% chance Nuzzle to fail.");
            }
            return TestResult.success();
        });
    }
}

