/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ScreenCleanerTests {
    @BattleTest
    public static CompletableFuture<TestResult> testRemovesScreensOnBothSidesOnSwitchIn(BattleTestHelper helper) {
        Pokemon mew = helper.createDefaultPokemon(PixelmonSpecies.MEW).ability(AbilityRegistry.SYNCHRONIZE).moves(AttackRegistry.REFLECT, AttackRegistry.LIGHT_SCREEN).build();
        Pokemon mime = helper.createDefaultPokemon(PixelmonSpecies.MRMIME).form("galarian").ability(AbilityRegistry.SCREEN_CLEANER).moves(AttackRegistry.PSYCHIC).build();
        TestParticipant team = helper.createParticipant(mew, mime);
        TestParticipant mew2 = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEW).moves(AttackRegistry.REFLECT, AttackRegistry.LIGHT_SCREEN, AttackRegistry.REFLECT_TYPE).ability(AbilityRegistry.SYNCHRONIZE).build());
        return helper.setupSingleBattleBuilder(team, mew2).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.attackSelf(1);
                mew2.attackSelf(1);
            });
            controller.takeFullTurn(() -> {
                team.attackSelf(2);
                mew2.attackSelf(2);
            });
            controller.takeFullTurn(() -> {
                team.switchPokemon(mew, mime);
                mew2.attackOpponent(3);
            });
            if (team.asWrapper().hasStatus(StatusType.Reflect) || team.asWrapper().hasStatus(StatusType.LightScreen)) {
                return TestResult.failure("Screens on the ScreenCleaner's side were not removed");
            }
            if (mew2.asWrapper().hasStatus(StatusType.Reflect) || mew2.asWrapper().hasStatus(StatusType.LightScreen)) {
                return TestResult.failure("Screens on the opponent's side were not removed");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testRemovesAuroraVeil(BattleTestHelper helper) {
        Pokemon ninetales = helper.createDefaultPokemon(PixelmonSpecies.NINETALES).form("alolan").ability(AbilityRegistry.SNOW_WARNING).moves(AttackRegistry.AURORA_VEIL).build();
        Pokemon mime = helper.createDefaultPokemon(PixelmonSpecies.MRMIME).form("galarian").ability(AbilityRegistry.SCREEN_CLEANER).moves(AttackRegistry.PSYCHIC).build();
        TestParticipant team = helper.createParticipant(ninetales, mime);
        TestParticipant lapras = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LAPRAS).moves(AttackRegistry.ICE_BEAM, AttackRegistry.GROWL).gigantamaxFactor().build());
        return helper.setupSingleBattleBuilder(team, lapras).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.attackSelf(1);
                lapras.attackOpponent(1);
                lapras.evolve();
            });
            controller.takeFullTurn(() -> {
                team.switchPokemon(ninetales, mime);
                lapras.attackOpponent(2);
            });
            if (team.asWrapper().hasStatus(StatusType.AuroraVeil)) {
                return TestResult.failure("AuroraVeil on the ScreenCleaner's side was not removed");
            }
            if (lapras.asWrapper().hasStatus(StatusType.AuroraVeil)) {
                return TestResult.failure("AuroraVeil on the opponent's side was not removed");
            }
            return TestResult.success();
        });
    }
}

