/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SapSipperTests {
    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotRedirectGrassMoves(BattleTestHelper helper) {
        Pokemon mew = helper.createDefaultPokemon(PixelmonSpecies.MEW).moves(AttackRegistry.GROWL).build();
        Pokemon azumarill = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.SAP_SIPPER).moves(AttackRegistry.AQUA_JET).build();
        TestParticipant team = helper.createParticipant(2, mew, azumarill);
        TestParticipant breloom = helper.createParticipant(2, helper.createDefaultPokemon(PixelmonSpecies.BRELOOM).moves(AttackRegistry.VINE_WHIP).ability(AbilityRegistry.TECHNICIAN).build());
        return helper.setupDoubleBattleBuilder(team, breloom).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.attackOpponent(mew, 1);
                team.attackOpponent(azumarill, 1);
                breloom.attackTarget(1, mew);
            });
            if (team.asWrapper(mew).hasFullHealth()) {
                return TestResult.failure("SapSipper should not redirect grass moves.");
            }
            if (team.asWrapper(azumarill).getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("SapSipper should not gain attack if another pokemon targetted by grass moves.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testAromatherapyAbsorbedIfUsedByAlly(BattleTestHelper helper) {
        Pokemon slurpuff = helper.createDefaultPokemon(PixelmonSpecies.SLURPUFF).moves(AttackRegistry.AROMATHERAPY).build();
        Pokemon azumarill = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.SAP_SIPPER).moves(AttackRegistry.AQUA_JET).build();
        TestParticipant team = helper.createParticipant(2, slurpuff, azumarill);
        TestParticipant glimmora = helper.createParticipant(2, helper.createDefaultPokemon(PixelmonSpecies.GLIMMORA).moves(AttackRegistry.MORTAL_SPIN).build());
        return helper.setupDoubleBattleBuilder(team, glimmora).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.attackAutoTarget(slurpuff, 1);
                team.attackOpponent(azumarill, 1);
                glimmora.attackAutoTarget(1);
            });
            if (team.asWrapper(slurpuff).hasStatus(StatusType.Poison)) {
                return TestResult.failure("SapSipper should not prevent allies being cured of poison.");
            }
            if (!team.asWrapper(azumarill).hasStatus(StatusType.Poison)) {
                return TestResult.failure("SapSipper should absorb aromatherapy against Azumarill, preventing the poison being cured.");
            }
            if (team.asWrapper(azumarill).getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("SapSipper should gain attack if another pokemon targetted by grass moves.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testAromatherapyNotAbsorbedIfUsedBySelf(BattleTestHelper helper) {
        Pokemon slurpuff = helper.createDefaultPokemon(PixelmonSpecies.SLURPUFF).moves(AttackRegistry.TACKLE).build();
        Pokemon azumarill = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.SAP_SIPPER).moves(AttackRegistry.AROMATHERAPY).build();
        TestParticipant team = helper.createParticipant(2, slurpuff, azumarill);
        TestParticipant glimmora = helper.createParticipant(2, helper.createDefaultPokemon(PixelmonSpecies.GLIMMORA).moves(AttackRegistry.MORTAL_SPIN).build());
        return helper.setupDoubleBattleBuilder(team, glimmora).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.attackAutoTarget(azumarill, 1);
                team.attackOpponent(slurpuff, 1);
                glimmora.attackAutoTarget(1);
            });
            if (team.asWrapper(slurpuff).hasStatus(StatusType.Poison)) {
                return TestResult.failure("SapSipper should not prevent allies being cured of poison.");
            }
            if (team.asWrapper(azumarill).hasStatus(StatusType.Poison)) {
                return TestResult.failure("SapSipper should not absorb its own aromatherapy.");
            }
            if (team.asWrapper(azumarill).getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("SapSipper should not absorb its own moves.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testBoostsOnceForMultiHitAttacks(BattleTestHelper helper) {
        TestParticipant azumarill = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.SAP_SIPPER).moves(AttackRegistry.AROMATHERAPY).build());
        TestParticipant breloom = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRELOOM).moves(AttackRegistry.BULLET_SEED).build());
        return helper.setupSingleBattleBuilder(azumarill, breloom).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                azumarill.attackSelf(1);
                breloom.attackOpponent(1);
            });
            if (azumarill.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("SapSipper should only boost once for multi-hit moves.");
            }
            return TestResult.success();
        });
    }
}

