/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class RoughSkinTests {
    @BattleTest
    public static CompletableFuture<TestResult> testCausesNoDoubleActivation(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.ROUGH_SKIN).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PACHIRISU).ability(AbilityRegistry.VOLT_ABSORB).moves(AttackRegistry.NUZZLE).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            int targetHealth = teamB.asWrapper().getMaxHealth() - teamB.asWrapper().getMaxHealth() / 8;
            if (teamB.asWrapper().getHealth() != targetHealth) {
                return TestResult.failure("Pachirisu took damage from Rough Skin twice expected " + targetHealth + " got " + teamB.asWrapper().getHealth());
            }
            return TestResult.success();
        });
    }
}

