/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class RockHeadTests {
    @BattleTest
    public static CompletableFuture<TestResult> testBlocksRecoilFromMostMoves(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).ability(AbilityRegistry.ROCK_HEAD).moves(AttackRegistry.DOUBLE_EDGE).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.CLEAR_BODY).moves(AttackRegistry.REST).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackSelf(1);
            });
            if (!teamA.asWrapper().hasFullHealth()) {
                return TestResult.failure("Aerodactyl took recoil damage from Double Edge");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotBlockRecoilIfCancelledMidAttack(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).ability(AbilityRegistry.ROCK_HEAD).moves(AttackRegistry.DOUBLE_EDGE).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGISTEEL).ability(AbilityRegistry.MUMMY).moves(AttackRegistry.REST).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackSelf(1);
            });
            if (teamA.asWrapper().hasFullHealth()) {
                return TestResult.failure("Aerodactyl did not take recoil damage from Double Edge");
            }
            return TestResult.success();
        });
    }

    @BattleTest(experimental=true)
    public static CompletableFuture<TestResult> testDoesNotBlockStruggleRecoil(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).ability(AbilityRegistry.ROCK_HEAD).moves(AttackRegistry.ROOST).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SABLEYE).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.TAUNT).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            if (teamA.asWrapper().hasFullHealth()) {
                return TestResult.failure("Aerodactyl did not take recoil damage from Struggle");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotBlockCrashDamage(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAMPARDOS).ability(AbilityRegistry.ROCK_HEAD).moves(AttackRegistry.JUMP_KICK).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SABLEYE).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.TAUNT).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(1);
            });
            if (teamA.asWrapper().hasFullHealth()) {
                return TestResult.failure("Ramparados did not take damage from Jump Kick");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotBlockIndirectDamage(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAMPARDOS).ability(AbilityRegistry.ROCK_HEAD).moves(AttackRegistry.SPLASH).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CROBAT).moves(AttackRegistry.TOXIC).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(1);
            });
            if (teamA.asWrapper().hasFullHealth()) {
                return TestResult.failure("Ramparados did not take damage from Toxic");
            }
            return TestResult.success();
        });
    }
}

