/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class RipenTests {
    @BattleTest
    public static CompletableFuture<TestResult> testDoublesHealingFromBerries(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.RIPEN).moves(AttackRegistry.SLEEP_TALK).heldItem(PixelmonItems.sitrus_berry).ev(BattleStatsType.HP, 30).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.COMPOUND_EYES).moves(AttackRegistry.SUPER_FANG).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            int targetHealth = teamA.asWrapper().getMaxHealth() / 2 + teamA.asWrapper().getMaxHealth() / 4 * 2;
            if (teamA.asWrapper().getHealth() != targetHealth) {
                return TestResult.failure("Healing from sitrus berry was not doubled. Expected " + targetHealth + " health, got " + teamA.asWrapper().getHealth());
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoublesStatBoostFromBerries(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.RIPEN).moves(AttackRegistry.SLEEP_TALK).heldItem(PixelmonItems.liechi_berry).ev(BattleStatsType.HP, 4).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.COMPOUND_EYES).moves(AttackRegistry.SUPER_FANG).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("Stat boost from liechi berry was not doubled. Expected 2, got " + teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK));
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoublesDamageFromBerries(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.RIPEN).moves(AttackRegistry.SLEEP_TALK).heldItem(PixelmonItems.jaboca_berry).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.FALINKS).moves(AttackRegistry.TACKLE).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            int targetHealth = teamB.asWrapper().getMaxHealth() - teamB.asWrapper().getMaxHealth() / 4;
            if (teamB.asWrapper().getHealth() != targetHealth) {
                return TestResult.failure("Damage from tackle was not doubled by jaboca berry. Expected " + targetHealth + " health, got " + teamA.asWrapper().getHealth());
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testResistBerriesQuarterDamageDone(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.RIPEN).moves(AttackRegistry.LUCKY_CHANT).heldItem(PixelmonItems.colbur_berry).ev(BattleStatsType.HP, 4).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.DARK_PULSE).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            if (!helper.inRange(teamA.asWrapper().getHealthDeficit(), 18, 22)) {
                return TestResult.failure("Damage from dark pulse was not quartered by colbur berry. Expected 18-22 damage, got " + teamA.asWrapper().getHealthDeficit());
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testResistBerriesQuarterDamageDoneEvenOnCrit(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.RIPEN).moves(AttackRegistry.SLEEP_TALK).heldItem(PixelmonItems.colbur_berry).ev(BattleStatsType.HP, 4).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.LASER_FOCUS, AttackRegistry.DARK_PULSE).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(2);
            });
            if (!helper.inRange(teamA.asWrapper().getHealthDeficit(), 27, 33)) {
                return TestResult.failure("Damage from dark pulse was not quartered by colbur berry. Expected 27-33 damage, got " + teamA.asWrapper().getHealthDeficit());
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoubleEffectsEatenByFling(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.RIPEN).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.FLING).heldItem(PixelmonItems.liechi_berry).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("Stat boost from liechi berry was not doubled. Expected 2, got " + teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK));
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoubleEffectsEatenByBugBite(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.RIPEN).moves(AttackRegistry.BUG_BITE).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).heldItem(PixelmonItems.liechi_berry).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackSelf(1);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("Stat boost from liechi berry was not doubled. Expected 2, got " + teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK));
            }
            return TestResult.success();
        });
    }
}

