/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.ParadoxBoost;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ProtosynthesisTests {
    @BattleTest
    public static CompletableFuture<TestResult> testBoostsHighestStatExceptHP(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SCREAMTAIL).ability(AbilityRegistry.PROTOSYNTHESIS).moves(AttackRegistry.RAIN_DANCE).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TORKOAL).ability(AbilityRegistry.DROUGHT).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            if (((ParadoxBoost)teamA.asWrapper().getStatus((StatusType)StatusType.ParadoxBoost)).boostedStat != BattleStatsType.SPECIAL_DEFENSE) {
                return TestResult.failure("Protosynthesis boosted " + ((ParadoxBoost)teamA.asWrapper().getStatus((StatusType)StatusType.ParadoxBoost)).boostedStat + " instead of Special Defense");
            }
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackSelf(1);
            });
            if (teamA.asWrapper().getStatus(StatusType.ParadoxBoost) != null) {
                return TestResult.failure("Protosynthesis did not deactivate after weather changed");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTakesStatStagesAndNoOtherBoostsIntoAccount(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ROARINGMOON).ability(AbilityRegistry.PROTOSYNTHESIS).moves(AttackRegistry.TAILWIND).ev(BattleStatsType.ATTACK, 252).ev(BattleStatsType.SPECIAL_DEFENSE, 252).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SALAMENCE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SUNNY_DAY).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackSelf(1);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Attack stat was not lowered");
            }
            if (((ParadoxBoost)teamA.asWrapper().getStatus((StatusType)StatusType.ParadoxBoost)).boostedStat != BattleStatsType.SPECIAL_DEFENSE) {
                return TestResult.failure("Protosynthesis boosted " + ((ParadoxBoost)teamA.asWrapper().getStatus((StatusType)StatusType.ParadoxBoost)).boostedStat + " instead of Special Defense");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotActivateWhileDesolateLandActive(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ROARINGMOON).ability(AbilityRegistry.PROTOSYNTHESIS).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GROUDON).form("primal").ability(AbilityRegistry.DESOLATE_LAND).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            if (teamA.asWrapper().getStatus(StatusType.ParadoxBoost) != null) {
                return TestResult.failure("Protosynthesis activated while Desolate Land was active");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testActivatedByBoosterEnergy(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SCREAMTAIL).ability(AbilityRegistry.PROTOSYNTHESIS).moves(AttackRegistry.RAIN_DANCE, AttackRegistry.SUNNY_DAY).heldItem(PixelmonItems.booster_energy).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TORKOAL).ability(AbilityRegistry.DROUGHT).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            if (((ParadoxBoost)teamA.asWrapper().getStatus((StatusType)StatusType.ParadoxBoost)).boostedStat != BattleStatsType.SPECIAL_DEFENSE) {
                return TestResult.failure("Scream Tail's special defence should have been boosted by Protosynthesis in Sun");
            }
            if (((ParadoxBoost)teamA.asWrapper().getStatus((StatusType)StatusType.ParadoxBoost)).itemBased) {
                return TestResult.failure("Scream Tail's special defence should not have been boosted by Booster Energy in Sun");
            }
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackSelf(1);
            });
            if (!((ParadoxBoost)teamA.asWrapper().getStatus((StatusType)StatusType.ParadoxBoost)).itemBased) {
                return TestResult.failure("Scream Tail's special defence should have been boosted by Booster Energy in Rain");
            }
            controller.takeFullTurn(() -> {
                teamA.attackSelf(2);
                teamB.attackSelf(1);
            });
            if (teamA.asWrapper().getStatus(StatusType.ParadoxBoost) == null) {
                return TestResult.failure("Scream Tail's special defence should still be boosted by Protosynthesis in Sun");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testBoostNullifiedByNeutralizingGas(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SCREAMTAIL).ability(AbilityRegistry.PROTOSYNTHESIS).moves(AttackRegistry.LUCKY_CHANT, AttackRegistry.RECOVER).heldItem(PixelmonItems.booster_energy).build());
        Pokemon weezing1 = helper.createDefaultPokemon(PixelmonSpecies.WEEZING).moves(AttackRegistry.VENOSHOCK).build();
        Pokemon weezing2 = helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.VENOSHOCK).build();
        TestParticipant teamB = helper.createParticipant(weezing1, weezing2);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            if (!helper.inRange(teamA.asWrapper().getHealthDeficit(), 84, 105)) {
                return TestResult.failure("Expected damage to be between 84 and 105, but was " + teamA.asWrapper().getHealthDeficit());
            }
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.switchPokemon(weezing1, weezing2);
            });
            controller.takeFullTurn(() -> {
                teamA.attackSelf(2);
                teamB.attackOpponent(1);
            });
            if (!helper.inRange(teamA.asWrapper().getHealthDeficit(), 105, 132)) {
                return TestResult.failure("Expected damage to be between 105 and 132, but was " + teamA.asWrapper().getHealthDeficit());
            }
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.switchPokemon(weezing2, weezing1);
            });
            controller.takeFullTurn(() -> {
                teamA.attackSelf(2);
                teamB.attackOpponent(1);
            });
            if (!helper.inRange(teamA.asWrapper().getHealthDeficit(), 84, 105)) {
                return TestResult.failure("Expected damage to be between 84 and 105, but was " + teamA.asWrapper().getHealthDeficit());
            }
            return TestResult.success();
        });
    }
}

