/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.Rainy;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class PrimordealSeaTests {
    @BattleTest
    public static CompletableFuture<TestResult> testChangesWeatherOnSwitchIn(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.PRIMORDIAL_SEA).moves(AttackRegistry.HELPING_HAND).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ABRA).ability(AbilityRegistry.MAGIC_GUARD).moves(AttackRegistry.TELEPORT).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            block3: {
                block2: {
                    Weather patt1995$temp = controller.globalStatusController.getWeather();
                    if (!(patt1995$temp instanceof Rainy)) break block2;
                    Rainy rainy = (Rainy)patt1995$temp;
                    if (rainy.extreme) break block3;
                }
                return TestResult.failure("Weather was not changed by Primordial Sea");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testIncreasesPowersOfWaterTypes(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.PRIMORDIAL_SEA).moves(AttackRegistry.WATER_PLEDGE).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLASTOISE).ability(AbilityRegistry.TORRENT).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(1);
            });
            if (teamB.asWrapper().getHealthDeficit() != 105) {
                return TestResult.failure("Water type attack damage was not boosted by Primordial Sea expected 104 but got " + teamB.asWrapper().getHealthDeficit());
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCausesFireAttacksToFail(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.PRIMORDIAL_SEA).moves(AttackRegistry.HELPING_HAND).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CHARIZARD).ability(AbilityRegistry.BLAZE).moves(AttackRegistry.FLAMETHROWER).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            if (!teamB.asWrapper().hasFullHealth()) {
                return TestResult.failure("Fire type attack was not blocked by Primordial Sea");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotCausesFireStatusAttacksToFail(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.PRIMORDIAL_SEA).moves(AttackRegistry.HELPING_HAND).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CHARIZARD).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.WILL_O_WISP).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            if (teamA.asWrapper().getStatus(StatusType.Burn) == null) {
                return TestResult.failure("Fire type status attack was blocked by Primordial Sea");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotAllowWeatherChange(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.PRIMORDIAL_SEA).moves(AttackRegistry.HELPING_HAND).build());
        Pokemon abra = helper.createDefaultPokemon(PixelmonSpecies.ABRA).ability(AbilityRegistry.MAGIC_GUARD).moves(AttackRegistry.TELEPORT).build();
        Pokemon kyogre = helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.DRIZZLE).moves(AttackRegistry.RAIN_DANCE).build();
        Pokemon groudon = helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DROUGHT).moves(AttackRegistry.SUNNY_DAY).build();
        Pokemon tyraniar = helper.createDefaultPokemon(PixelmonSpecies.TYRANITAR).ability(AbilityRegistry.SAND_STREAM).moves(AttackRegistry.SANDSTORM).build();
        Pokemon abomasnow = helper.createDefaultPokemon(PixelmonSpecies.ABOMASNOW).ability(AbilityRegistry.SNOW_WARNING).moves(AttackRegistry.HAIL).build();
        Pokemon[] teamBPokes = new Pokemon[]{abra, kyogre, groudon, tyraniar, abomasnow};
        TestParticipant teamB = helper.createParticipant(abra, kyogre, groudon, tyraniar, abomasnow);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            int i = 1;
            while (i < 5) {
                block6: {
                    block5: {
                        int finalI = i++;
                        controller.takeFullTurn(() -> {
                            teamA.attackSelf(1);
                            teamB.switchPokemon(teamBPokes[finalI - 1], teamBPokes[finalI]);
                        });
                        Weather patt7366$temp = controller.globalStatusController.getWeather();
                        if (!(patt7366$temp instanceof Rainy)) break block5;
                        Rainy rainy = (Rainy)patt7366$temp;
                        if (rainy.extreme) break block6;
                    }
                    return TestResult.failure("Weather was changed despite Primordial Sea being active");
                }
                controller.takeFullTurn(() -> {
                    teamA.attackSelf(1);
                    teamB.attackOpponent(1);
                });
                Weather patt7815$temp = controller.globalStatusController.getWeather();
                if (patt7815$temp instanceof Rainy) {
                    Rainy rainy2 = (Rainy)patt7815$temp;
                    if (rainy2.extreme) continue;
                }
                return TestResult.failure("Weather was changed despite Primordial Sea being active");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTreatedAsRainDanceForAnyMoveOrFormThatRequiresIt(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.PRIMORDIAL_SEA).moves(AttackRegistry.SONIC_BOOM).build());
        Pokemon castform = helper.createDefaultPokemon(PixelmonSpecies.CASTFORM).ability(AbilityRegistry.FORECAST).moves(AttackRegistry.WEATHER_BALL).build();
        Pokemon kingdra = helper.createDefaultPokemon(PixelmonSpecies.KINGDRA).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.FOCUS_ENERGY).build();
        Pokemon ludicolo = helper.createDefaultPokemon(PixelmonSpecies.LUDICOLO).ability(AbilityRegistry.RAIN_DISH).moves(AttackRegistry.WATER_SPORT).build();
        Pokemon toxicroak = helper.createDefaultPokemon(PixelmonSpecies.TOXICROAK).ability(AbilityRegistry.DRY_SKIN).moves(AttackRegistry.BULK_UP).build();
        Pokemon manaphy = helper.createDefaultPokemon(PixelmonSpecies.MANAPHY).ability(AbilityRegistry.HYDRATION).heldItem(PixelmonItems.lagging_tail).moves(AttackRegistry.REST).build();
        TestParticipant teamB = helper.createParticipant(castform, kingdra, ludicolo, toxicroak, manaphy);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            if (!teamB.asWrapper().getForm().is("rain")) {
                return TestResult.failure("Castform did not change to its Rainy form");
            }
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.switchPokemon(castform, kingdra);
            });
            if (teamB.asWrapper(kingdra).getBattleStats().getStatFromEnum(BattleStatsType.SPEED) != kingdra.getStats().get(BattleStatsType.SPEED) * 2) {
                return TestResult.failure("Kingdra's speed was not doubled by Swift Swim expected " + kingdra.getStats().get(BattleStatsType.SPEED) * 2 + " but got " + teamB.asWrapper(kingdra).getBattleStats().getStatFromEnum(BattleStatsType.SPEED));
            }
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.switchPokemon(kingdra, ludicolo);
            });
            if (teamB.asWrapper().getHealthDeficit() == 20) {
                return TestResult.failure("Ludicolo's health was not restored by Rain Dish");
            }
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.switchPokemon(ludicolo, toxicroak);
            });
            if (teamB.asWrapper().getHealthDeficit() == 20) {
                return TestResult.failure("Toxicroak's health was not restored by Dry Skin");
            }
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.switchPokemon(toxicroak, manaphy);
            });
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            if (teamB.asWrapper().getStatuses().size() > 1) {
                return TestResult.failure("Manaphy did not cure its status with Hydration");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCausesFadeWhenSwitched(BattleTestHelper helper) {
        Pokemon kygore = helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.PRIMORDIAL_SEA).moves(AttackRegistry.HELPING_HAND).build();
        Pokemon hooh = helper.createDefaultPokemon(PixelmonSpecies.HOOH).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ROOST).build();
        TestParticipant teamA = helper.createParticipant(kygore, hooh);
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUGIA).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ROOST).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.switchPokemon(kygore, hooh);
                teamB.attackSelf(1);
            });
            Weather patt13280$temp = controller.globalStatusController.getWeather();
            if (patt13280$temp instanceof Rainy) {
                Rainy rainy = (Rainy)patt13280$temp;
                if (rainy.extreme) {
                    return TestResult.failure("Weather was not removed when Primordial Sea faded");
                }
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCausesNoFadeWhenSwitchedAndOneStillActive(BattleTestHelper helper) {
        Pokemon kygore = helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.PRIMORDIAL_SEA).moves(AttackRegistry.HELPING_HAND).build();
        Pokemon hooh = helper.createDefaultPokemon(PixelmonSpecies.HOOH).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ROOST).build();
        TestParticipant teamA = helper.createParticipant(kygore, hooh);
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.PRIMORDIAL_SEA).moves(AttackRegistry.BULK_UP).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            block3: {
                block2: {
                    controller.takeFullTurn(() -> {
                        teamA.switchPokemon(kygore, hooh);
                        teamB.attackSelf(1);
                    });
                    Weather patt14793$temp = controller.globalStatusController.getWeather();
                    if (!(patt14793$temp instanceof Rainy)) break block2;
                    Rainy rainy = (Rainy)patt14793$temp;
                    if (rainy.extreme) break block3;
                }
                return TestResult.failure("Weather removed when Kyogre switched but another Kyogre was still active");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCausesFadeWhenSuppressedByGastricAcid(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.PRIMORDIAL_SEA).moves(AttackRegistry.HELPING_HAND).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUGIA).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.GASTRO_ACID).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            Weather patt16084$temp = controller.globalStatusController.getWeather();
            if (patt16084$temp instanceof Rainy) {
                Rainy rainy = (Rainy)patt16084$temp;
                if (rainy.extreme) {
                    return TestResult.failure("Weather was not removed when Primordial Sea was suppressed by Gastro Acid");
                }
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCausesNoFadeWhenSuppressedByGastricAcidButAnotherActive(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.PRIMORDIAL_SEA).moves(AttackRegistry.HELPING_HAND).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUGIA).ability(AbilityRegistry.PRIMORDIAL_SEA).moves(AttackRegistry.GASTRO_ACID).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            block3: {
                block2: {
                    controller.takeFullTurn(() -> {
                        teamA.attackSelf(1);
                        teamB.attackOpponent(1);
                    });
                    Weather patt17401$temp = controller.globalStatusController.getWeather();
                    if (!(patt17401$temp instanceof Rainy)) break block2;
                    Rainy rainy = (Rainy)patt17401$temp;
                    if (rainy.extreme) break block3;
                }
                return TestResult.failure("Weather was removed when Primordial Sea was suppressed by Gastro Acid but another Kyogre was still active");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCausedFadeWhenAbilityChanged(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.PRIMORDIAL_SEA).moves(AttackRegistry.HELPING_HAND).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUGIA).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ENTRAINMENT).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            Weather patt18716$temp = controller.globalStatusController.getWeather();
            if (patt18716$temp instanceof Rainy) {
                Rainy rainy = (Rainy)patt18716$temp;
                if (rainy.extreme) {
                    return TestResult.failure("Weather was not removed when Primordial Sea was removed by Entrainment");
                }
            }
            return TestResult.success();
        });
    }
}

