/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class PranksterTests {
    @BattleTest
    public static CompletableFuture<TestResult> testIncreaseStatusMovePriority(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MURKROW).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.TAUNT).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DEOXYS).form("speed").ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.CALM_MIND).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackSelf(1);
            });
            if (teamB.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("Deoxy's special attack was boosted when it should not have been");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCausesStatusMovesToFailAgainstDarkType(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SABLEYE).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.WILL_O_WISP).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SABLEYE).ability(AbilityRegistry.KEEN_EYE).moves(AttackRegistry.WILL_O_WISP).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(1);
            });
            if (teamB.asWrapper().getStatus(StatusType.Burn) != null) {
                return TestResult.failure("Burn was applied even when it should not be due to Prankster combined with dark type");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCausesBouncedStatusMovesToFailAgainstDarkType(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KLEFKI).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.MAGIC_COAT).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SPIRITOMB).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.WILL_O_WISP).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            if (teamB.asWrapper().getStatus(StatusType.Burn) != null) {
                return TestResult.failure("Burn was applied even when it should not be due to Prankster combined with dark type");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotCauseFailureAfterRemoval(BattleTestHelper helper) {
        Pokemon alakazam = helper.createDefaultPokemon(PixelmonSpecies.ALAKAZAM).ability(AbilityRegistry.SYNCHRONIZE).moves(AttackRegistry.SKILL_SWAP).build();
        Pokemon sableye = helper.createDefaultPokemon(PixelmonSpecies.SABLEYE).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.MAGIC_COAT).build();
        Pokemon pyukummuku = helper.createDefaultPokemon(PixelmonSpecies.PYUKUMUKU).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.CURSE).build();
        Pokemon houndoom = helper.createDefaultPokemon(PixelmonSpecies.HOUNDOOM).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.CONFIDE).build();
        TestParticipant teamA = helper.createParticipant(2, alakazam, sableye);
        TestParticipant teamB = helper.createParticipant(2, pyukummuku, houndoom);
        return helper.setupDoubleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackTarget(alakazam, 1, sableye);
                teamA.attackSelf(sableye, 1);
                teamB.attackOpponent(pyukummuku, 1);
                teamB.attackTarget(houndoom, 1, sableye);
            });
            if (teamB.asWrapper(houndoom).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != -1) {
                return TestResult.failure("should not cause bounced Status moves to fail against Dark Pok\u00e9mon if it is removed");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotCauseEncoreForcedDarkMovesToFail(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LIEPARD).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.ENCORE).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RIOLU).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.CONFIDE, AttackRegistry.RETURN).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(2);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != -1) {
                return TestResult.failure("Prankster blocked encore forced moves");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testEncoreFailureIfIntendedStatus(BattleTestHelper helper) {
        Pokemon liepard = helper.createDefaultPokemon(PixelmonSpecies.LIEPARD).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.ENCORE, AttackRegistry.NASTY_PLOT).build();
        Pokemon tapuFinny = helper.createDefaultPokemon(PixelmonSpecies.TAPU_FINI).ability(AbilityRegistry.MISTY_SURGE).moves(AttackRegistry.CALM_MIND).build();
        Pokemon meowstic = helper.createDefaultPokemon(PixelmonSpecies.MEOWSTIC).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.FRUSTRATION, AttackRegistry.LEER).build();
        Pokemon lopunny = helper.createDefaultPokemon(PixelmonSpecies.LOPUNNY).ability(AbilityRegistry.LIMBER).moves(AttackRegistry.AGILITY).build();
        TestParticipant teamA = helper.createParticipant(2, liepard, tapuFinny);
        TestParticipant teamB = helper.createParticipant(2, meowstic, lopunny);
        return helper.setupDoubleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackTarget(liepard, 1, meowstic);
                teamA.attackSelf(tapuFinny, 1);
                teamB.attackTarget(meowstic, 1, tapuFinny);
                teamB.attackSelf(lopunny, 1);
            });
            controller.takeFullTurn(() -> {
                teamA.attackTarget(liepard, 1, meowstic);
                teamA.attackSelf(tapuFinny, 1);
                teamB.attackSelf(meowstic, 2);
                teamB.attackSelf(lopunny, 1);
            });
            if (teamB.asWrapper(meowstic).getStatus(StatusType.Encore) == null) {
                return TestResult.failure("Meowstic should be encored");
            }
            if (!teamA.asWrapper(liepard).hasFullHealth()) {
                return TestResult.failure("Liepard was damaged");
            }
            return TestResult.success();
        });
    }
}

