/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.WaterPledge;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class PoisonTouchTests {
    @BattleTest
    public static CompletableFuture<TestResult> poisonsTargetsIfUserDamagesTargetWithContactMove(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.POISON_TOUCH).moves(AttackRegistry.FALSE_SWIPE).build());
        TestParticipant shuckle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).moves(AttackRegistry.FALSE_SWIPE).build());
        return helper.setupSingleBattleBuilder(wynaut, shuckle).forceChance().start().thenApply(controller -> {
            wynaut.attackOpponent(1);
            shuckle.attackOpponent(1);
            controller.takeFullTurn();
            if (wynaut.asWrapper().hasStatus(StatusType.Poison)) {
                return TestResult.failure("Wynaut should not be poisoned by its own ability.");
            }
            if (!shuckle.asWrapper().hasStatus(StatusType.Poison)) {
                return TestResult.failure("Shuckle should be poisoned.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldNotPoisonTargetsWithShieldDust(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.POISON_TOUCH).moves(AttackRegistry.FALSE_SWIPE).build());
        TestParticipant shuckle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.SHIELD_DUST).moves(AttackRegistry.FALSE_SWIPE).build());
        return helper.setupSingleBattleBuilder(wynaut, shuckle).forceChance().start().thenApply(controller -> {
            wynaut.attackOpponent(1);
            shuckle.attackOpponent(1);
            controller.takeFullTurn();
            if (wynaut.asWrapper().hasStatus(StatusType.Poison)) {
                return TestResult.failure("Wynaut should not be poisoned by its own ability.");
            }
            if (shuckle.asWrapper().hasStatus(StatusType.Poison)) {
                return TestResult.failure("ShieldDust should block poison.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldNotPoisonIfHitSubsitute(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.POISON_TOUCH).moves(AttackRegistry.FALSE_SWIPE).build());
        TestParticipant shuckle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.SUBSTITUTE).build());
        return helper.setupSingleBattleBuilder(wynaut, shuckle).forceChance().start().thenApply(controller -> {
            wynaut.attackOpponent(1);
            shuckle.attackSelf(1);
            controller.takeFullTurn();
            if (shuckle.asWrapper().hasStatus(StatusType.Poison)) {
                return TestResult.failure("Shuckle should be protected by the Substitute.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> poisonsAfterSecondaryMoves(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.POISON_TOUCH).moves(AttackRegistry.FIRE_PUNCH).build());
        TestParticipant shuckle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).heldItem(PixelmonItems.lum_berry).moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.NO_GUARD).build());
        return helper.setupSingleBattleBuilder(wynaut, shuckle).forceChance().start().thenApply(controller -> {
            wynaut.attackOpponent(1);
            shuckle.attackOpponent(1);
            controller.takeFullTurn();
            if (shuckle.asWrapper().hasHeldItem()) {
                return TestResult.failure("Shuckle should have used its lum berry.");
            }
            if (shuckle.asWrapper().hasStatus(StatusType.Burn)) {
                return TestResult.failure("Shuckle should be cured of burn by the LumBerry.");
            }
            if (!shuckle.asWrapper().hasStatus(StatusType.Poison)) {
                return TestResult.failure("Shuckle should have used the lum berry before being poisoned by Poison Touch.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> poisonsBeforeMummyStealsAbility(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.POISON_TOUCH).moves(AttackRegistry.FALSE_SWIPE).build());
        TestParticipant shuckle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.MUMMY).moves(AttackRegistry.BIDE).build());
        return helper.setupSingleBattleBuilder(wynaut, shuckle).forceChance().start().thenApply(controller -> {
            wynaut.attackOpponent(1);
            shuckle.attackSelf(1);
            controller.takeFullTurn();
            if (!wynaut.asWrapper().getBattleAbility().isAbility(AbilityRegistry.MUMMY)) {
                return TestResult.failure("Wynaut should have lost PoisonTouch to Mummy");
            }
            if (!shuckle.asWrapper().hasStatus(StatusType.Poison)) {
                return TestResult.failure("Shuckle should have been poisoned before switching abilities.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldNotPoisonItselfIfUsingContactMovesNotHittingOthers(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.POISON_TOUCH).moves(AttackRegistry.BIDE).build());
        TestParticipant shuckle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(wynaut, shuckle).forceChance().start().thenApply(controller -> {
            for (int i = 0; i < 4; ++i) {
                shuckle.attackOpponent(1);
                wynaut.attackSelf(1);
                controller.takeFullTurn();
            }
            if (wynaut.asWrapper().hasStatus(StatusType.Poison)) {
                return TestResult.failure("Wynaut should not poison itself if contact move does not hit opponent");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldNotBeBoostedByRainbowPledge(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.POISON_TOUCH).moves(AttackRegistry.TACKLE).build());
        TestParticipant shuckle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(wynaut, shuckle).start().thenApply(controller -> {
            wynaut.asWrapper().addTeamStatus(new WaterPledge(), wynaut.asWrapper());
            shuckle.attackOpponent(1);
            wynaut.attackOpponent(1);
            controller.advanceToMoves();
            ArrayList<EffectBase> effects = new ArrayList<EffectBase>(wynaut.asWrapper().attack.getMove().effects);
            Attack.modifyMoveEffects(wynaut.asWrapper(), shuckle.asWrapper(), effects);
            if (((EffectBase)effects.get(0)).getChance() != 30.0f) {
                ((EffectBase)effects.get(0)).checkChance((BattleController)controller);
                return TestResult.failure("Poison chance was changed by Rainbow");
            }
            ((EffectBase)effects.get(0)).checkChance((BattleController)controller);
            return TestResult.success();
        });
    }
}

