/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class PickPocketTests {
    @BattleTest
    public static CompletableFuture<TestResult> testStealsFoesItemWhenHitByContactMove(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WEAVILE).ability(AbilityRegistry.PICKPOCKET).moves(AttackRegistry.AGILITY).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SYLVEON).heldItem(PixelmonItems.choice_scarf).moves(AttackRegistry.QUICK_ATTACK).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            if (teamA.asWrapper().getHeldItem() instanceof NoItem) {
                return TestResult.failure("PickPocket ability did not steal opponent's item on contact damage");
            }
            if (teamB.asWrapper().getHeldItem() == PixelmonItems.choice_scarf) {
                return TestResult.failure("PicketPocket ability did not take opponent's item on contact damage");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotStealAfterEjectButton(BattleTestHelper helper) {
        Pokemon weavile = helper.createDefaultPokemon(PixelmonSpecies.WEAVILE).ability(AbilityRegistry.PICKPOCKET).heldItem(PixelmonItems.eject_button).moves(AttackRegistry.AGILITY).build();
        Pokemon chansey = helper.createDefaultPokemon(PixelmonSpecies.CHANSEY).moves(AttackRegistry.SOFT_BOILED).build();
        TestParticipant teamA = helper.createParticipant(weavile, chansey);
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SYLVEON).heldItem(PixelmonItems.choice_scarf).moves(AttackRegistry.QUICK_ATTACK).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamA.switchPokemon(weavile, chansey);
                teamB.attackOpponent(1);
            });
            if (teamB.asWrapper().getHeldItem() != PixelmonItems.choice_scarf) {
                return TestResult.failure("Weavile stole the choice scarf from Sylveon despite being swapped out by the eject button");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotStealAfterForcedOutOfBattle(BattleTestHelper helper) {
        Pokemon weavile = helper.createDefaultPokemon(PixelmonSpecies.WEAVILE).ability(AbilityRegistry.PICKPOCKET).heldItem(PixelmonItems.eject_button).moves(AttackRegistry.AGILITY).build();
        Pokemon chansey = helper.createDefaultPokemon(PixelmonSpecies.CHANSEY).moves(AttackRegistry.SOFT_BOILED).build();
        TestParticipant teamA = helper.createParticipant(weavile, chansey);
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DURALUDON).ability(AbilityRegistry.COMPOUND_EYES).heldItem(PixelmonItems.choice_scarf).moves(AttackRegistry.DRAGON_TAIL).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamA.switchPokemon(weavile, chansey);
                teamB.attackOpponent(1);
            });
            if (teamB.asWrapper().getHeldItem() != PixelmonItems.choice_scarf) {
                return TestResult.failure("Weavile stole the choice scarf from Duraludon despite being forced out by dragon tail");
            }
            return TestResult.success();
        });
    }
}

