/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class PastelVeilTests {
    @BattleTest
    public static CompletableFuture<TestResult> testBlocksPoison(BattleTestHelper helper) {
        Pokemon ponyta = helper.createDefaultPokemon(PixelmonSpecies.PONYTA).ability(AbilityRegistry.PASTEL_VEIL).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynautA = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon croagunk = helper.createDefaultPokemon(PixelmonSpecies.CROAGUNK).moves(AttackRegistry.TOXIC).build();
        Pokemon wynautB = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.COMPOUND_EYES).moves(AttackRegistry.POISON_GAS).build();
        TestParticipant teamA = helper.createParticipant(2, ponyta, wynautA);
        TestParticipant teamB = helper.createParticipant(2, croagunk, wynautB);
        return helper.setupDoubleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(wynautA, 1);
                teamA.attackSelf(ponyta, 1);
                teamB.attackOpponent(croagunk, 1);
                teamB.attackOpponent(wynautB, 1);
            });
            if (teamA.asWrapper(ponyta).hasStatus(StatusType.PoisonBadly)) {
                return TestResult.failure("Ponyta was poisoned by Croagunk");
            }
            if (teamA.asWrapper(wynautA).hasStatus(StatusType.Poison)) {
                return TestResult.failure("Wynaut was poisoned by Croagunk");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testClearsPoisonOnSwitchIn(BattleTestHelper helper) {
        Pokemon ponyta = helper.createDefaultPokemon(PixelmonSpecies.PONYTA).ability(AbilityRegistry.PASTEL_VEIL).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynautA1 = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynautA2 = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon croagunk = helper.createDefaultPokemon(PixelmonSpecies.CROAGUNK).moves(AttackRegistry.TOXIC).build();
        Pokemon wynautB = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.COMPOUND_EYES).moves(AttackRegistry.POISON_GAS).build();
        TestParticipant teamA = helper.createParticipant(2, ponyta, wynautA1, wynautA2);
        TestParticipant teamB = helper.createParticipant(2, croagunk, wynautB);
        return helper.setupDoubleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(wynautA1, 1);
                teamA.attackSelf(ponyta, 1);
                teamB.attackOpponent(croagunk, 1);
                teamB.attackOpponent(wynautB, 1);
            });
            controller.takeFullTurn(() -> {
                teamA.attackSelf(wynautA1, 1);
                teamA.switchPokemon(ponyta, wynautA2);
                teamB.attackOpponent(croagunk, 1);
                teamB.attackOpponent(wynautB, 1);
            });
            controller.takeFullTurn(() -> {
                teamA.attackSelf(wynautA1, 1);
                teamA.switchPokemon(wynautA2, ponyta);
                teamB.attackOpponent(croagunk, 1);
                teamB.attackOpponent(wynautB, 1);
            });
            if (teamA.asWrapper(ponyta).hasStatus(StatusType.PoisonBadly)) {
                return TestResult.failure("Ponyta was poisoned by Croagunk");
            }
            if (teamA.asWrapper(wynautA1).hasStatus(StatusType.Poison)) {
                return TestResult.failure("Wynaut was poisoned by Croagunk");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testPreventsAllyPoison(BattleTestHelper helper) {
        Pokemon ponyta = helper.createDefaultPokemon(PixelmonSpecies.PONYTA).ability(AbilityRegistry.PASTEL_VEIL).moves(AttackRegistry.TOXIC).build();
        Pokemon wynautA = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.TOXIC).build();
        Pokemon croagunk = helper.createDefaultPokemon(PixelmonSpecies.CROAGUNK).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynautB = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.COMPOUND_EYES).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamA = helper.createParticipant(2, ponyta, wynautA);
        TestParticipant teamB = helper.createParticipant(2, croagunk, wynautB);
        return helper.setupDoubleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackTarget(wynautA, 1, ponyta);
                teamA.attackTarget(ponyta, 1, wynautA);
                teamB.attackSelf(croagunk, 1);
                teamB.attackSelf(wynautB, 1);
            });
            if (teamA.asWrapper(ponyta).hasStatus(StatusType.PoisonBadly)) {
                return TestResult.failure("Ponyta was poisoned by Wynaut");
            }
            if (teamA.asWrapper(wynautA).hasStatus(StatusType.Poison)) {
                return TestResult.failure("Wynaut was poisoned by Ponyta");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testClearsAffectsWhenAcquiredViaSkillSwap(BattleTestHelper helper) {
        Pokemon ponyta = helper.createDefaultPokemon(PixelmonSpecies.PONYTA).ability(AbilityRegistry.PASTEL_VEIL).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynautA = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon croagunk = helper.createDefaultPokemon(PixelmonSpecies.CROAGUNK).moves(AttackRegistry.SKILL_SWAP, AttackRegistry.SLEEP_TALK).build();
        Pokemon wynautB = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.COMPOUND_EYES).moves(AttackRegistry.POISON_GAS).build();
        TestParticipant teamA = helper.createParticipant(2, ponyta, wynautA);
        TestParticipant teamB = helper.createParticipant(2, croagunk, wynautB);
        return helper.setupDoubleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(wynautA, 1);
                teamA.attackSelf(ponyta, 1);
                teamB.attackTarget(croagunk, 1, ponyta);
                teamB.attackOpponent(wynautB, 1);
            });
            controller.takeFullTurn(() -> {
                teamA.attackSelf(wynautA, 1);
                teamA.attackSelf(ponyta, 1);
                teamB.attackTarget(croagunk, 1, ponyta);
                teamB.attackOpponent(wynautB, 1);
            });
            if (teamA.asWrapper(ponyta).hasStatus(StatusType.Poison)) {
                return TestResult.failure("Ponyta was poisoned by Wynaut");
            }
            if (teamA.asWrapper(wynautA).hasStatus(StatusType.Poison)) {
                return TestResult.failure("Wynaut was poisoned by Ponyta");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testMoldBreakerInteraction(BattleTestHelper helper) {
        Pokemon ponyta = helper.createDefaultPokemon(PixelmonSpecies.PONYTA).ability(AbilityRegistry.PASTEL_VEIL).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynautA = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon croagunk = helper.createDefaultPokemon(PixelmonSpecies.CROAGUNK).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.TOXIC).build();
        Pokemon wynautB = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamA = helper.createParticipant(2, ponyta, wynautA);
        TestParticipant teamB = helper.createParticipant(2, croagunk, wynautB);
        return helper.setupDoubleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(wynautA, 1);
                teamA.attackSelf(ponyta, 1);
                teamB.attackTarget(croagunk, 1, ponyta);
                teamB.attackSelf(wynautB, 1);
            });
            controller.takeFullTurn(() -> {
                teamA.attackSelf(wynautA, 1);
                teamA.attackSelf(ponyta, 1);
                teamB.attackTarget(croagunk, 1, wynautA);
                teamB.attackSelf(wynautB, 1);
            });
            if (teamA.asWrapper(ponyta).hasStatus(StatusType.PoisonBadly)) {
                return TestResult.failure("Ponyta was poisoned by Croagunk");
            }
            if (!teamA.asWrapper(wynautA).hasStatus(StatusType.PoisonBadly)) {
                return TestResult.failure("Wynaut was not poisoned by Croagunk");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testOnlyCuresAfterLumPechaBerry(BattleTestHelper helper) {
        Pokemon ponyta = helper.createDefaultPokemon(PixelmonSpecies.PONYTA).ability(AbilityRegistry.PASTEL_VEIL).heldItem(PixelmonItems.lum_berry).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynautA = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon croagunk = helper.createDefaultPokemon(PixelmonSpecies.CROAGUNK).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.TOXIC).build();
        Pokemon wynautB = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamA = helper.createParticipant(2, ponyta, wynautA);
        TestParticipant teamB = helper.createParticipant(2, croagunk, wynautB);
        return helper.setupDoubleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(wynautA, 1);
                teamA.attackSelf(ponyta, 1);
                teamB.attackTarget(croagunk, 1, ponyta);
                teamB.attackSelf(wynautB, 1);
            });
            if (teamA.asWrapper(ponyta).hasStatus(StatusType.PoisonBadly)) {
                return TestResult.failure("Ponyta was poisoned by Croagunk");
            }
            if (teamA.asWrapper(ponyta).getHeldItem() == PixelmonItems.lum_berry) {
                return TestResult.failure("Ponyta's Lum Berry was not consumed");
            }
            return TestResult.success();
        });
    }
}

