/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class OpportunistTests {
    @BattleTest
    public static CompletableFuture<TestResult> testOpportunistDoesNotCopyOpportunist(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ESPATHRA).ability(AbilityRegistry.OPPORTUNIST).moves(AttackRegistry.DRAGON_DANCE).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ESPATHRA).ability(AbilityRegistry.OPPORTUNIST).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().start().thenApply(controller -> {
            teamA.attackSelf(1);
            teamB.attackOpponent(1);
            controller.takeFullTurn();
            if (teamB.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1 || teamB.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != 1) {
                return TestResult.failure("Opportunist did not copy DragonDance");
            }
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1 || teamA.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != 1) {
                return TestResult.failure("Opportunist copied Opportunist");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testOpportunistCopiesStartOfBattleBoostEffects(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ESPATHRA).ability(AbilityRegistry.OPPORTUNIST).moves(AttackRegistry.SPLASH).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ZACIAN).ability(AbilityRegistry.INTREPID_SWORD).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(1);
            });
            if (teamB.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("IntrepidSword did not activate.");
            }
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("Opportunist did not copy a switch-in at the start");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testOpportunistShouldCopyAngerPoint(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ESPATHRA).ability(AbilityRegistry.OPPORTUNIST).moves(AttackRegistry.WICKED_BLOW).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PRIMEAPE).ability(AbilityRegistry.ANGER_POINT).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().start().thenApply(controller -> {
            teamA.attackOpponent(1);
            teamB.attackOpponent(1);
            controller.takeFullTurn();
            if (teamB.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 6) {
                return TestResult.failure("AngerPoint did not activate");
            }
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 6) {
                return TestResult.failure("Opportunist did not fully copy AngerPoint");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testOpportunistShouldOnlyCopyEffectiveChanges(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ESPATHRA).ability(AbilityRegistry.OPPORTUNIST).moves(AttackRegistry.WICKED_BLOW).build());
        Pokemon intimidate = helper.createDefaultPokemon(PixelmonSpecies.ARCANINE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SPLASH).build();
        Pokemon anger = helper.createDefaultPokemon(PixelmonSpecies.PRIMEAPE).ability(AbilityRegistry.ANGER_POINT).moves(AttackRegistry.SPLASH).build();
        TestParticipant teamB = helper.createParticipant(intimidate, anger);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().start().thenApply(controller -> {
            teamA.attackOpponent(1);
            teamB.switchPokemon(intimidate, anger);
            controller.takeFullTurn();
            if (teamB.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 6) {
                return TestResult.failure("AngerPoint did not activate");
            }
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 5) {
                return TestResult.failure("Opportunist did not copy effective +6 after intimidate's +1");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testOpportunistShouldCopySwitchInDuringSynchronousSwitches(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ESPATHRA).ability(AbilityRegistry.OPPORTUNIST).moves(AttackRegistry.SPLASH).build());
        Pokemon start = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.SPLASH).build();
        Pokemon sword = helper.createDefaultPokemon(PixelmonSpecies.ZACIAN).ability(AbilityRegistry.INTREPID_SWORD).moves(AttackRegistry.HEALING_WISH).build();
        Pokemon shield = helper.createDefaultPokemon(PixelmonSpecies.ZAMAZENTA).ability(AbilityRegistry.DAUNTLESS_SHIELD).moves(AttackRegistry.SPLASH).build();
        TestParticipant teamB = helper.createParticipant(start, sword, shield);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.switchPokemon(start, sword);
            });
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackSelf(1);
                teamB.switchPokemon(sword, shield);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("Opportunist did not copy start-of-turn switch ability effects.");
            }
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.DEFENSE) != 1) {
                return TestResult.failure("Opportunist did not copy faint-replacing switching ability effects");
            }
            return TestResult.success();
        });
    }
}

