/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Sunny;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class NeutralizingGasTests {
    @BattleTest
    public static CompletableFuture<TestResult> testNeutralizingGasStopsSwitchInAbilities(BattleTestHelper helper) {
        TestParticipant gyarados = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GYARADOS).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SPLASH).build());
        TestParticipant weezing = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.TOXIC_SPIKES).build());
        return helper.setupSingleBattleBuilder(gyarados, weezing).forceChance().start().thenApply(controller -> {
            if (weezing.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("Neutralizing Gas should prevent switch-in abilities from activating");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testIgnoreDamageReducingAbilities(BattleTestHelper helper) {
        TestParticipant mrmime = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MRMIME).ability(AbilityRegistry.FILTER).heldItem(PixelmonItems.lum_berry).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant weezing = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WEEZING).heldItem(PixelmonItems.expert_belt).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.SLUDGE_BOMB).build());
        return helper.setupSingleBattleBuilder(mrmime, weezing).forceChance().start().thenApply(controller -> {
            mrmime.attackOpponent(1);
            weezing.attackOpponent(1);
            controller.takeFullTurn();
            if (!helper.inRange(mrmime.asWrapper().getHealthDeficit(), 175, 208)) {
                return TestResult.failure("Neutralizing Gas should ignore damage-reducing abilities");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testNegateSelfHealingAbilities(BattleTestHelper helper) {
        TestParticipant breloom = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRELOOM).ability(AbilityRegistry.POISON_HEAL).moves(AttackRegistry.SWORDS_DANCE).build());
        TestParticipant weezing = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.TOXIC).build());
        return helper.setupSingleBattleBuilder(breloom, weezing).forceChance().start().thenApply(controller -> {
            breloom.attackSelf(1);
            weezing.attackOpponent(1);
            controller.takeFullTurn();
            if (breloom.asWrapper().hasFullHealth()) {
                return TestResult.failure("Neutralizing Gas should negate self-healing abilities");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testNegatesAbilitiesSupressingItemEffects(BattleTestHelper helper) {
        TestParticipant reuniclus = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REUNICLUS).ability(AbilityRegistry.MAGIC_GUARD).heldItem(PixelmonItems.life_orb).moves(AttackRegistry.SHADOW_BALL).build());
        TestParticipant weezing = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.REFLECT).build());
        return helper.setupSingleBattleBuilder(reuniclus, weezing).forceChance().start().thenApply(controller -> {
            reuniclus.attackOpponent(1);
            weezing.attackOpponent(1);
            controller.takeFullTurn();
            if (reuniclus.asWrapper().hasFullHealth()) {
                return TestResult.failure("Neutralizing Gas should negate abilities that suppress item effects");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testNegatesAbilitesThatModifyBoosts(BattleTestHelper helper) {
        TestParticipant shuckle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.CONTRARY).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.SUPERPOWER).build());
        TestParticipant weezing = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.SPORE).build());
        return helper.setupSingleBattleBuilder(shuckle, weezing).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                shuckle.attackOpponent(1);
                weezing.attackOpponent(1);
            });
            if (shuckle.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Neutralizing Gas should negate abilities that modify boosts");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testNegateAbilitiesActivationOnSwitchOut(BattleTestHelper helper) {
        Pokemon corsola = helper.createDefaultPokemon(PixelmonSpecies.CORSOLA).ability(AbilityRegistry.NATURAL_CURE).moves(AttackRegistry.U_TURN).build();
        Pokemon magikarp = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.RATTLED).moves(AttackRegistry.SPLASH).build();
        Pokemon weezing = helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.TOXIC).build();
        Pokemon typeNull = helper.createDefaultPokemon(PixelmonSpecies.TYPENULL).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.FACADE).build();
        TestParticipant teamOne = helper.createParticipant(corsola, magikarp);
        TestParticipant teamTwo = helper.createParticipant(weezing, typeNull);
        return helper.setupSingleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackOpponent(1);
                teamOne.switchPokemon(corsola, magikarp);
                teamTwo.attackAuto();
            });
            controller.takeFullTurn(() -> {
                teamOne.switchPokemon(magikarp, corsola);
                teamTwo.switchPokemon(weezing, typeNull);
            });
            if (!teamOne.asWrapper().hasStatus(StatusType.PoisonBadly)) {
                return TestResult.failure("Neutralizing Gas should negate abilites that activate on switch-out");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testNegatesAbilitiesModifyingMoveType(BattleTestHelper helper) {
        TestParticipant sylveon = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SYLVEON).ability(AbilityRegistry.PIXILATE).moves(AttackRegistry.HYPER_VOICE).build());
        TestParticipant gengar = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GENGAR).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.LASER_FOCUS).build());
        return helper.setupSingleBattleBuilder(sylveon, gengar).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                sylveon.attackOpponent(1);
                gengar.attackOpponent(1);
            });
            if (!gengar.asWrapper().hasFullHealth()) {
                return TestResult.failure("Neutralizing Gas should negate abilities that modify move type");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testNegatesAbilitiesThatDamageAttacker(BattleTestHelper helper) {
        TestParticipant ferrothorn = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.FERROTHORN).ability(AbilityRegistry.IRON_BARBS).moves(AttackRegistry.ROCK_POLISH).build());
        TestParticipant galarWeezing = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).form("galarian").moves(AttackRegistry.PAYBACK).build());
        return helper.setupSingleBattleBuilder(ferrothorn, galarWeezing).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                ferrothorn.attackOpponent(1);
                galarWeezing.attackOpponent(1);
            });
            if (!galarWeezing.asWrapper().hasFullHealth()) {
                return TestResult.failure("Neutralizing Gas should negate abilities that damage the attacker");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testNegatesPrimalWeatherAbilities(BattleTestHelper helper) {
        TestParticipant groudon = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GROUDON).heldItem(PixelmonItems.red_orb).moves(AttackRegistry.SLEEP_TALK).build());
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon weezing = helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamTwo = helper.createParticipant(wynaut, weezing);
        return helper.setupSingleBattleBuilder(groudon, teamTwo).forceChance().start().thenApply(controller -> {
            block6: {
                block5: {
                    Sunny sunny;
                    controller.takeFullTurn(() -> {
                        groudon.attackOpponent(1);
                        teamTwo.switchPokemon(wynaut, weezing);
                    });
                    Weather patt11069$temp = controller.globalStatusController.getWeather();
                    if (patt11069$temp instanceof Sunny) {
                        sunny = (Sunny)patt11069$temp;
                        if (sunny.extreme) {
                            return TestResult.failure("Desolate Land should be negated, turning off the weather");
                        }
                    }
                    controller.takeFullTurn(() -> {
                        groudon.attackOpponent(1);
                        teamTwo.switchPokemon(weezing, wynaut);
                    });
                    Weather patt11431$temp = controller.globalStatusController.getWeather();
                    if (!(patt11431$temp instanceof Sunny)) break block5;
                    sunny = (Sunny)patt11431$temp;
                    if (sunny.extreme) break block6;
                }
                return TestResult.failure("Desolate Land should be active again now that Neutralizing Gas is gone");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testImposterDoesNotActiveIfNeutralizingGasLeaves(BattleTestHelper helper) {
        TestParticipant ditto = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DITTO).ability(AbilityRegistry.IMPOSTER).moves(AttackRegistry.SLEEP_TALK).build());
        Pokemon greninja = helper.createDefaultPokemon(PixelmonSpecies.GRENINJA).ability(AbilityRegistry.TORRENT).moves(AttackRegistry.TELEKINESIS).build();
        Pokemon weezing = helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.SNORE).build();
        TestParticipant teamTwo = helper.createParticipant(weezing, greninja);
        return helper.setupSingleBattleBuilder(ditto, teamTwo).forceChance().start().thenApply(controller -> {
            if (ditto.asWrapper().hasStatus(StatusType.Transformed)) {
                return TestResult.failure("Imposter should not activate if Neutralizing Gas is present");
            }
            controller.takeFullTurn(() -> {
                ditto.attackOpponent(1);
                teamTwo.switchPokemon(weezing, greninja);
            });
            if (ditto.asWrapper().hasStatus(StatusType.Transformed)) {
                return TestResult.failure("Imposter should not activate when Neutralizing Gas leaves the field");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUnburdenPreventedWhenActiveOnField(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.UNBURDEN).heldItem(PixelmonItems.sitrus_berry).ev(BattleStatsType.HP, 4).moves(AttackRegistry.BELLY_DRUM).build());
        Pokemon whismur = helper.createDefaultPokemon(PixelmonSpecies.WHISMUR).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon pancham = helper.createDefaultPokemon(PixelmonSpecies.PANCHAM).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamTwo = helper.createParticipant(pancham, whismur);
        return helper.setupSingleBattleBuilder(wynaut, teamTwo).forceChance().start().thenApply(controller -> {
            int wynautSpeed = wynaut.asWrapper().getBattleStats().getStatWithMod(BattleStatsType.SPEED);
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                teamTwo.attackOpponent(1);
            });
            if (wynautSpeed != wynaut.asWrapper().getBattleStats().getStatWithMod(BattleStatsType.SPEED)) {
                return TestResult.failure("Neutralizing Gas should prevent Unburden's activation when it is active on the field");
            }
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                teamTwo.switchPokemon(pancham, whismur);
            });
            if (wynautSpeed != wynaut.asWrapper().getBattleStats().getStatWithMod(BattleStatsType.SPEED)) {
                return TestResult.failure("The chance for the unburden speed boost was missed so it should not be activating after!");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testGasNegatesUnburdenEffectWhenEnteringField(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.UNBURDEN).heldItem(PixelmonItems.sitrus_berry).ev(BattleStatsType.HP, 4).moves(AttackRegistry.BELLY_DRUM).build());
        Pokemon whismur = helper.createDefaultPokemon(PixelmonSpecies.WHISMUR).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon pancham = helper.createDefaultPokemon(PixelmonSpecies.PANCHAM).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamTwo = helper.createParticipant(whismur, pancham);
        return helper.setupSingleBattleBuilder(wynaut, teamTwo).forceChance().start().thenApply(controller -> {
            int wynautSpeed = wynaut.asWrapper().getBattleStats().getStatWithMod(BattleStatsType.SPEED);
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                teamTwo.attackOpponent(1);
            });
            controller.modifyStats();
            if (2 * wynautSpeed != wynaut.asWrapper().getBattleStats().getStatWithMod(BattleStatsType.SPEED)) {
                return TestResult.failure("Unburden failed to double the speed stat of Wynaut");
            }
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                teamTwo.switchPokemon(whismur, pancham);
            });
            if (wynautSpeed != wynaut.asWrapper().getBattleStats().getStatWithMod(BattleStatsType.SPEED)) {
                return TestResult.failure("Neutralizing gas should negate Unburden when entering the field");
            }
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                teamTwo.switchPokemon(pancham, whismur);
            });
            if (2 * wynautSpeed != wynaut.asWrapper().getBattleStats().getStatWithMod(BattleStatsType.SPEED)) {
                return TestResult.failure("Unburden failed to return to double the speed stat of Wynaut");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSlowStartWearsOffWhenNeutralizingGasAooears(BattleTestHelper helper) {
        TestParticipant regigigas = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGIGIGAS).ability(AbilityRegistry.SLOW_START).moves(AttackRegistry.SLEEP_TALK).build(), helper.createDefaultPokemon(PixelmonSpecies.ETERNATUS).moves(AttackRegistry.SLEEP_TALK).build());
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon weezing = helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamTwo = helper.createParticipant(wynaut, weezing);
        return helper.setupSingleBattleBuilder(regigigas, teamTwo).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            int slowStartSpeed = regigigas.asWrapper().getBattleStats().getStatWithMod(BattleStatsType.SPEED);
            controller.takeFullTurn(() -> {
                regigigas.attackOpponent(1);
                teamTwo.switchPokemon(wynaut, weezing);
            });
            int updatedSpeed = regigigas.asWrapper().getBattleStats().getStatWithMod(BattleStatsType.SPEED);
            if (slowStartSpeed * 2 != updatedSpeed) {
                return TestResult.failure("Neutralizing Gas should cause Slow Start to instantly wear off/restart when Neutralizing Gas leaves/enters the field");
            }
            controller.takeFullTurn(() -> {
                regigigas.attackOpponent(1);
                teamTwo.switchPokemon(weezing, wynaut);
            });
            updatedSpeed = regigigas.asWrapper().getBattleStats().getStatWithMod(BattleStatsType.SPEED);
            if (slowStartSpeed != updatedSpeed) {
                return TestResult.failure("Neutralizing Gas should cause Slow Start to instantly wear off/restart when Neutralizing Gas leaves/enters the field");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testGlutonyNotInstantlyEatingWhenLeaving(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.GLUTTONY).heldItem(PixelmonItems.aguav_berry).ev(BattleStatsType.HP, 4).moves(AttackRegistry.BELLY_DRUM).build());
        Pokemon pancham = helper.createDefaultPokemon(PixelmonSpecies.PANCHAM).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon whismur = helper.createDefaultPokemon(PixelmonSpecies.WHISMUR).level(1).moves(AttackRegistry.SEISMIC_TOSS).build();
        TestParticipant teamTwo = helper.createParticipant(pancham, whismur);
        return helper.setupSingleBattleBuilder(wynaut, teamTwo).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                teamTwo.attackOpponent(1);
            });
            if ((double)wynaut.asWrapper().getHealth() != Math.floor((double)wynaut.asWrapper().getMaxHealth() / 2.0)) {
                return TestResult.failure("Neutralizing Gas should not cause Gluttony to instantly eat Berries when Neutralizing Gas leaves the field");
            }
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                teamTwo.switchPokemon(pancham, whismur);
            });
            int health = wynaut.asWrapper().getHealth();
            double half = Math.floor((double)wynaut.asWrapper().getMaxHealth() / 2.0);
            if ((double)health != half) {
                return TestResult.failure("Neutralizing Gas should not cause Gluttony to instantly eat Berries when Neutralizing Gas leaves the field");
            }
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                teamTwo.attackOpponent(1);
            });
            int maxHealth = wynaut.asWrapper().getMaxHealth();
            if ((double)wynaut.asWrapper().getHealth() != Math.floor((double)maxHealth / 2.0) - 1.0 + Math.floor((double)maxHealth / 3.0)) {
                return TestResult.failure("Neutralizing Gas should not cause Gluttony to instantly eat Berries when Neutralizing Gas leaves the field");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testItDoesNotTriggerTwice(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.INTREPID_SWORD).moves(AttackRegistry.GASTRO_ACID, AttackRegistry.SIMPLE_BEAM).build());
        TestParticipant weezing = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(wynaut, weezing).forceChance().start().thenApply(controller -> {
            helper.skipTicks((BattleController)controller, 10);
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                weezing.attackOpponent(1);
            });
            if (wynaut.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("Neutralizing Gas should not trigger twice");
            }
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(2);
                weezing.attackOpponent(1);
            });
            if (wynaut.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("Neutralizing Gas should not trigger twice");
            }
            return TestResult.success();
        });
    }
}

