/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class NaturalCureTests {
    @BattleTest
    public static CompletableFuture<TestResult> testCuresEvenFromRoar(BattleTestHelper helper) {
        Pokemon celebi = helper.createDefaultPokemon(PixelmonSpecies.CELEBI).ability(AbilityRegistry.NATURAL_CURE).moves(AttackRegistry.LEECH_SEED).build();
        Pokemon swampert = helper.createDefaultPokemon(PixelmonSpecies.SWAMPERT).ability(AbilityRegistry.TORRENT).moves(AttackRegistry.SURF).build();
        TestParticipant teamA = helper.createParticipant(celebi, swampert);
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ZAPDOS).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.THUNDER_WAVE, AttackRegistry.ROAR).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(2);
                teamA.switchPokemon(celebi, swampert);
            });
            if (teamA.asWrapper().hasStatus(StatusType.Paralysis) || teamA.asWrapper(celebi).hasStatus(StatusType.Paralysis)) {
                return TestResult.failure("Celebi was not cured of Paralysis after switching out");
            }
            return TestResult.success();
        });
    }
}

